/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.ViewConfiguration;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ViewConfiguration.class)
public class ShadowViewConfiguration {
    private static final int SCROLL_BAR_SIZE = 10;
    private static final int PRESSED_STATE_DURATION = 125;
    private static final int LONG_PRESS_TIMEOUT = 500;
    private static final int TAP_TIMEOUT = 115;
    private static final int DOUBLE_TAP_TIMEOUT = 300;
    private static final int TOUCH_SLOP = 16;
    private static final int PAGING_TOUCH_SLOP = 32;
    private static final int DOUBLE_TAP_SLOP = 100;
    private static final int WINDOW_TOUCH_SLOP = 16;
    private static final int MAXIMUM_FLING_VELOCITY = 4000;
    private static final int MIN_MAXIMUM_DRAWING_CACHE_SIZE = 0x177000;
    private int edgeSlop;
    private int fadingEdgeLength;
    private int minimumFlingVelocity;
    private int maximumFlingVelocity;
    private int scrollbarSize;
    private int touchSlop;
    private int pagingTouchSlop;
    private int doubleTapSlop;
    private int windowTouchSlop;
    private int maximumDrawingCacheSize;
    private static boolean hasPermanentMenuKey = true;

    private void setup(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float density = metrics.density;
        this.edgeSlop = (int)(density * (float)ViewConfiguration.getEdgeSlop() + 0.5f);
        this.fadingEdgeLength = (int)(density * (float)ViewConfiguration.getFadingEdgeLength() + 0.5f);
        this.minimumFlingVelocity = (int)(density * (float)ViewConfiguration.getMinimumFlingVelocity() + 0.5f);
        this.maximumFlingVelocity = (int)(density * (float)ViewConfiguration.getMaximumFlingVelocity() + 0.5f);
        this.scrollbarSize = (int)(density * 10.0f + 0.5f);
        this.touchSlop = (int)(density * 16.0f + 0.5f);
        this.pagingTouchSlop = (int)(density * 32.0f + 0.5f);
        this.doubleTapSlop = (int)(density * 100.0f + 0.5f);
        this.windowTouchSlop = (int)(density * 16.0f + 0.5f);
        this.maximumDrawingCacheSize = Math.max(0x177000, 4 * metrics.widthPixels * metrics.heightPixels);
    }

    @Implementation
    protected static ViewConfiguration get(Context context) {
        ViewConfiguration viewConfiguration = new ViewConfiguration();
        ShadowViewConfiguration shadowViewConfiguration = (ShadowViewConfiguration)Shadow.extract((Object)viewConfiguration);
        shadowViewConfiguration.setup(context);
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            ((ViewConfigurationReflector)Reflector.reflector(ViewConfigurationReflector.class, (Object)viewConfiguration)).setConstructedWithContext(true);
        }
        return viewConfiguration;
    }

    @Implementation
    protected static int getScrollBarSize() {
        return 10;
    }

    @Implementation
    protected int getScaledScrollBarSize() {
        return this.scrollbarSize;
    }

    @Implementation
    protected int getScaledFadingEdgeLength() {
        return this.fadingEdgeLength;
    }

    @Implementation
    protected static int getPressedStateDuration() {
        return 125;
    }

    @Implementation
    protected static int getLongPressTimeout() {
        return 500;
    }

    @Implementation
    protected static int getTapTimeout() {
        return 115;
    }

    @Implementation
    protected static int getDoubleTapTimeout() {
        return 300;
    }

    @Implementation
    protected int getScaledEdgeSlop() {
        return this.edgeSlop;
    }

    @Implementation
    protected static int getTouchSlop() {
        return 16;
    }

    @Implementation
    protected int getScaledTouchSlop() {
        return this.touchSlop;
    }

    @Implementation
    protected int getScaledPagingTouchSlop() {
        return this.pagingTouchSlop;
    }

    @Implementation
    protected int getScaledDoubleTapSlop() {
        return this.doubleTapSlop;
    }

    @Implementation
    protected static int getWindowTouchSlop() {
        return 16;
    }

    @Implementation
    protected int getScaledWindowTouchSlop() {
        return this.windowTouchSlop;
    }

    @Implementation
    protected int getScaledMinimumFlingVelocity() {
        return this.minimumFlingVelocity;
    }

    @Implementation
    protected static int getMaximumFlingVelocity() {
        return 4000;
    }

    @Implementation
    protected int getScaledMaximumFlingVelocity() {
        return this.maximumFlingVelocity;
    }

    @Implementation
    protected int getScaledMaximumDrawingCacheSize() {
        return this.maximumDrawingCacheSize;
    }

    @Implementation
    protected boolean hasPermanentMenuKey() {
        return hasPermanentMenuKey;
    }

    public static void setHasPermanentMenuKey(boolean value) {
        hasPermanentMenuKey = value;
    }

    @ForType(value=ViewConfiguration.class)
    static interface ViewConfigurationReflector {
        @Accessor(value="mConstructedWithContext")
        public void setConstructedWithContext(boolean var1);
    }
}

