/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Paint;
import android.text.StaticLayout;
import android.text.TextPaint;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.LineBreakerNatives;
import org.robolectric.nativeruntime.MeasuredTextBuilderNatives;
import org.robolectric.nativeruntime.MeasuredTextNatives;
import org.robolectric.nativeruntime.NativeAllocationRegistryNatives;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowStaticLayout;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=StaticLayout.class, minSdk=26, maxSdk=28, looseSignatures=true, shadowPicker=Picker.class)
public class ShadowNativeStaticLayout {
    static final NativeObjRegistry<NativeStaticLayoutSetup> nativeObjectRegistry = new NativeObjRegistry(NativeStaticLayoutSetup.class);

    @Implementation(minSdk=28, maxSdk=28)
    protected static long nInit(int breakStrategy, int hyphenationFrequency, boolean isJustified, int[] indents, int[] leftPaddings, int[] rightPaddings) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return LineBreakerNatives.nInit((int)breakStrategy, (int)hyphenationFrequency, (boolean)isJustified, (int[])indents);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected static void nFinish(long nativePtr) {
        LineBreakerNatives.nFinishP((long)nativePtr);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected static int nComputeLineBreaks(Object nativePtr, Object text, Object measuredTextPtr, Object length, Object firstWidth, Object firstWidthLineCount, Object restWidth, Object variableTabStopsObject, Object defaultTabStop, Object indentsOffset, Object recycle, Object recycleLength, Object recycleBreaks, Object recycleWidths, Object recycleAscents, Object recycleDescents, Object recycleFlags, Object charWidths) {
        return LineBreakerNatives.nComputeLineBreaksP((long)((Long)nativePtr), (char[])((char[])text), (long)((Long)measuredTextPtr), (int)((Integer)length), (float)((Float)firstWidth).floatValue(), (int)((Integer)firstWidthLineCount), (float)((Float)restWidth).floatValue(), (float[])ShadowNativeStaticLayout.intsToFloat((int[])variableTabStopsObject), (float)((Number)defaultTabStop).floatValue(), (int)((Integer)indentsOffset), (Object)recycle, (int)((Integer)recycleLength), (int[])((int[])recycleBreaks), (float[])((float[])recycleWidths), (float[])((float[])recycleAscents), (float[])((float[])recycleDescents), (int[])((int[])recycleFlags), (float[])((float[])charWidths));
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static long nNewBuilder() {
        return nativeObjectRegistry.register((Object)new NativeStaticLayoutSetup());
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nFreeBuilder(long nativePtr) {
        NativeStaticLayoutSetup setup = (NativeStaticLayoutSetup)nativeObjectRegistry.getNativeObject(nativePtr);
        NativeAllocationRegistryNatives.applyFreeFunction((long)LineBreakerNatives.nGetReleaseResultFunc(), (long)setup.lineBreakerResultPtr);
        nativeObjectRegistry.unregister(nativePtr);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nFinishBuilder(long nativePtr) {
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static long nLoadHyphenator(ByteBuffer buf, int offset, int minPrefix, int minSuffix) {
        return 0L;
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nSetLocale(long nativePtr, String locale, long nativeHyphenator) {
        NativeStaticLayoutSetup setup = (NativeStaticLayoutSetup)nativeObjectRegistry.getNativeObject(nativePtr);
        setup.localePaint.setTextLocale(Locale.forLanguageTag(locale));
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nSetIndents(long nativePtr, int[] indents) {
        NativeStaticLayoutSetup setup = (NativeStaticLayoutSetup)nativeObjectRegistry.getNativeObject(nativePtr);
        setup.indents = indents;
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nSetupParagraph(long nativePtr, char[] text, int length, float firstWidth, int firstWidthLineCount, float restWidth, int[] variableTabStops, int defaultTabStop, int breakStrategy, int hyphenationFrequency, boolean isJustified) {
        NativeStaticLayoutSetup setup = (NativeStaticLayoutSetup)nativeObjectRegistry.getNativeObject(nativePtr);
        setup.text = text;
        setup.length = length;
        setup.firstWidth = firstWidth;
        setup.firstWidthLineCount = firstWidthLineCount;
        setup.restWidth = restWidth;
        setup.variableTabStops = variableTabStops;
        setup.defaultTabStop = defaultTabStop;
        setup.breakStrategy = breakStrategy;
        setup.hyphenationFrequency = hyphenationFrequency;
        setup.isJustified = isJustified;
        setup.measuredTextBuilderPtr = MeasuredTextBuilderNatives.nInitBuilder();
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static float nAddStyleRun(long nativePtr, long nativePaint, long nativeTypeface, int start, int end, boolean isRtl) {
        NativeStaticLayoutSetup setup = (NativeStaticLayoutSetup)nativeObjectRegistry.getNativeObject(nativePtr);
        MeasuredTextBuilderNatives.nAddStyleRun((long)setup.measuredTextBuilderPtr, (long)nativePaint, (int)start, (int)end, (boolean)isRtl);
        return 0.0f;
    }

    @Implementation
    protected static void nAddMeasuredRun(long nativePtr, int start, int end, float[] widths) {
        NativeStaticLayoutSetup setup = (NativeStaticLayoutSetup)nativeObjectRegistry.getNativeObject(nativePtr);
        MeasuredTextBuilderNatives.nAddStyleRun((long)setup.measuredTextBuilderPtr, (long)setup.localePaint.getNativeInstance(), (int)start, (int)end, (boolean)false);
    }

    @Implementation
    protected static void nAddReplacementRun(long nativePtr, int start, int end, float width) {
        NativeStaticLayoutSetup setup = (NativeStaticLayoutSetup)nativeObjectRegistry.getNativeObject(nativePtr);
        MeasuredTextBuilderNatives.nAddReplacementRun((long)setup.measuredTextBuilderPtr, (long)setup.localePaint.getNativeInstance(), (int)start, (int)end, (float)width);
    }

    @Implementation
    protected static void nGetWidths(long nativePtr, float[] widths) {
        NativeStaticLayoutSetup setup = (NativeStaticLayoutSetup)nativeObjectRegistry.getNativeObject(nativePtr);
        setup.measuredTextPtr = MeasuredTextBuilderNatives.nBuildMeasuredText((long)setup.measuredTextBuilderPtr, (long)0L, (char[])setup.text, (boolean)false, (boolean)false);
        for (int i = 0; i < setup.text.length; ++i) {
            widths[i] = MeasuredTextNatives.nGetCharWidthAt((long)setup.measuredTextPtr, (int)i);
        }
        MeasuredTextBuilderNatives.nFreeBuilder((long)setup.measuredTextBuilderPtr);
    }

    @Implementation
    protected static int nComputeLineBreaks(Object nativePtr, Object recycle, Object recycleBreaksObject, Object recycleWidthsObject, Object recycleFlagsObject, Object recycleLength) {
        int[] recycleBreaks = (int[])recycleBreaksObject;
        float[] recycleWidths = (float[])recycleWidthsObject;
        int[] recycleFlags = (int[])recycleFlagsObject;
        NativeStaticLayoutSetup setup = (NativeStaticLayoutSetup)nativeObjectRegistry.getNativeObject(((Long)nativePtr).longValue());
        long lineBreakerBuilderPtr = LineBreakerNatives.nInit((int)setup.breakStrategy, (int)setup.hyphenationFrequency, (boolean)setup.isJustified, (int[])setup.indents);
        setup.lineBreakerResultPtr = LineBreakerNatives.nComputeLineBreaks((long)lineBreakerBuilderPtr, (char[])setup.text, (long)setup.measuredTextPtr, (int)setup.length, (float)setup.firstWidth, (int)setup.firstWidthLineCount, (float)setup.restWidth, (float[])ShadowNativeStaticLayout.intsToFloat(setup.variableTabStops), (float)setup.defaultTabStop, (int)0);
        int lineCount = LineBreakerNatives.nGetLineCount((long)setup.lineBreakerResultPtr);
        if (lineCount > recycleBreaks.length) {
            recycleBreaks = new int[lineCount];
            recycleWidths = new float[lineCount];
            recycleFlags = new int[lineCount];
            ((LineBreaksReflector)Reflector.reflector(LineBreaksReflector.class, (Object)recycle)).setBreaks(recycleBreaks);
            ((LineBreaksReflector)Reflector.reflector(LineBreaksReflector.class, (Object)recycle)).setWidths(recycleWidths);
            ((LineBreaksReflector)Reflector.reflector(LineBreaksReflector.class, (Object)recycle)).setFlags(recycleFlags);
        }
        for (int i = 0; i < lineCount; ++i) {
            recycleBreaks[i] = LineBreakerNatives.nGetLineBreakOffset((long)setup.lineBreakerResultPtr, (int)i);
            recycleWidths[i] = LineBreakerNatives.nGetLineWidth((long)setup.lineBreakerResultPtr, (int)i);
            recycleFlags[i] = LineBreakerNatives.nGetLineFlag((long)setup.lineBreakerResultPtr, (int)i);
        }
        NativeAllocationRegistryNatives.applyFreeFunction((long)LineBreakerNatives.nGetReleaseFunc(), (long)lineBreakerBuilderPtr);
        NativeAllocationRegistryNatives.applyFreeFunction((long)MeasuredTextNatives.nGetReleaseFunc(), (long)setup.measuredTextPtr);
        return lineCount;
    }

    private static float[] intsToFloat(int[] intArray) {
        if (intArray == null) {
            return null;
        }
        float[] floatArray = new float[intArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            floatArray[i] = intArray[i];
        }
        return floatArray;
    }

    static final class NativeStaticLayoutSetup {
        char[] text;
        int length;
        float firstWidth;
        int firstWidthLineCount;
        float restWidth;
        int[] variableTabStops;
        int defaultTabStop;
        int breakStrategy;
        int hyphenationFrequency;
        boolean isJustified;
        int[] indents;
        Paint localePaint = new TextPaint();
        long measuredTextBuilderPtr;
        long measuredTextPtr;
        long lineBreakerResultPtr;

        NativeStaticLayoutSetup() {
        }
    }

    @ForType(className="android.text.StaticLayout$LineBreaks")
    static interface LineBreaksReflector {
        @Accessor(value="breaks")
        public int[] getBreaks();

        @Accessor(value="breaks")
        public void setBreaks(int[] var1);

        @Accessor(value="widths")
        public float[] getWidths();

        @Accessor(value="widths")
        public void setWidths(float[] var1);

        @Accessor(value="flags")
        public int[] getFlags();

        @Accessor(value="flags")
        public void setFlags(int[] var1);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowStaticLayout.class, ShadowNativeStaticLayout.class);
        }
    }
}

