/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.GestureDescription;
import android.graphics.ColorSpace;
import android.hardware.HardwareBuffer;
import android.os.Handler;
import android.os.SystemClock;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowService;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AccessibilityService.class)
public class ShadowAccessibilityService
extends ShadowService {
    private final List<Integer> globalActionsPerformed = new ArrayList<Integer>();
    private List<AccessibilityNodeInfo.AccessibilityAction> systemActions;
    private final ArrayListMultimap<Integer, AccessibilityWindowInfo> windows = ArrayListMultimap.create();
    private final List<GestureDispatch> gesturesDispatched = new ArrayList<GestureDispatch>();
    private boolean canDispatchGestures = true;
    private int takeScreenshotErrorCode = 1;
    private boolean isScreenshotError = false;

    @Implementation
    protected boolean performGlobalAction(int action) {
        this.globalActionsPerformed.add(action);
        return true;
    }

    public List<Integer> getGlobalActionsPerformed() {
        return this.globalActionsPerformed;
    }

    @Implementation(minSdk=31)
    protected List<AccessibilityNodeInfo.AccessibilityAction> getSystemActions() {
        return this.systemActions;
    }

    public final void setSystemActions(List<AccessibilityNodeInfo.AccessibilityAction> systemActions) {
        this.systemActions = systemActions;
    }

    @Implementation(minSdk=21)
    protected List<AccessibilityWindowInfo> getWindows() {
        List windowInfos = this.windows.get((Object)0);
        if (windowInfos != null) {
            return new ArrayList<AccessibilityWindowInfo>(windowInfos);
        }
        return new ArrayList<AccessibilityWindowInfo>();
    }

    @Implementation(minSdk=30)
    protected SparseArray<List<AccessibilityWindowInfo>> getWindowsOnAllDisplays() {
        return this.cloneWindowOnAllDisplays();
    }

    private SparseArray<List<AccessibilityWindowInfo>> cloneWindowOnAllDisplays() {
        SparseArray anotherArray = new SparseArray();
        Iterator iterator = this.windows.keySet().iterator();
        while (iterator.hasNext()) {
            int displayId = (Integer)iterator.next();
            anotherArray.put(displayId, (Object)this.windows.get((Object)displayId));
        }
        if (anotherArray.get(0) == null) {
            anotherArray.put(0, new ArrayList());
        }
        return anotherArray;
    }

    @Implementation(minSdk=24)
    protected boolean dispatchGesture(GestureDescription gesture, AccessibilityService.GestureResultCallback callback, Handler handler) {
        if (this.canDispatchGestures) {
            this.gesturesDispatched.add(new GestureDispatch(gesture, callback));
        }
        return this.canDispatchGestures;
    }

    @Implementation(minSdk=30)
    protected void takeScreenshot(int displayId, Executor executor, AccessibilityService.TakeScreenshotCallback callback) {
        executor.execute(() -> {
            if (this.isScreenshotError) {
                callback.onFailure(this.takeScreenshotErrorCode);
                return;
            }
            HardwareBuffer hardwareBuffer = HardwareBuffer.create((int)1, (int)1, (int)1, (int)1, (long)0L);
            ColorSpace colorSpace = ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
            long timestamp = SystemClock.elapsedRealtimeNanos();
            AccessibilityService.ScreenshotResult screenshotResult = (AccessibilityService.ScreenshotResult)ReflectionHelpers.callConstructor(AccessibilityService.ScreenshotResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{new ReflectionHelpers.ClassParameter(HardwareBuffer.class, (Object)hardwareBuffer), new ReflectionHelpers.ClassParameter(ColorSpace.class, (Object)colorSpace), new ReflectionHelpers.ClassParameter(Long.TYPE, (Object)timestamp)});
            callback.onSuccess(screenshotResult);
        });
    }

    public void setTakeScreenshotErrorCode(int errorCode) {
        this.isScreenshotError = true;
        this.takeScreenshotErrorCode = errorCode;
    }

    public void unsetTakeScreenshotErrorCode() {
        this.isScreenshotError = false;
    }

    public void setWindows(List<AccessibilityWindowInfo> windowList) {
        this.setWindowsOnDisplay(0, windowList);
    }

    public void setWindowsOnDisplay(int displayId, @Nullable List<AccessibilityWindowInfo> windowList) {
        this.windows.removeAll((Object)displayId);
        if (windowList != null) {
            this.windows.putAll((Object)displayId, windowList);
        }
    }

    public List<GestureDispatch> getGesturesDispatched() {
        return this.gesturesDispatched;
    }

    public void setCanDispatchGestures(boolean canDispatchGestures) {
        this.canDispatchGestures = canDispatchGestures;
    }

    public static final class GestureDispatch {
        private final GestureDescription description;
        private final AccessibilityService.GestureResultCallback callback;

        public GestureDispatch(GestureDescription description, AccessibilityService.GestureResultCallback callback) {
            this.description = description;
            this.callback = callback;
        }

        public GestureDescription description() {
            return this.description;
        }

        public AccessibilityService.GestureResultCallback callback() {
            return this.callback;
        }
    }
}

