/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.uwb.AdapterStateListener;
import android.uwb.UwbManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=AdapterStateListener.class, minSdk=31, isInAndroidSdk=false)
public class ShadowUwbAdapterStateListener {
    private int adapterState = 0;
    private final Map<UwbManager.AdapterStateCallback, Executor> callbackToExecutorMap = new HashMap<UwbManager.AdapterStateCallback, Executor>();

    @Implementation
    protected int getAdapterState() {
        return this.adapterState;
    }

    @Implementation
    protected void setEnabled(boolean isEnabled) {
        if (isEnabled == (this.adapterState != 0)) {
            return;
        }
        this.adapterState = isEnabled ? 1 : 0;
        this.onAdapterStateChanged(this.adapterState, 2);
    }

    @Implementation
    protected void onAdapterStateChanged(int state, int reason) {
        this.adapterState = state;
        for (Map.Entry<UwbManager.AdapterStateCallback, Executor> callbackToExecutor : this.callbackToExecutorMap.entrySet()) {
            callbackToExecutor.getValue().execute(() -> ((UwbManager.AdapterStateCallback)callbackToExecutor.getKey()).onStateChanged(state, reason));
        }
    }

    @Implementation
    protected void register(Executor executor, UwbManager.AdapterStateCallback callback) {
        this.callbackToExecutorMap.put(callback, executor);
        executor.execute(() -> callback.onStateChanged(this.adapterState, 4));
    }

    @Implementation
    protected void unregister(UwbManager.AdapterStateCallback callback) {
        this.callbackToExecutorMap.remove(callback);
    }
}

