/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.Uri;
import android.os.IncidentManager;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=IncidentManager.class, minSdk=30, isInAndroidSdk=false)
public class ShadowIncidentManager {
    private final Map<Uri, IncidentManager.IncidentReport> reports = new LinkedHashMap<Uri, IncidentManager.IncidentReport>();

    @Implementation
    @NonNull
    protected List<Uri> getIncidentReportList(String receiverClass) {
        return new ArrayList<Uri>(this.reports.keySet());
    }

    @Implementation
    protected IncidentManager.IncidentReport getIncidentReport(Uri uri) {
        return this.reports.get(uri);
    }

    @Implementation
    protected void deleteIncidentReports(Uri uri) {
        this.reports.remove(uri);
    }

    public void addIncidentReport(Uri uri, IncidentManager.IncidentReport report) {
        this.reports.put(uri, report);
    }
}

