/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Application;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothProfileServiceConnection;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.content.AttributionSource;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.provider.Settings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowBluetoothServerSocket;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=BluetoothAdapter.class, looseSignatures=true)
public class ShadowBluetoothAdapter {
    @RealObject
    private BluetoothAdapter realAdapter;
    private static final int ADDRESS_LENGTH = 17;
    private static final int LE_MAXIMUM_ADVERTISING_DATA_LENGTH = 31;
    private static final int LE_MAXIMUM_ADVERTISING_DATA_LENGTH_EXTENDED = 1650;
    public static final int RFCOMM_LISTENER_START_FAILED_UUID_IN_USE = 2000;
    public static final int RFCOMM_LISTENER_OPERATION_FAILED_NO_MATCHING_SERVICE_RECORD = 2001;
    public static final int RFCOMM_LISTENER_FAILED_TO_CLOSE_SERVER_SOCKET = 2004;
    private static boolean isBluetoothSupported = true;
    private static final Map<String, BluetoothDevice> deviceCache = new HashMap<String, BluetoothDevice>();
    private Set<BluetoothDevice> bondedDevices = new HashSet<BluetoothDevice>();
    private Set<BluetoothAdapter.LeScanCallback> leScanCallbacks = new HashSet<BluetoothAdapter.LeScanCallback>();
    private boolean isDiscovering;
    private String address;
    private int state;
    private String name = "DefaultBluetoothDeviceName";
    private int scanMode = 20;
    private Duration discoverableTimeout;
    private boolean isBleScanAlwaysAvailable = true;
    private boolean isMultipleAdvertisementSupported = true;
    private boolean isLeExtendedAdvertisingSupported = true;
    private boolean isOverridingProxyBehavior;
    private final Map<Integer, Integer> profileConnectionStateData = new HashMap<Integer, Integer>();
    private final Map<Integer, BluetoothProfile> profileProxies = new HashMap<Integer, BluetoothProfile>();
    private final ConcurrentMap<UUID, BackgroundRfcommServerEntry> backgroundRfcommServers = new ConcurrentHashMap<UUID, BackgroundRfcommServerEntry>();
    private final Map<Integer, List<BluetoothProfile.ServiceListener>> bluetoothProfileServiceListeners = new HashMap<Integer, List<BluetoothProfile.ServiceListener>>();

    @Resetter
    public static void reset() {
        ShadowBluetoothAdapter.setIsBluetoothSupported(true);
        BluetoothAdapterReflector bluetoothReflector = (BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class);
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (apiLevel >= 21 && apiLevel <= 30) {
            bluetoothReflector.setSBluetoothLeAdvertiser(null);
            bluetoothReflector.setSBluetoothLeScanner(null);
        }
        bluetoothReflector.setAdapter(null);
        deviceCache.clear();
    }

    @Implementation
    protected static BluetoothAdapter getDefaultAdapter() {
        if (!isBluetoothSupported) {
            return null;
        }
        return ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class)).getDefaultAdapter();
    }

    @Implementation(minSdk=33)
    protected static Object createAdapter(Object attributionSource) {
        IBluetoothManager service = (IBluetoothManager)ReflectionHelpers.createDelegatingProxy(IBluetoothManager.class, (Object)new BluetoothManagerDelegate());
        return ReflectionHelpers.callConstructor(BluetoothAdapter.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(IBluetoothManager.class, (Object)service), ReflectionHelpers.ClassParameter.from(AttributionSource.class, (Object)attributionSource)});
    }

    public static void setIsBluetoothSupported(boolean supported) {
        isBluetoothSupported = supported;
    }

    @Deprecated
    public void setBluetoothLeAdvertiser(BluetoothLeAdvertiser advertiser) {
        if (RuntimeEnvironment.getApiLevel() <= 22) {
            ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).setSBluetoothLeAdvertiser(advertiser);
        } else {
            ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).setBluetoothLeAdvertiser(advertiser);
        }
    }

    @Implementation
    protected synchronized BluetoothDevice getRemoteDevice(String address) {
        if (!deviceCache.containsKey(address)) {
            deviceCache.put(address, ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).getRemoteDevice(address));
        }
        return deviceCache.get(address);
    }

    @Implementation
    protected Set<BluetoothDevice> getBondedDevices() {
        return Collections.unmodifiableSet(this.bondedDevices);
    }

    public void setBondedDevices(Set<BluetoothDevice> bluetoothDevices) {
        this.bondedDevices = bluetoothDevices;
    }

    @Implementation
    protected BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String serviceName, UUID uuid) {
        return ShadowBluetoothServerSocket.newInstance(1, false, false, new ParcelUuid(uuid));
    }

    @Implementation
    protected BluetoothServerSocket listenUsingRfcommWithServiceRecord(String serviceName, UUID uuid) throws IOException {
        return ShadowBluetoothServerSocket.newInstance(1, false, true, new ParcelUuid(uuid));
    }

    @Implementation(minSdk=29)
    protected BluetoothServerSocket listenUsingInsecureL2capChannel() throws IOException {
        return ShadowBluetoothServerSocket.newInstance(3, false, true, null);
    }

    @Implementation(minSdk=29)
    protected BluetoothServerSocket listenUsingL2capChannel() throws IOException {
        return ShadowBluetoothServerSocket.newInstance(3, false, true, null);
    }

    @Implementation
    protected boolean startDiscovery() {
        this.isDiscovering = true;
        return true;
    }

    @Implementation
    protected boolean cancelDiscovery() {
        this.isDiscovering = false;
        return true;
    }

    @Implementation(minSdk=23)
    protected boolean isBleScanAlwaysAvailable() {
        return this.isBleScanAlwaysAvailable;
    }

    @Implementation(minSdk=23)
    public int getLeState() {
        if (ShadowBluetoothAdapter.isAirplaneMode()) {
            return 10;
        }
        if (this.isEnabled()) {
            return 12;
        }
        if (this.isBleScanAlwaysAvailable()) {
            return 15;
        }
        return 10;
    }

    private static boolean isAirplaneMode() {
        Application context = RuntimeEnvironment.getApplication();
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    @Implementation(minSdk=18)
    protected boolean startLeScan(BluetoothAdapter.LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    @Implementation(minSdk=18)
    protected boolean startLeScan(UUID[] serviceUuids, BluetoothAdapter.LeScanCallback callback) {
        if (Build.VERSION.SDK_INT >= 23 && !this.realAdapter.isLeEnabled()) {
            return false;
        }
        this.leScanCallbacks.add(callback);
        return true;
    }

    @Implementation(minSdk=18)
    protected void stopLeScan(BluetoothAdapter.LeScanCallback callback) {
        this.leScanCallbacks.remove(callback);
    }

    public Set<BluetoothAdapter.LeScanCallback> getLeScanCallbacks() {
        return Collections.unmodifiableSet(this.leScanCallbacks);
    }

    public BluetoothAdapter.LeScanCallback getSingleLeScanCallback() {
        if (this.leScanCallbacks.size() != 1) {
            throw new IllegalStateException("There are " + this.leScanCallbacks.size() + " callbacks");
        }
        return this.leScanCallbacks.iterator().next();
    }

    @Implementation
    protected boolean isDiscovering() {
        return this.isDiscovering;
    }

    @Implementation
    protected boolean isEnabled() {
        return this.state == 12;
    }

    @Implementation
    protected boolean enable() {
        this.setState(12);
        return true;
    }

    @Implementation
    protected boolean disable() {
        this.setState(10);
        return true;
    }

    @Implementation(minSdk=17)
    protected boolean disable(boolean persist) {
        return this.disable();
    }

    @Implementation
    protected String getAddress() {
        return this.address;
    }

    @Implementation
    protected int getState() {
        return this.state;
    }

    @Implementation
    protected String getName() {
        return this.name;
    }

    @Implementation
    protected boolean setName(String name) {
        this.name = name;
        return true;
    }

    @Implementation
    protected Object setScanMode(int scanMode) {
        boolean result = true;
        if (scanMode != 21 && scanMode != 23 && scanMode != 20) {
            result = false;
        }
        this.scanMode = scanMode;
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            return result ? 0 : Integer.MAX_VALUE;
        }
        return result;
    }

    @Implementation(maxSdk=29)
    protected boolean setScanMode(int scanMode, int discoverableTimeout) {
        this.setDiscoverableTimeout(discoverableTimeout);
        return (Boolean)this.setScanMode(scanMode);
    }

    @Implementation(minSdk=30, maxSdk=32)
    protected boolean setScanMode(int scanMode, long durationMillis) {
        int durationSeconds = Math.toIntExact(durationMillis / 1000L);
        this.setDiscoverableTimeout(durationSeconds);
        return (Boolean)this.setScanMode(scanMode);
    }

    @Implementation
    protected int getScanMode() {
        return this.scanMode;
    }

    @Implementation
    protected Object getDiscoverableTimeout() {
        if (RuntimeEnvironment.getApiLevel() <= 32) {
            return (int)this.discoverableTimeout.toSeconds();
        }
        return this.discoverableTimeout;
    }

    @Implementation(maxSdk=32)
    protected void setDiscoverableTimeout(int timeout) {
        this.discoverableTimeout = Duration.ofSeconds(timeout);
    }

    @Implementation(minSdk=33)
    protected int setDiscoverableTimeout(Duration timeout) {
        if (this.getState() != 12) {
            return 1;
        }
        if (timeout.toSeconds() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout in seconds must be less or equal to 2147483647");
        }
        this.discoverableTimeout = timeout;
        return 0;
    }

    @Implementation(minSdk=21)
    protected boolean isMultipleAdvertisementSupported() {
        return this.isMultipleAdvertisementSupported;
    }

    @Implementation
    protected static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    @Implementation
    protected int getProfileConnectionState(int profile) {
        Integer state = this.profileConnectionStateData.get(profile);
        if (state == null) {
            return 0;
        }
        return state;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setState(int state) {
        this.state = state;
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void setBleScanAlwaysAvailable(boolean alwaysAvailable) {
        this.isBleScanAlwaysAvailable = alwaysAvailable;
    }

    public void setIsMultipleAdvertisementSupported(boolean supported) {
        this.isMultipleAdvertisementSupported = supported;
    }

    public void setProfileConnectionState(int profile, int state) {
        this.profileConnectionStateData.put(profile, state);
    }

    public void setProfileProxy(int profile, @Nullable BluetoothProfile proxy) {
        this.isOverridingProxyBehavior = true;
        if (proxy != null) {
            this.profileProxies.put(profile, proxy);
        }
    }

    public boolean hasActiveProfileProxy(int profile) {
        return this.profileProxies.get(profile) != null;
    }

    @Implementation
    protected boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (!this.isOverridingProxyBehavior) {
            return ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).getProfileProxy(context, listener, profile);
        }
        BluetoothProfile proxy = this.profileProxies.get(profile);
        if (proxy == null) {
            return false;
        }
        listener.onServiceConnected(profile, proxy);
        List<BluetoothProfile.ServiceListener> profileListeners = this.bluetoothProfileServiceListeners.get(profile);
        if (profileListeners != null) {
            profileListeners.add(listener);
        } else {
            this.bluetoothProfileServiceListeners.put(profile, new ArrayList(ImmutableList.of((Object)listener)));
        }
        return true;
    }

    @Implementation
    protected void closeProfileProxy(int profile, BluetoothProfile proxy) {
        if (!this.isOverridingProxyBehavior) {
            ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).closeProfileProxy(profile, proxy);
            return;
        }
        if (proxy != null && proxy.equals(this.profileProxies.get(profile))) {
            this.profileProxies.remove(profile);
            List<BluetoothProfile.ServiceListener> profileListeners = this.bluetoothProfileServiceListeners.remove(profile);
            if (profileListeners != null) {
                for (BluetoothProfile.ServiceListener listener : profileListeners) {
                    listener.onServiceDisconnected(profile);
                }
            }
        }
    }

    @Implementation(minSdk=26)
    protected boolean isLeExtendedAdvertisingSupported() {
        return this.isLeExtendedAdvertisingSupported;
    }

    public void setIsLeExtendedAdvertisingSupported(boolean supported) {
        this.isLeExtendedAdvertisingSupported = supported;
    }

    @Implementation(minSdk=26)
    protected int getLeMaximumAdvertisingDataLength() {
        return this.isLeExtendedAdvertisingSupported ? 1650 : 31;
    }

    @Implementation(minSdk=33)
    protected int startRfcommServer(String name, UUID uuid, PendingIntent pendingIntent) {
        if ((Shadows.shadowOf(pendingIntent).getFlags() & 0x4000000) == 0) {
            throw new IllegalArgumentException("RFCOMM server PendingIntent must be marked immutable");
        }
        boolean[] isNewServerSocket = new boolean[]{false};
        this.backgroundRfcommServers.computeIfAbsent(uuid, unused -> {
            isNewServerSocket[0] = true;
            return new BackgroundRfcommServerEntry(uuid, pendingIntent);
        });
        return isNewServerSocket[0] ? 0 : 2000;
    }

    @Implementation(minSdk=33)
    protected int stopRfcommServer(UUID uuid) {
        BackgroundRfcommServerEntry entry = (BackgroundRfcommServerEntry)this.backgroundRfcommServers.remove(uuid);
        if (entry == null) {
            return 2001;
        }
        try {
            entry.serverSocket.close();
            return 0;
        }
        catch (IOException e) {
            return 2004;
        }
    }

    @Implementation(minSdk=33)
    @Nullable
    protected BluetoothSocket retrieveConnectedRfcommSocket(UUID uuid) {
        BackgroundRfcommServerEntry serverEntry = (BackgroundRfcommServerEntry)this.backgroundRfcommServers.get(uuid);
        try {
            return serverEntry == null ? null : serverEntry.serverSocket.accept(0);
        }
        catch (IOException e) {
            return null;
        }
    }

    public BluetoothSocket addIncomingRfcommConnection(BluetoothDevice remoteDevice, UUID uuid) throws PendingIntent.CanceledException {
        BackgroundRfcommServerEntry entry = (BackgroundRfcommServerEntry)this.backgroundRfcommServers.get(uuid);
        if (entry == null) {
            throw new IllegalArgumentException("No RFCOMM server open for UUID: " + uuid);
        }
        BluetoothSocket socket = Shadows.shadowOf(entry.serverSocket).deviceConnected(remoteDevice);
        entry.pendingIntent.send();
        return socket;
    }

    public Set<UUID> getRegisteredRfcommServerUuids() {
        return Set.of(this.backgroundRfcommServers.keySet().toArray(new UUID[0]));
    }

    @ForType(value=BluetoothAdapter.class)
    static interface BluetoothAdapterReflector {
        @Static
        @Direct
        public BluetoothAdapter getDefaultAdapter();

        @Direct
        public boolean getProfileProxy(Context var1, BluetoothProfile.ServiceListener var2, int var3);

        @Direct
        public void closeProfileProxy(int var1, BluetoothProfile var2);

        @Direct
        public BluetoothDevice getRemoteDevice(String var1);

        @Accessor(value="sAdapter")
        @Static
        public void setAdapter(BluetoothAdapter var1);

        @Accessor(value="mBluetoothLeAdvertiser")
        @Deprecated
        public void setBluetoothLeAdvertiser(BluetoothLeAdvertiser var1);

        @Accessor(value="sBluetoothLeAdvertiser")
        @Static
        public void setSBluetoothLeAdvertiser(BluetoothLeAdvertiser var1);

        @Accessor(value="sBluetoothLeScanner")
        @Static
        public void setSBluetoothLeScanner(BluetoothLeScanner var1);
    }

    private static class BluetoothManagerDelegate {
        private BluetoothManagerDelegate() {
        }

        public boolean bindBluetoothProfileService(int bluetoothProfile, String serviceName, IBluetoothProfileServiceConnection proxy) {
            if (!BluetoothAdapter.getDefaultAdapter().isEnabled()) {
                return false;
            }
            try {
                proxy.onServiceConnected(null, null);
            }
            catch (RemoteException e) {
                return false;
            }
            return true;
        }

        public void unbindBluetoothProfileService(int bluetoothProfile, IBluetoothProfileServiceConnection proxy) {
            try {
                proxy.onServiceDisconnected(null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private static final class BackgroundRfcommServerEntry {
        final BluetoothServerSocket serverSocket;
        final PendingIntent pendingIntent;

        BackgroundRfcommServerEntry(UUID uuid, PendingIntent pendingIntent) {
            this.serverSocket = ShadowBluetoothServerSocket.newInstance(1, true, true, new ParcelUuid(uuid));
            this.pendingIntent = pendingIntent;
        }
    }
}

