/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.Application;
import android.app.Instrumentation;
import android.app.ResultInfo;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.IBinder;
import com.android.internal.content.ReferrerIntent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.Logger;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ActivityThread.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowActivityThread {
    private static ApplicationInfo applicationInfo;
    @RealObject
    protected ActivityThread realActivityThread;
    @ReflectorObject
    protected _ActivityThread_ activityThreadReflector;

    @Implementation
    public static Object getPackageManager() {
        Class<?> iPackageManagerClass;
        final ClassLoader classLoader = ShadowActivityThread.class.getClassLoader();
        try {
            iPackageManagerClass = classLoader.loadClass("android.content.pm.IPackageManager");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Proxy.newProxyInstance(classLoader, new Class[]{iPackageManagerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, @Nonnull Method method, Object[] args) throws Exception {
                if (method.getName().equals("getApplicationInfo")) {
                    String packageName = (String)args[0];
                    int flags = ((Number)args[1]).intValue();
                    if (packageName.equals(applicationInfo.packageName)) {
                        return applicationInfo;
                    }
                    try {
                        return RuntimeEnvironment.getApplication().getPackageManager().getApplicationInfo(packageName, flags);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        return null;
                    }
                }
                if (method.getName().equals("notifyPackageUse")) {
                    return null;
                }
                if (method.getName().equals("getPackageInstaller")) {
                    try {
                        Class<?> iPackageInstallerClass = classLoader.loadClass("android.content.pm.IPackageInstaller");
                        return ReflectionHelpers.createNullProxy(iPackageInstallerClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (method.getName().equals("hasSystemFeature")) {
                    String featureName = (String)args[0];
                    return RuntimeEnvironment.getApplication().getPackageManager().hasSystemFeature(featureName);
                }
                if (method.getName().equals("getServiceInfo")) {
                    ComponentName componentName = (ComponentName)args[0];
                    if (args[1] instanceof PackageManager.ComponentInfoFlags) {
                        return RuntimeEnvironment.getApplication().getPackageManager().getServiceInfo(componentName, (PackageManager.ComponentInfoFlags)args[1]);
                    }
                    return RuntimeEnvironment.getApplication().getPackageManager().getServiceInfo(componentName, ((Number)args[1]).intValue());
                }
                throw new UnsupportedOperationException("sorry, not supporting " + method + " yet!");
            }
        });
    }

    @Implementation
    public static Object currentActivityThread() {
        return RuntimeEnvironment.getActivityThread();
    }

    @Implementation
    protected static Application currentApplication() {
        return ((ActivityThread)ShadowActivityThread.currentActivityThread()).getApplication();
    }

    @Implementation
    protected Application getApplication() {
        Application currentApplication = ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)this.realActivityThread)).getInitialApplication();
        if (currentApplication == null) {
            return RuntimeEnvironment.getApplication();
        }
        return currentApplication;
    }

    @Implementation(minSdk=30)
    public static Object getPermissionManager() {
        Class<?> iPermissionManagerClass;
        ClassLoader classLoader = ShadowActivityThread.class.getClassLoader();
        try {
            iPermissionManagerClass = classLoader.loadClass("android.permission.IPermissionManager");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Proxy.newProxyInstance(classLoader, new Class[]{iPermissionManagerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, @Nonnull Method method, Object[] args) throws Exception {
                if (method.getName().equals("getSplitPermissions")) {
                    return Collections.emptyList();
                }
                return method.getDefaultValue();
            }
        });
    }

    @Implementation(minSdk=24, maxSdk=27)
    protected void requestRelaunchActivity(IBinder token, List<ResultInfo> pendingResults, List<ReferrerIntent> pendingNewIntents, int configChanges, boolean notResumed, Configuration config, Configuration overrideConfig, boolean fromServer, boolean preserveWindow) {
        ActivityThread.ActivityClientRecord record = this.activityThreadReflector.getActivities().get(token);
        if (record != null) {
            ((ActivityClientRecordReflector)Reflector.reflector(ActivityClientRecordReflector.class, (Object)record)).getActivity().recreate();
        }
    }

    void registerActivityLaunch(Intent intent, ActivityInfo activityInfo, Activity activity, IBinder token) {
        ActivityThread.ActivityClientRecord record = RuntimeEnvironment.getApiLevel() >= 28 ? new ActivityThread.ActivityClientRecord() : (ActivityThread.ActivityClientRecord)ReflectionHelpers.callConstructor(ActivityThread.ActivityClientRecord.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ActivityClientRecordReflector recordReflector = (ActivityClientRecordReflector)Reflector.reflector(ActivityClientRecordReflector.class, (Object)record);
        recordReflector.setToken(token);
        recordReflector.setIntent(intent);
        recordReflector.setActivityInfo(activityInfo);
        recordReflector.setActivity(activity);
        ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)this.realActivityThread)).getActivities().put(token, record);
    }

    void removeActivity(IBinder token) {
        ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)this.realActivityThread)).getActivities().remove(token);
    }

    @Deprecated
    public static void setApplicationInfo(ApplicationInfo applicationInfo) {
        ShadowActivityThread.applicationInfo = applicationInfo;
    }

    static ApplicationInfo getApplicationInfo() {
        return applicationInfo;
    }

    public void setCompatConfiguration(Configuration androidConfiguration) {
        if (RuntimeEnvironment.getApiLevel() >= 31) {
            Class activityThreadInternalClass = ReflectionHelpers.loadClass((ClassLoader)this.getClass().getClassLoader(), (String)"android.app.ActivityThreadInternal");
            Class configurationControllerClass = ReflectionHelpers.loadClass((ClassLoader)this.getClass().getClassLoader(), (String)"android.app.ConfigurationController");
            Object configController = ReflectionHelpers.callConstructor((Class)configurationControllerClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from((Class)activityThreadInternalClass, (Object)this.realActivityThread)});
            ReflectionHelpers.callInstanceMethod((Object)configController, (String)"setCompatConfiguration", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Configuration.class, (Object)androidConfiguration)});
            androidConfiguration = (Configuration)ReflectionHelpers.callInstanceMethod((Object)configController, (String)"getCompatConfiguration", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            ReflectionHelpers.setField((Object)this.realActivityThread, (String)"mConfigurationController", (Object)configController);
        } else {
            ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)this.realActivityThread)).setCompatConfiguration(androidConfiguration);
        }
    }

    @Resetter
    public static void reset() {
        Object activityThread = RuntimeEnvironment.getActivityThread();
        if (activityThread == null) {
            Logger.warn((String)"RuntimeEnvironment.getActivityThread() is null, an error likely occurred during test initialization.", (Object[])new Object[0]);
        } else {
            ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)activityThread)).getActivities().clear();
        }
    }

    @ForType(value=ActivityThread.class)
    public static interface _ActivityThread_ {
        @Accessor(value="mBoundApplication")
        public void setBoundApplication(Object var1);

        @Accessor(value="mBoundApplication")
        public Object getBoundApplication();

        @Accessor(value="mCompatConfiguration")
        public void setCompatConfiguration(Configuration var1);

        @Accessor(value="mInitialApplication")
        public void setInitialApplication(Application var1);

        @Accessor(value="mInitialApplication")
        public Application getInitialApplication();

        @Accessor(value="mInstrumentation")
        public void setInstrumentation(Instrumentation var1);

        @Accessor(value="mActivities")
        public Map<IBinder, ActivityThread.ActivityClientRecord> getActivities();
    }

    @ForType(value=ActivityThread.ActivityClientRecord.class)
    private static interface ActivityClientRecordReflector {
        @Accessor(value="activity")
        public void setActivity(Activity var1);

        @Accessor(value="activity")
        public Activity getActivity();

        @Accessor(value="token")
        public void setToken(IBinder var1);

        @Accessor(value="intent")
        public void setIntent(Intent var1);

        @Accessor(value="activityInfo")
        public void setActivityInfo(ActivityInfo var1);
    }

    @ForType(className="android.app.ActivityThread$AppBindData")
    public static interface _AppBindData_ {
        @Accessor(value="appInfo")
        public void setAppInfo(ApplicationInfo var1);

        @Accessor(value="processName")
        public void setProcessName(String var1);
    }
}

