/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;

public class CachedPathIteratorFactory {
    private static final float PRECISION = 0.002f;
    private final int mWindingRule;
    private final int[] mTypes;
    private final float[][] mCoordinates;
    private final float[] mSegmentsLength;
    private final float mTotalLength;

    public CachedPathIteratorFactory(PathIterator iterator) {
        this.mWindingRule = iterator.getWindingRule();
        ArrayList<Integer> typesArray = new ArrayList<Integer>();
        ArrayList<float[]> pointsArray = new ArrayList<float[]>();
        float[] points = new float[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(points);
            int nPoints = CachedPathIteratorFactory.getNumberOfPoints(type) * 2;
            typesArray.add(type);
            float[] itemPoints = new float[nPoints];
            System.arraycopy(points, 0, itemPoints, 0, nPoints);
            pointsArray.add(itemPoints);
            iterator.next();
        }
        this.mTypes = new int[typesArray.size()];
        this.mCoordinates = new float[this.mTypes.length][];
        for (int i = 0; i < typesArray.size(); ++i) {
            this.mTypes[i] = (Integer)typesArray.get(i);
            this.mCoordinates[i] = (float[])pointsArray.get(i);
        }
        this.mSegmentsLength = new float[this.mTypes.length];
        CubicCurve2D.Float cubicCurve = new CubicCurve2D.Float();
        QuadCurve2D.Float quadCurve = new QuadCurve2D.Float();
        float lastX = 0.0f;
        float lastY = 0.0f;
        float totalLength = 0.0f;
        for (int i = 0; i < this.mTypes.length; ++i) {
            switch (this.mTypes[i]) {
                case 3: {
                    float f = lastX;
                    float f2 = lastY;
                    lastX = this.mCoordinates[i][4];
                    lastY = this.mCoordinates[i][5];
                    cubicCurve.setCurve(f, f2, this.mCoordinates[i][0], this.mCoordinates[i][1], this.mCoordinates[i][2], this.mCoordinates[i][3], lastX, lastY);
                    this.mSegmentsLength[i] = CachedPathIteratorFactory.getFlatPathLength(cubicCurve.getPathIterator(null, 0.002f));
                    break;
                }
                case 2: {
                    float f = lastX;
                    float f3 = lastY;
                    lastX = this.mCoordinates[i][2];
                    lastY = this.mCoordinates[i][3];
                    quadCurve.setCurve(f, f3, this.mCoordinates[i][0], this.mCoordinates[i][1], lastX, lastY);
                    this.mSegmentsLength[i] = CachedPathIteratorFactory.getFlatPathLength(quadCurve.getPathIterator(null, 0.002f));
                    break;
                }
                case 4: {
                    double d = lastX;
                    double d2 = lastY;
                    lastX = this.mCoordinates[0][0];
                    lastY = this.mCoordinates[0][1];
                    this.mSegmentsLength[i] = (float)Point2D.distance(d, d2, lastX, lastY);
                    this.mCoordinates[i] = new float[2];
                    this.mTypes[i] = 1;
                    this.mCoordinates[i][0] = this.mCoordinates[0][0];
                    this.mCoordinates[i][1] = this.mCoordinates[0][1];
                    break;
                }
                case 0: {
                    this.mSegmentsLength[i] = 0.0f;
                    lastX = this.mCoordinates[i][0];
                    lastY = this.mCoordinates[i][1];
                    break;
                }
                case 1: {
                    this.mSegmentsLength[i] = (float)Point2D.distance(lastX, lastY, this.mCoordinates[i][0], this.mCoordinates[i][1]);
                    lastX = this.mCoordinates[i][0];
                    lastY = this.mCoordinates[i][1];
                    break;
                }
            }
            totalLength += this.mSegmentsLength[i];
        }
        this.mTotalLength = totalLength;
    }

    private static void quadCurveSegment(float[] coords, float t0, float t1) {
        float mt = t0 + (t1 - t0) / 2.0f;
        float mu = 1.0f - mt;
        float mx = mu * mu * coords[0] + 2.0f * mu * mt * coords[2] + mt * mt * coords[4];
        float my = mu * mu * coords[1] + 2.0f * mu * mt * coords[3] + mt * mt * coords[5];
        float u0 = 1.0f - t0;
        float u1 = 1.0f - t1;
        coords[0] = coords[0] * u0 * u0 + coords[2] * 2.0f * t0 * u0 + coords[4] * t0 * t0;
        coords[1] = coords[1] * u0 * u0 + coords[3] * 2.0f * t0 * u0 + coords[5] * t0 * t0;
        coords[4] = coords[0] * u1 * u1 + coords[2] * 2.0f * t1 * u1 + coords[4] * t1 * t1;
        coords[5] = coords[1] * u1 * u1 + coords[3] * 2.0f * t1 * u1 + coords[5] * t1 * t1;
        coords[2] = 2.0f * mx - coords[0] / 2.0f - coords[4] / 2.0f;
        coords[3] = 2.0f * my - coords[1] / 2.0f - coords[5] / 2.0f;
    }

    private static void cubicCurveSegment(float[] coords, float t0, float t1) {
        float u0 = 1.0f - t0;
        float u1 = 1.0f - t1;
        float qxa = coords[0] * u0 * u0 + coords[2] * 2.0f * t0 * u0 + coords[4] * t0 * t0;
        float qxb = coords[0] * u1 * u1 + coords[2] * 2.0f * t1 * u1 + coords[4] * t1 * t1;
        float qxc = coords[2] * u0 * u0 + coords[4] * 2.0f * t0 * u0 + coords[6] * t0 * t0;
        float qxd = coords[2] * u1 * u1 + coords[4] * 2.0f * t1 * u1 + coords[6] * t1 * t1;
        float qya = coords[1] * u0 * u0 + coords[3] * 2.0f * t0 * u0 + coords[5] * t0 * t0;
        float qyb = coords[1] * u1 * u1 + coords[3] * 2.0f * t1 * u1 + coords[5] * t1 * t1;
        float qyc = coords[3] * u0 * u0 + coords[5] * 2.0f * t0 * u0 + coords[7] * t0 * t0;
        float qyd = coords[3] * u1 * u1 + coords[5] * 2.0f * t1 * u1 + coords[7] * t1 * t1;
        coords[0] = qxa * u0 + qxc * t0;
        coords[1] = qya * u0 + qyc * t0;
        coords[2] = qxa * u1 + qxc * t1;
        coords[3] = qya * u1 + qyc * t1;
        coords[4] = qxb * u0 + qxd * t0;
        coords[5] = qyb * u0 + qyd * t0;
        coords[6] = qxb * u1 + qxd * t1;
        coords[7] = qyb * u1 + qyd * t1;
    }

    private static void getShapeEndPoint(int type, float[] coords, float[] point) {
        int pointIndex = (CachedPathIteratorFactory.getNumberOfPoints(type) - 1) * 2;
        point[0] = coords[pointIndex];
        point[1] = coords[pointIndex + 1];
    }

    private static int getNumberOfPoints(int segmentType) {
        switch (segmentType) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 0;
            }
        }
        return 1;
    }

    private static float getFlatPathLength(PathIterator iterator) {
        float[] segment = new float[6];
        float totalLength = 0.0f;
        float[] previousPoint = new float[2];
        boolean isFirstPoint = true;
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(segment);
            assert (type == 1 || type == 4 || type == 0);
            if (!isFirstPoint && type != 0) {
                totalLength += (float)Point2D.distance(previousPoint[0], previousPoint[1], segment[0], segment[1]);
            } else {
                isFirstPoint = false;
            }
            previousPoint[0] = segment[0];
            previousPoint[1] = segment[1];
            iterator.next();
        }
        return totalLength;
    }

    private void getPointAtLength(int type, float[] coords, float lastX, float lastY, float t, float[] point) {
        if (type == 1) {
            point[0] = lastX + (coords[0] - lastX) * t;
            point[1] = lastY + (coords[1] - lastY) * t;
            return;
        }
        float[] curve = new float[8];
        int lastPointIndex = (CachedPathIteratorFactory.getNumberOfPoints(type) - 1) * 2;
        System.arraycopy(coords, 0, curve, 2, coords.length);
        curve[0] = lastX;
        curve[1] = lastY;
        if (type == 3) {
            CachedPathIteratorFactory.cubicCurveSegment(curve, 0.0f, t);
        } else {
            CachedPathIteratorFactory.quadCurveSegment(curve, 0.0f, t);
        }
        point[0] = curve[2 + lastPointIndex];
        point[1] = curve[2 + lastPointIndex + 1];
    }

    public CachedPathIterator iterator() {
        return new CachedPathIterator();
    }

    public class CachedPathIterator
    implements PathIterator {
        private int mNextIndex;
        private int mCurrentType;
        private float[] mCurrentCoords = new float[6];
        private float mCurrentSegmentLength;
        private float mOffsetLength;
        private float[] mLastPoint = new float[2];
        private boolean isIteratorDone;

        private CachedPathIterator() {
            this.next();
        }

        public float getCurrentSegmentLength() {
            return this.mCurrentSegmentLength;
        }

        @Override
        public int getWindingRule() {
            return CachedPathIteratorFactory.this.mWindingRule;
        }

        @Override
        public boolean isDone() {
            return this.isIteratorDone;
        }

        @Override
        public void next() {
            if (this.mNextIndex >= CachedPathIteratorFactory.this.mTypes.length) {
                this.isIteratorDone = true;
                return;
            }
            if (this.mNextIndex >= 1) {
                CachedPathIteratorFactory.getShapeEndPoint(this.mCurrentType, this.mCurrentCoords, this.mLastPoint);
            } else {
                this.mLastPoint[1] = 0.0f;
                this.mLastPoint[0] = 0.0f;
            }
            this.mCurrentType = CachedPathIteratorFactory.this.mTypes[this.mNextIndex];
            this.mCurrentSegmentLength = CachedPathIteratorFactory.this.mSegmentsLength[this.mNextIndex] - this.mOffsetLength;
            if (this.mOffsetLength > 0.0f && (this.mCurrentType == 3 || this.mCurrentType == 2)) {
                float[] points = new float[8];
                if (this.mNextIndex < 1) {
                    points[1] = 0.0f;
                    points[0] = 0.0f;
                } else {
                    CachedPathIteratorFactory.getShapeEndPoint(CachedPathIteratorFactory.this.mTypes[this.mNextIndex - 1], CachedPathIteratorFactory.this.mCoordinates[this.mNextIndex - 1], points);
                }
                System.arraycopy(CachedPathIteratorFactory.this.mCoordinates[this.mNextIndex], 0, points, 2, CachedPathIteratorFactory.this.mCoordinates[this.mNextIndex].length);
                float t0 = (CachedPathIteratorFactory.this.mSegmentsLength[this.mNextIndex] - this.mCurrentSegmentLength) / CachedPathIteratorFactory.this.mSegmentsLength[this.mNextIndex];
                if (this.mCurrentType == 3) {
                    CachedPathIteratorFactory.cubicCurveSegment(points, t0, 1.0f);
                } else {
                    CachedPathIteratorFactory.quadCurveSegment(points, t0, 1.0f);
                }
                System.arraycopy(points, 2, this.mCurrentCoords, 0, CachedPathIteratorFactory.this.mCoordinates[this.mNextIndex].length);
            } else {
                System.arraycopy(CachedPathIteratorFactory.this.mCoordinates[this.mNextIndex], 0, this.mCurrentCoords, 0, CachedPathIteratorFactory.this.mCoordinates[this.mNextIndex].length);
            }
            this.mOffsetLength = 0.0f;
            ++this.mNextIndex;
        }

        @Override
        public int currentSegment(float[] coords) {
            System.arraycopy(this.mCurrentCoords, 0, coords, 0, CachedPathIteratorFactory.getNumberOfPoints(this.mCurrentType) * 2);
            return this.mCurrentType;
        }

        @Override
        public int currentSegment(double[] coords) {
            throw new UnsupportedOperationException();
        }

        public void getCurrentSegmentEnd(float[] point) {
            point[0] = this.mLastPoint[0];
            point[1] = this.mLastPoint[1];
        }

        public void jumpToSegment(float length) {
            this.isIteratorDone = false;
            if (length <= 0.0f) {
                this.mNextIndex = 0;
                return;
            }
            float accLength = 0.0f;
            float[] lastPoint = new float[2];
            this.mNextIndex = 0;
            while (this.mNextIndex < CachedPathIteratorFactory.this.mTypes.length) {
                float segmentLength = CachedPathIteratorFactory.this.mSegmentsLength[this.mNextIndex];
                if (accLength + segmentLength >= length && CachedPathIteratorFactory.this.mTypes[this.mNextIndex] != 0) {
                    float[] estimatedPoint = new float[2];
                    CachedPathIteratorFactory.this.getPointAtLength(CachedPathIteratorFactory.this.mTypes[this.mNextIndex], CachedPathIteratorFactory.this.mCoordinates[this.mNextIndex], lastPoint[0], lastPoint[1], (length - accLength) / segmentLength, estimatedPoint);
                    this.mCurrentType = 0;
                    this.mCurrentCoords[0] = estimatedPoint[0];
                    this.mCurrentCoords[1] = estimatedPoint[1];
                    this.mCurrentSegmentLength = 0.0f;
                    this.mOffsetLength = length - accLength;
                    return;
                }
                accLength += segmentLength;
                CachedPathIteratorFactory.getShapeEndPoint(CachedPathIteratorFactory.this.mTypes[this.mNextIndex], CachedPathIteratorFactory.this.mCoordinates[this.mNextIndex], lastPoint);
                ++this.mNextIndex;
            }
        }

        public int currentSegment(float[] coords, float length) {
            int type = this.currentSegment(coords);
            if (this.mCurrentSegmentLength <= length || type == 0) {
                return type;
            }
            float t = length / this.getCurrentSegmentLength();
            switch (type) {
                case 2: 
                case 3: {
                    float[] curve = new float[8];
                    curve[0] = this.mLastPoint[0];
                    curve[1] = this.mLastPoint[1];
                    System.arraycopy(coords, 0, curve, 2, coords.length);
                    if (type == 3) {
                        CachedPathIteratorFactory.cubicCurveSegment(curve, 0.0f, t);
                    } else {
                        CachedPathIteratorFactory.quadCurveSegment(curve, 0.0f, t);
                    }
                    System.arraycopy(curve, 2, coords, 0, coords.length);
                    break;
                }
                default: {
                    float[] point = new float[2];
                    CachedPathIteratorFactory.this.getPointAtLength(type, coords, this.mLastPoint[0], this.mLastPoint[1], t, point);
                    coords[0] = point[0];
                    coords[1] = point[1];
                }
            }
            return type;
        }

        public float getTotalLength() {
            return CachedPathIteratorFactory.this.mTotalLength;
        }
    }
}

