/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.location.Address;
import android.location.Geocoder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=Geocoder.class)
public final class ShadowGeocoder {
    private static boolean isPresent = true;
    private List<Address> fromLocation = new ArrayList<Address>();

    @Implementation
    protected static boolean isPresent() {
        return isPresent;
    }

    @Implementation
    protected List<Address> getFromLocation(double latitude, double longitude, int maxResults) throws IOException {
        Preconditions.checkArgument((-90.0 <= latitude && latitude <= 90.0 ? 1 : 0) != 0, (String)"Latitude must be between -90 and 90, got %s", (Object)latitude);
        Preconditions.checkArgument((-180.0 <= longitude && longitude <= 180.0 ? 1 : 0) != 0, (String)"Longitude must be between -180 and 180, got %s", (Object)longitude);
        return this.fromLocation.subList(0, Math.min(maxResults, this.fromLocation.size()));
    }

    @Implementation(minSdk=33)
    protected void getFromLocation(double latitude, double longitude, int maxResults, Geocoder.GeocodeListener listener) throws IOException {
        Preconditions.checkArgument((-90.0 <= latitude && latitude <= 90.0 ? 1 : 0) != 0, (String)"Latitude must be between -90 and 90, got %s", (Object)latitude);
        Preconditions.checkArgument((-180.0 <= longitude && longitude <= 180.0 ? 1 : 0) != 0, (String)"Longitude must be between -180 and 180, got %s", (Object)longitude);
        listener.onGeocode(this.fromLocation.subList(0, Math.min(maxResults, this.fromLocation.size())));
    }

    public static void setIsPresent(boolean value) {
        isPresent = value;
    }

    public void setFromLocation(List<Address> list) {
        this.fromLocation = list;
    }

    @Resetter
    public static void reset() {
        isPresent = true;
    }
}

