/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.res.Configuration;
import android.hardware.display.BrightnessChangeEvent;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayInfo;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.auto.value.AutoBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.Bootstrap;
import org.robolectric.android.internal.DisplayConfig;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.AutoBuilder_ShadowDisplayManager_ModeBuilder;
import org.robolectric.shadows.ShadowColorDisplayManager;
import org.robolectric.shadows.ShadowDisplayManagerGlobal;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.util.Consumer;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=DisplayManager.class, minSdk=17, looseSignatures=true)
public class ShadowDisplayManager {
    @RealObject
    private DisplayManager realDisplayManager;
    private Context context;
    private static final HashMap<Integer, Boolean> displayIsNaturallyPortrait = new HashMap();

    @Resetter
    public static void reset() {
        displayIsNaturallyPortrait.clear();
    }

    @Implementation
    protected void __constructor__(Context context) {
        this.context = context;
        Shadow.invokeConstructor(DisplayManager.class, (Object)this.realDisplayManager, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }

    public static int addDisplay(String qualifiersStr) {
        int id2 = ShadowDisplayManager.getShadowDisplayManagerGlobal().addDisplay(ShadowDisplayManager.createDisplayInfo(qualifiersStr, null));
        ShadowLooper.shadowMainLooper().idle();
        return id2;
    }

    public static void configureDefaultDisplay(Configuration configuration, DisplayMetrics displayMetrics) {
        ShadowDisplayManagerGlobal shadowDisplayManagerGlobal = ShadowDisplayManager.getShadowDisplayManagerGlobal();
        if (DisplayManagerGlobal.getInstance().getDisplayIds().length != 0) {
            throw new IllegalStateException("this method should only be called by Robolectric");
        }
        shadowDisplayManagerGlobal.addDisplay(ShadowDisplayManager.createDisplayInfo(configuration, displayMetrics, true));
    }

    private static DisplayInfo createDisplayInfo(Configuration configuration, DisplayMetrics displayMetrics, boolean isNaturallyPortrait) {
        int widthPx = (int)((float)configuration.screenWidthDp * displayMetrics.density);
        int heightPx = (int)((float)configuration.screenHeightDp * displayMetrics.density);
        DisplayInfo displayInfo = new DisplayInfo();
        displayInfo.name = "Built-in screen";
        if (Build.VERSION.SDK_INT >= 23) {
            displayInfo.uniqueId = "screen0";
        }
        displayInfo.appWidth = widthPx;
        displayInfo.appHeight = heightPx;
        ShadowDisplayManager.fixNominalDimens(displayInfo);
        displayInfo.logicalWidth = widthPx;
        displayInfo.logicalHeight = heightPx;
        int n = configuration.orientation == 1 ? (isNaturallyPortrait ? 0 : 1) : (displayInfo.rotation = isNaturallyPortrait ? 1 : 0);
        if (Build.VERSION.SDK_INT >= 23) {
            displayInfo.modeId = 0;
            displayInfo.defaultModeId = 0;
            displayInfo.supportedModes = new Display.Mode[]{new Display.Mode(0, widthPx, heightPx, 60.0f)};
        }
        displayInfo.logicalDensityDpi = displayMetrics.densityDpi;
        displayInfo.physicalXDpi = displayMetrics.densityDpi;
        displayInfo.physicalYDpi = displayMetrics.densityDpi;
        if (Build.VERSION.SDK_INT >= 21) {
            displayInfo.state = 2;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            displayInfo.getAppMetrics(displayMetrics);
        }
        return displayInfo;
    }

    private static DisplayInfo createDisplayInfo(String qualifiersStr, @Nullable Integer displayId) {
        DisplayInfo baseDisplayInfo = displayId != null ? DisplayManagerGlobal.getInstance().getDisplayInfo(displayId.intValue()) : null;
        Configuration configuration = new Configuration();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        boolean isNaturallyPortrait = Objects.requireNonNull(displayIsNaturallyPortrait.getOrDefault(displayId, true));
        if (qualifiersStr.startsWith("+") && baseDisplayInfo != null) {
            configuration.orientation = ShadowDisplayManager.isRotated(baseDisplayInfo.rotation) ? (isNaturallyPortrait ? 2 : 1) : (isNaturallyPortrait ? 1 : 2);
            configuration.screenWidthDp = baseDisplayInfo.logicalWidth * 160 / baseDisplayInfo.logicalDensityDpi;
            configuration.screenHeightDp = baseDisplayInfo.logicalHeight * 160 / baseDisplayInfo.logicalDensityDpi;
            configuration.densityDpi = baseDisplayInfo.logicalDensityDpi;
            displayMetrics.densityDpi = baseDisplayInfo.logicalDensityDpi;
            displayMetrics.density = (float)baseDisplayInfo.logicalDensityDpi * 0.00625f;
        }
        Bootstrap.applyQualifiers(qualifiersStr, RuntimeEnvironment.getApiLevel(), configuration, displayMetrics);
        return ShadowDisplayManager.createDisplayInfo(configuration, displayMetrics, isNaturallyPortrait);
    }

    private static boolean isRotated(int rotation) {
        return rotation == 1 || rotation == 3;
    }

    private static void fixNominalDimens(DisplayInfo displayInfo) {
        int smallest = Math.min(displayInfo.appWidth, displayInfo.appHeight);
        int largest = Math.max(displayInfo.appWidth, displayInfo.appHeight);
        displayInfo.smallestNominalAppWidth = smallest;
        displayInfo.smallestNominalAppHeight = smallest;
        displayInfo.largestNominalAppWidth = largest;
        displayInfo.largestNominalAppHeight = largest;
    }

    public static void changeDisplay(int displayId, String qualifiersStr) {
        DisplayInfo displayInfo = ShadowDisplayManager.createDisplayInfo(qualifiersStr, displayId);
        ShadowDisplayManager.getShadowDisplayManagerGlobal().changeDisplay(displayId, displayInfo);
        ShadowLooper.shadowMainLooper().idle();
    }

    public static void setNaturallyPortrait(int displayId, boolean isNaturallyPortrait) {
        displayIsNaturallyPortrait.put(displayId, isNaturallyPortrait);
        ShadowDisplayManager.changeDisplay(displayId, (Consumer<DisplayConfig>)((Consumer)config -> {
            boolean isPortrait;
            boolean isRotated = ShadowDisplayManager.isRotated(config.rotation);
            boolean bl = isPortrait = config.logicalHeight > config.logicalWidth;
            if ((isNaturallyPortrait ^ isPortrait) != isRotated) {
                config.rotation = isNaturallyPortrait ^ isPortrait ? 1 : 0;
            }
        }));
        ShadowLooper.shadowMainLooper().idle();
    }

    public static void setSupportedModes(int displayId, Display.Mode ... supportedModes) {
        if (Build.VERSION.SDK_INT < 23) {
            throw new UnsupportedOperationException("multiple display modes not supported before M");
        }
        DisplayInfo displayInfo = DisplayManagerGlobal.getInstance().getDisplayInfo(displayId);
        displayInfo.supportedModes = supportedModes;
        ShadowDisplayManager.getShadowDisplayManagerGlobal().changeDisplay(displayId, displayInfo);
        ShadowLooper.shadowMainLooper().idle();
    }

    static void changeDisplay(int displayId, Consumer<DisplayConfig> consumer) {
        DisplayInfo displayInfo = DisplayManagerGlobal.getInstance().getDisplayInfo(displayId);
        if (displayInfo != null) {
            DisplayConfig displayConfig = new DisplayConfig(displayInfo);
            consumer.accept((Object)displayConfig);
            displayConfig.copyTo(displayInfo);
            ShadowDisplayManager.fixNominalDimens(displayInfo);
        }
        ShadowDisplayManager.getShadowDisplayManagerGlobal().changeDisplay(displayId, displayInfo);
    }

    public static void removeDisplay(int displayId) {
        ShadowDisplayManager.getShadowDisplayManagerGlobal().removeDisplay(displayId);
        ShadowLooper.shadowMainLooper().idle();
    }

    public float getSaturationLevel() {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            ShadowColorDisplayManager shadowCdm = (ShadowColorDisplayManager)Shadow.extract((Object)this.context.getSystemService("color_display"));
            return (float)shadowCdm.getSaturationLevel() / 100.0f;
        }
        return ShadowDisplayManager.getShadowDisplayManagerGlobal().getSaturationLevel();
    }

    @Implementation(minSdk=28)
    public void setSaturationLevel(float level) {
        ((DisplayManagerReflector)Reflector.reflector(DisplayManagerReflector.class, (Object)this.realDisplayManager)).setSaturationLevel(level);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected void setBrightnessConfiguration(Object config) {
        this.setBrightnessConfigurationForUser(config, 0, this.context.getPackageName());
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected void setBrightnessConfigurationForUser(Object config, Object userId, Object packageName) {
        ShadowDisplayManager.getShadowDisplayManagerGlobal().setBrightnessConfigurationForUser(config, userId, packageName);
    }

    public static void setDefaultBrightnessConfiguration(Object config) {
        ShadowDisplayManager.getShadowDisplayManagerGlobal().setDefaultBrightnessConfiguration(config);
    }

    public static void setBrightnessEvents(List<BrightnessChangeEvent> events) {
        ShadowDisplayManager.getShadowDisplayManagerGlobal().setBrightnessEvents(events);
    }

    private static ShadowDisplayManagerGlobal getShadowDisplayManagerGlobal() {
        if (Build.VERSION.SDK_INT < 17) {
            throw new UnsupportedOperationException("multiple displays not supported in Jelly Bean");
        }
        return (ShadowDisplayManagerGlobal)Shadow.extract((Object)DisplayManagerGlobal.getInstance());
    }

    @RequiresApi(api=23)
    static Display.Mode displayModeOf(int modeId, int width, int height, float refreshRate) {
        return new Display.Mode(modeId, width, height, refreshRate);
    }

    @ForType(value=DisplayManager.class)
    static interface DisplayManagerReflector {
        @Direct
        public void setSaturationLevel(float var1);
    }

    @RequiresApi(api=23)
    @AutoBuilder(callMethod="displayModeOf")
    public static abstract class ModeBuilder {
        public static ModeBuilder modeBuilder(int modeId) {
            return new AutoBuilder_ShadowDisplayManager_ModeBuilder().setModeId(modeId);
        }

        abstract ModeBuilder setModeId(int var1);

        public abstract ModeBuilder setWidth(int var1);

        public abstract ModeBuilder setHeight(int var1);

        public abstract ModeBuilder setRefreshRate(float var1);

        public abstract Display.Mode build();
    }
}

