/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.util;

import android.app.Application;
import android.content.Context;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;

public abstract class AppSingletonizer<T> {
    private final Class<T> clazz;

    public AppSingletonizer(Class<T> clazz) {
        this.clazz = clazz;
    }

    public synchronized T getInstance(Context context) {
        Application applicationContext = (Application)context.getApplicationContext();
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)applicationContext);
        T instance = this.get(shadowApplication);
        if (instance == null) {
            instance = this.createInstance(applicationContext);
            this.set(shadowApplication, instance);
        }
        return instance;
    }

    protected abstract T get(ShadowApplication var1);

    protected abstract void set(ShadowApplication var1, T var2);

    protected T createInstance(Application applicationContext) {
        return (T)Shadow.newInstanceOf(this.clazz);
    }
}

