/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowConnectivityManager;
import org.robolectric.shadows.ShadowNetworkInfo;
import org.robolectric.shadows.ShadowWifiConfiguration;
import org.robolectric.shadows.ShadowWifiInfo;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=WifiManager.class)
public class ShadowWifiManager {
    private static final int LOCAL_HOST = 2130706433;
    private static float sSignalLevelInPercent = 1.0f;
    private boolean accessWifiStatePermission = true;
    private boolean wifiEnabled = true;
    private boolean wasSaved = false;
    private WifiInfo wifiInfo;
    private List<ScanResult> scanResults;
    private final Map<Integer, WifiConfiguration> networkIdToConfiguredNetworks = new LinkedHashMap<Integer, WifiConfiguration>();
    private Pair<Integer, Boolean> lastEnabledNetwork;
    private DhcpInfo dhcpInfo;
    private boolean isScanAlwaysAvailable = true;
    private boolean startScanSucceeds = true;
    private boolean is5GHzBandSupported = false;

    @Implementation
    protected boolean setWifiEnabled(boolean wifiEnabled) {
        this.checkAccessWifiStatePermission();
        this.wifiEnabled = wifiEnabled;
        return true;
    }

    @Implementation
    protected boolean isWifiEnabled() {
        this.checkAccessWifiStatePermission();
        return this.wifiEnabled;
    }

    @Implementation
    protected int getWifiState() {
        if (this.isWifiEnabled()) {
            return 3;
        }
        return 1;
    }

    @Implementation
    protected WifiInfo getConnectionInfo() {
        this.checkAccessWifiStatePermission();
        if (this.wifiInfo == null) {
            this.wifiInfo = (WifiInfo)ReflectionHelpers.callConstructor(WifiInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        return this.wifiInfo;
    }

    @Implementation(minSdk=21)
    protected boolean is5GHzBandSupported() {
        return this.is5GHzBandSupported;
    }

    public void setIs5GHzBandSupported(boolean is5GHzBandSupported) {
        this.is5GHzBandSupported = is5GHzBandSupported;
    }

    public void setConnectionInfo(WifiInfo wifiInfo) {
        this.wifiInfo = wifiInfo;
    }

    public void setStartScanSucceeds(boolean succeeds) {
        this.startScanSucceeds = succeeds;
    }

    @Implementation
    protected List<ScanResult> getScanResults() {
        return this.scanResults;
    }

    @Implementation
    protected List<WifiConfiguration> getConfiguredNetworks() {
        ArrayList<WifiConfiguration> wifiConfigurations = new ArrayList<WifiConfiguration>();
        for (WifiConfiguration wifiConfiguration : this.networkIdToConfiguredNetworks.values()) {
            wifiConfigurations.add(wifiConfiguration);
        }
        return wifiConfigurations;
    }

    @Implementation(minSdk=21)
    protected List<WifiConfiguration> getPrivilegedConfiguredNetworks() {
        return this.getConfiguredNetworks();
    }

    @Implementation
    protected int addNetwork(WifiConfiguration config) {
        int networkId = this.networkIdToConfiguredNetworks.size();
        config.networkId = -1;
        this.networkIdToConfiguredNetworks.put(networkId, this.makeCopy(config, networkId));
        return networkId;
    }

    @Implementation
    protected boolean removeNetwork(int netId) {
        this.networkIdToConfiguredNetworks.remove(netId);
        return true;
    }

    @Implementation
    protected int updateNetwork(WifiConfiguration config) {
        if (config == null || config.networkId < 0) {
            return -1;
        }
        this.networkIdToConfiguredNetworks.put(config.networkId, this.makeCopy(config, config.networkId));
        return config.networkId;
    }

    @Implementation
    protected boolean saveConfiguration() {
        this.wasSaved = true;
        return true;
    }

    @Implementation
    protected boolean enableNetwork(int netId, boolean disableOthers) {
        this.lastEnabledNetwork = new Pair((Object)netId, (Object)disableOthers);
        return true;
    }

    @Implementation
    protected WifiManager.WifiLock createWifiLock(int lockType, String tag) {
        return (WifiManager.WifiLock)ReflectionHelpers.callConstructor(WifiManager.WifiLock.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    protected WifiManager.WifiLock createWifiLock(String tag) {
        return this.createWifiLock(1, tag);
    }

    @Implementation
    protected static int calculateSignalLevel(int rssi, int numLevels) {
        return (int)(sSignalLevelInPercent * (float)(numLevels - 1));
    }

    @Implementation
    protected boolean startScan() {
        return this.startScanSucceeds;
    }

    @Implementation
    protected DhcpInfo getDhcpInfo() {
        return this.dhcpInfo;
    }

    @Implementation(minSdk=18)
    protected boolean isScanAlwaysAvailable() {
        return this.isScanAlwaysAvailable;
    }

    @HiddenApi
    @Implementation(minSdk=19)
    protected void connect(WifiConfiguration wifiConfiguration, WifiManager.ActionListener listener) {
        WifiInfo wifiInfo = this.getConnectionInfo();
        String ssid = ShadowWifiManager.isQuoted(wifiConfiguration.SSID) ? ShadowWifiManager.stripQuotes(wifiConfiguration.SSID) : wifiConfiguration.SSID;
        ShadowWifiInfo shadowWifiInfo = (ShadowWifiInfo)Shadow.extract((Object)wifiInfo);
        shadowWifiInfo.setSSID(ssid);
        shadowWifiInfo.setBSSID(wifiConfiguration.BSSID);
        shadowWifiInfo.setNetworkId(wifiConfiguration.networkId);
        this.setConnectionInfo(wifiInfo);
        DhcpInfo dhcpInfo = new DhcpInfo();
        dhcpInfo.gateway = 2130706433;
        dhcpInfo.ipAddress = 2130706433;
        this.setDhcpInfo(dhcpInfo);
        NetworkInfo networkInfo = ShadowNetworkInfo.newInstance(NetworkInfo.DetailedState.CONNECTED, 1, 0, true, true);
        ShadowConnectivityManager connectivityManager = (ShadowConnectivityManager)Shadow.extract((Object)RuntimeEnvironment.application.getSystemService("connectivity"));
        connectivityManager.setActiveNetworkInfo(networkInfo);
        if (listener != null) {
            listener.onSuccess();
        }
    }

    @HiddenApi
    @Implementation(minSdk=19)
    protected void connect(int networkId, WifiManager.ActionListener listener) {
        WifiConfiguration wifiConfiguration = new WifiConfiguration();
        wifiConfiguration.networkId = networkId;
        wifiConfiguration.SSID = "";
        wifiConfiguration.BSSID = "";
        this.connect(wifiConfiguration, listener);
    }

    private static boolean isQuoted(String str) {
        if (str == null || str.length() < 2) {
            return false;
        }
        return str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"';
    }

    private static String stripQuotes(String str) {
        return str.substring(1, str.length() - 1);
    }

    @Implementation
    protected boolean reconnect() {
        WifiConfiguration wifiConfiguration = this.getMostRecentNetwork();
        if (wifiConfiguration == null) {
            return false;
        }
        this.connect(wifiConfiguration, null);
        return true;
    }

    private WifiConfiguration getMostRecentNetwork() {
        if (this.getLastEnabledNetwork() == null) {
            return null;
        }
        return this.getWifiConfiguration((Integer)this.getLastEnabledNetwork().first);
    }

    public static void setSignalLevelInPercent(float level) {
        if (level < 0.0f || level > 1.0f) {
            throw new IllegalArgumentException("level needs to be between 0 and 1");
        }
        sSignalLevelInPercent = level;
    }

    public void setAccessWifiStatePermission(boolean accessWifiStatePermission) {
        this.accessWifiStatePermission = accessWifiStatePermission;
    }

    public void setScanResults(List<ScanResult> scanResults) {
        this.scanResults = scanResults;
    }

    public void setDhcpInfo(DhcpInfo dhcpInfo) {
        this.dhcpInfo = dhcpInfo;
    }

    public Pair<Integer, Boolean> getLastEnabledNetwork() {
        return this.lastEnabledNetwork;
    }

    public boolean wasConfigurationSaved() {
        return this.wasSaved;
    }

    public void setIsScanAlwaysAvailable(boolean isScanAlwaysAvailable) {
        this.isScanAlwaysAvailable = isScanAlwaysAvailable;
    }

    private void checkAccessWifiStatePermission() {
        if (!this.accessWifiStatePermission) {
            throw new SecurityException();
        }
    }

    private WifiConfiguration makeCopy(WifiConfiguration config, int networkId) {
        ShadowWifiConfiguration shadowWifiConfiguration = (ShadowWifiConfiguration)Shadow.extract((Object)config);
        WifiConfiguration copy = shadowWifiConfiguration.copy();
        copy.networkId = networkId;
        return copy;
    }

    public WifiConfiguration getWifiConfiguration(int netId) {
        return this.networkIdToConfiguredNetworks.get(netId);
    }

    @Implements(value=WifiManager.MulticastLock.class)
    public static class ShadowMulticastLock {
        private int refCount;
        private boolean refCounted = true;
        private boolean locked;
        static final int MAX_ACTIVE_LOCKS = 50;

        @Implementation
        protected void acquire() {
            if (this.refCounted) {
                if (++this.refCount >= 50) {
                    throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                }
            } else {
                this.locked = true;
            }
        }

        @Implementation
        protected synchronized void release() {
            if (this.refCounted) {
                if (--this.refCount < 0) {
                    throw new RuntimeException("WifiLock under-locked");
                }
            } else {
                this.locked = false;
            }
        }

        @Implementation
        protected void setReferenceCounted(boolean refCounted) {
            this.refCounted = refCounted;
        }

        @Implementation
        protected synchronized boolean isHeld() {
            return this.refCounted ? this.refCount > 0 : this.locked;
        }
    }

    @Implements(value=WifiManager.WifiLock.class)
    public static class ShadowWifiLock {
        private int refCount;
        private boolean refCounted = true;
        private boolean locked;
        public static final int MAX_ACTIVE_LOCKS = 50;

        @Implementation
        protected synchronized void acquire() {
            if (this.refCounted) {
                if (++this.refCount >= 50) {
                    throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                }
            } else {
                this.locked = true;
            }
        }

        @Implementation
        protected synchronized void release() {
            if (this.refCounted) {
                if (--this.refCount < 0) {
                    throw new RuntimeException("WifiLock under-locked");
                }
            } else {
                this.locked = false;
            }
        }

        @Implementation
        protected synchronized boolean isHeld() {
            return this.refCounted ? this.refCount > 0 : this.locked;
        }

        @Implementation
        protected void setReferenceCounted(boolean refCounted) {
            this.refCounted = refCounted;
        }
    }
}

