/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemClock;
import java.time.DateTimeException;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowApplication;

@Implements(value=SystemClock.class)
public class ShadowSystemClock {
    private static long bootedAt = 0L;
    private static long nanoTime = 0L;
    private static final int MILLIS_PER_NANO = 1000000;
    private static boolean networkTimeAvailable = true;

    static long now() {
        if (ShadowApplication.getInstance() == null) {
            return 0L;
        }
        return ShadowApplication.getInstance().getForegroundThreadScheduler().getCurrentTime();
    }

    @Implementation
    protected static void sleep(long millis) {
        if (ShadowApplication.getInstance() == null) {
            return;
        }
        nanoTime = millis * 1000000L;
        ShadowApplication.getInstance().getForegroundThreadScheduler().advanceBy(millis);
    }

    @Implementation
    protected static boolean setCurrentTimeMillis(long millis) {
        if (ShadowApplication.getInstance() == null) {
            return false;
        }
        if (ShadowSystemClock.now() > millis) {
            return false;
        }
        nanoTime = millis * 1000000L;
        ShadowApplication.getInstance().getForegroundThreadScheduler().advanceTo(millis);
        return true;
    }

    @Implementation
    protected static long uptimeMillis() {
        return ShadowSystemClock.now() - bootedAt;
    }

    @Implementation
    protected static long elapsedRealtime() {
        return ShadowSystemClock.uptimeMillis();
    }

    @Implementation(minSdk=17)
    protected static long elapsedRealtimeNanos() {
        return ShadowSystemClock.elapsedRealtime() * 1000000L;
    }

    @Implementation
    protected static long currentThreadTimeMillis() {
        return ShadowSystemClock.uptimeMillis();
    }

    @HiddenApi
    @Implementation
    public static long currentThreadTimeMicro() {
        return ShadowSystemClock.uptimeMillis() * 1000L;
    }

    @HiddenApi
    @Implementation
    public static long currentTimeMicro() {
        return ShadowSystemClock.now() * 1000L;
    }

    public static long currentTimeMillis() {
        return nanoTime / 1000000L;
    }

    public static long nanoTime() {
        return nanoTime;
    }

    public static void setNanoTime(long nanoTime) {
        ShadowSystemClock.nanoTime = nanoTime;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected static long currentNetworkTimeMillis() {
        if (networkTimeAvailable) {
            return ShadowSystemClock.currentTimeMillis();
        }
        throw new DateTimeException("Network time not available");
    }

    public static void setNetworkTimeAvailable(boolean available) {
        networkTimeAvailable = available;
    }

    @Resetter
    public static void reset() {
        networkTimeAvailable = true;
    }
}

