/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ParcelFileDescriptor.class)
@SuppressLint(value={"NewApi"})
public class ShadowParcelFileDescriptor {
    private static final String PIPE_TMP_DIR = "ShadowParcelFileDescriptor";
    private static final String PIPE_FILE_NAME = "pipe";
    private RandomAccessFile file;
    @RealObject
    ParcelFileDescriptor realParcelFd;
    @RealObject
    private ParcelFileDescriptor realObject;

    @Implementation
    protected void __constructor__(ParcelFileDescriptor wrapped) {
        Shadow.invokeConstructor(ParcelFileDescriptor.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ParcelFileDescriptor.class, (Object)wrapped)});
        if (wrapped != null) {
            ShadowParcelFileDescriptor shadowParcelFileDescriptor = (ShadowParcelFileDescriptor)Shadow.extract((Object)wrapped);
            this.file = shadowParcelFileDescriptor.file;
        }
    }

    @Implementation
    protected static ParcelFileDescriptor open(File file, int mode) throws FileNotFoundException {
        ParcelFileDescriptor pfd;
        try {
            Constructor constructor = ParcelFileDescriptor.class.getDeclaredConstructor(FileDescriptor.class);
            pfd = (ParcelFileDescriptor)constructor.newInstance(new FileDescriptor());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ShadowParcelFileDescriptor shadowParcelFileDescriptor = (ShadowParcelFileDescriptor)Shadow.extract((Object)pfd);
        shadowParcelFileDescriptor.file = new RandomAccessFile(file, ShadowParcelFileDescriptor.getFileMode(mode));
        return pfd;
    }

    private static String getFileMode(int mode) {
        if ((mode & 0x8000000) != 0) {
            return "rw";
        }
        switch (mode & 0x30000000) {
            case 0x10000000: {
                return "r";
            }
            case 0x20000000: {
                return "rw";
            }
            case 0x30000000: {
                return "rw";
            }
        }
        return "rw";
    }

    @Implementation
    protected static ParcelFileDescriptor[] createPipe() throws IOException {
        File file = new File(RuntimeEnvironment.getTempDirectory().create(PIPE_TMP_DIR).toFile(), PIPE_FILE_NAME);
        if (!file.createNewFile()) {
            throw new IOException("Cannot create pipe file: " + file.getAbsolutePath());
        }
        ParcelFileDescriptor readSide = ShadowParcelFileDescriptor.open(file, 0x10000000);
        ParcelFileDescriptor writeSide = ShadowParcelFileDescriptor.open(file, 0x30000000);
        file.deleteOnExit();
        return new ParcelFileDescriptor[]{readSide, writeSide};
    }

    @Implementation
    protected FileDescriptor getFileDescriptor() {
        try {
            return this.file.getFD();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    protected long getStatSize() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    protected int getFd() {
        return 0;
    }

    @Implementation
    protected void close() throws IOException {
        this.file.close();
    }
}

