/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.BadParcelableException;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Parcel.class)
public class ShadowParcel {
    private static final String TAG = "Parcel";
    @RealObject
    private Parcel realObject;
    private static final Map<Long, ByteBuffer> NATIVE_PTR_TO_PARCEL = new LinkedHashMap<Long, ByteBuffer>();
    private static long nextNativePtr = 1L;

    @Implementation(maxSdk=17)
    protected <T extends Parcelable> T readParcelable(ClassLoader loader) {
        Parcelable.Creator<?> creator = this.readParcelableCreator(loader);
        if (creator == null) {
            return null;
        }
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return (T)((Parcelable)classLoaderCreator.createFromParcel(this.realObject, loader));
        }
        return (T)((Parcelable)creator.createFromParcel(this.realObject));
    }

    @HiddenApi
    @Implementation(minSdk=18)
    public Parcelable.Creator<?> readParcelableCreator(ClassLoader loader) {
        Parcelable.Creator creator;
        String name = this.realObject.readString();
        if (name == null) {
            return null;
        }
        try {
            ClassLoader parcelableClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
            Class<?> parcelableClass = Class.forName(name, false, parcelableClassLoader);
            if (!Parcelable.class.isAssignableFrom(parcelableClass)) {
                throw new BadParcelableException("Parcelable protocol requires that the class implements Parcelable");
            }
            Field f = parcelableClass.getField("CREATOR");
            f.setAccessible(true);
            if ((f.getModifiers() & 8) == 0) {
                throw new BadParcelableException("Parcelable protocol requires the CREATOR object to be static on class " + name);
            }
            Class<?> creatorType = f.getType();
            if (!Parcelable.Creator.class.isAssignableFrom(creatorType)) {
                throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
            }
            creator = (Parcelable.Creator)f.get(null);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("Illegal access when unmarshalling: " + name), (Throwable)e);
            throw new BadParcelableException("IllegalAccessException when unmarshalling: " + name);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Class not found when unmarshalling: " + name), (Throwable)e);
            throw new BadParcelableException("ClassNotFoundException when unmarshalling: " + name);
        }
        catch (NoSuchFieldException e) {
            throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
        }
        if (creator == null) {
            throw new BadParcelableException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + name);
        }
        return creator;
    }

    @Implementation
    protected void writeByteArray(byte[] b, int offset, int len) {
        if (b == null) {
            this.realObject.writeInt(-1);
            return;
        }
        Number nativePtr = (Number)ReflectionHelpers.getField((Object)this.realObject, (String)"mNativePtr");
        ShadowParcel.nativeWriteByteArray(nativePtr.longValue(), b, offset, len);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static int nativeDataSize(int nativePtr) {
        return ShadowParcel.nativeDataSize((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static int nativeDataSize(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).dataSize();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static int nativeDataAvail(int nativePtr) {
        return ShadowParcel.nativeDataAvail((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static int nativeDataAvail(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).dataAvailable();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static int nativeDataPosition(int nativePtr) {
        return ShadowParcel.nativeDataPosition((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static int nativeDataPosition(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).dataPosition();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static int nativeDataCapacity(int nativePtr) {
        return ShadowParcel.nativeDataCapacity((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static int nativeDataCapacity(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).dataCapacity();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeSetDataSize(int nativePtr, int size) {
        ShadowParcel.nativeSetDataSize((long)nativePtr, size);
    }

    @Implementation(minSdk=21)
    protected static void nativeSetDataSize(long nativePtr, int size) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).setDataSize(size);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeSetDataPosition(int nativePtr, int pos) {
        ShadowParcel.nativeSetDataPosition((long)nativePtr, pos);
    }

    @Implementation(minSdk=21)
    protected static void nativeSetDataPosition(long nativePtr, int pos) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).setDataPosition(pos);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeSetDataCapacity(int nativePtr, int size) {
        ShadowParcel.nativeSetDataCapacity((long)nativePtr, size);
    }

    @Implementation(minSdk=21)
    protected static void nativeSetDataCapacity(long nativePtr, int size) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).setDataCapacity(size);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeWriteByteArray(int nativePtr, byte[] b, int offset, int len) {
        ShadowParcel.nativeWriteByteArray((long)nativePtr, b, offset, len);
    }

    @Implementation(minSdk=21)
    protected static void nativeWriteByteArray(long nativePtr, byte[] b, int offset, int len) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeByteArray(b, offset, len);
    }

    @Implementation(minSdk=23)
    protected void writeBlob(byte[] b, int offset, int len) {
        if (b == null) {
            this.realObject.writeInt(-1);
            return;
        }
        ShadowParcel.throwsIfOutOfBounds(b.length, offset, len);
        long nativePtr = (Long)ReflectionHelpers.getField((Object)this.realObject, (String)"mNativePtr");
        ShadowParcel.nativeWriteBlob(nativePtr, b, offset, len);
    }

    private static void throwsIfOutOfBounds(int len, int offset, int count) {
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative length: " + len);
        }
        if ((offset | count) < 0 || offset > len - count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Implementation(minSdk=21)
    protected static void nativeWriteBlob(long nativePtr, byte[] b, int offset, int len) {
        ShadowParcel.nativeWriteByteArray(nativePtr, b, offset, len);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeWriteInt(int nativePtr, int val) {
        ShadowParcel.nativeWriteInt((long)nativePtr, val);
    }

    @Implementation(minSdk=21)
    protected static void nativeWriteInt(long nativePtr, int val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeInt(val);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeWriteLong(int nativePtr, long val) {
        ShadowParcel.nativeWriteLong((long)nativePtr, val);
    }

    @Implementation(minSdk=21)
    protected static void nativeWriteLong(long nativePtr, long val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeLong(val);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeWriteFloat(int nativePtr, float val) {
        ShadowParcel.nativeWriteFloat((long)nativePtr, val);
    }

    @Implementation(minSdk=21)
    protected static void nativeWriteFloat(long nativePtr, float val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeFloat(val);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeWriteDouble(int nativePtr, double val) {
        ShadowParcel.nativeWriteDouble((long)nativePtr, val);
    }

    @Implementation(minSdk=21)
    protected static void nativeWriteDouble(long nativePtr, double val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeDouble(val);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeWriteString(int nativePtr, String val) {
        ShadowParcel.nativeWriteString((long)nativePtr, val);
    }

    @Implementation(minSdk=21)
    protected static void nativeWriteString(long nativePtr, String val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeString(val);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected static void nativeWriteStrongBinder(int nativePtr, IBinder val) {
        ShadowParcel.nativeWriteStrongBinder((long)nativePtr, val);
    }

    @Implementation(minSdk=21)
    protected static void nativeWriteStrongBinder(long nativePtr, IBinder val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeStrongBinder(val);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static byte[] nativeCreateByteArray(int nativePtr) {
        return ShadowParcel.nativeCreateByteArray((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static byte[] nativeCreateByteArray(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readByteArray();
    }

    @Implementation(minSdk=21)
    protected static byte[] nativeReadBlob(long nativePtr) {
        return ShadowParcel.nativeCreateByteArray(nativePtr);
    }

    @Implementation(minSdk=27)
    protected static boolean nativeReadByteArray(long nativePtr, byte[] dest, int destLen) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readByteArray(dest, destLen);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static int nativeReadInt(int nativePtr) {
        return ShadowParcel.nativeReadInt((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static int nativeReadInt(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readInt();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static long nativeReadLong(int nativePtr) {
        return ShadowParcel.nativeReadLong((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static long nativeReadLong(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readLong();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static float nativeReadFloat(int nativePtr) {
        return ShadowParcel.nativeReadFloat((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static float nativeReadFloat(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readFloat();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static double nativeReadDouble(int nativePtr) {
        return ShadowParcel.nativeReadDouble((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static double nativeReadDouble(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readDouble();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static String nativeReadString(int nativePtr) {
        return ShadowParcel.nativeReadString((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static String nativeReadString(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readString();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected static IBinder nativeReadStrongBinder(int nativePtr) {
        return ShadowParcel.nativeReadStrongBinder((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static IBinder nativeReadStrongBinder(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readStrongBinder();
    }

    @Implementation
    @HiddenApi
    public static synchronized Number nativeCreate() {
        long nativePtr = nextNativePtr++;
        NATIVE_PTR_TO_PARCEL.put(nativePtr, new ByteBuffer());
        return RuntimeEnvironment.castNativePtr(nativePtr);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeFreeBuffer(int nativePtr) {
        ShadowParcel.nativeFreeBuffer((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static void nativeFreeBuffer(long nativePtr) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).clear();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeDestroy(int nativePtr) {
        ShadowParcel.nativeDestroy((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static void nativeDestroy(long nativePtr) {
        NATIVE_PTR_TO_PARCEL.remove(nativePtr);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static byte[] nativeMarshall(int nativePtr) {
        return ShadowParcel.nativeMarshall((long)nativePtr);
    }

    @Implementation(minSdk=21)
    protected static byte[] nativeMarshall(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).toByteArray();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeUnmarshall(int nativePtr, byte[] data, int offset, int length) {
        ShadowParcel.nativeUnmarshall((long)nativePtr, data, offset, length);
    }

    @Implementation(minSdk=21)
    protected static void nativeUnmarshall(long nativePtr, byte[] data, int offset, int length) {
        NATIVE_PTR_TO_PARCEL.put(nativePtr, ByteBuffer.fromByteArray(data, offset, length));
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeAppendFrom(int thisNativePtr, int otherNativePtr, int offset, int length) {
        ShadowParcel.nativeAppendFrom((long)thisNativePtr, (long)otherNativePtr, offset, length);
    }

    @Implementation(minSdk=21)
    protected static void nativeAppendFrom(long thisNativePtr, long otherNativePtr, int offset, int length) {
        ByteBuffer thisByteBuffer = NATIVE_PTR_TO_PARCEL.get(thisNativePtr);
        ByteBuffer otherByteBuffer = NATIVE_PTR_TO_PARCEL.get(otherNativePtr);
        thisByteBuffer.appendFrom(otherByteBuffer, offset, length);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeWriteInterfaceToken(int nativePtr, String interfaceName) {
        ShadowParcel.nativeWriteInterfaceToken((long)nativePtr, interfaceName);
    }

    @Implementation(minSdk=21)
    protected static void nativeWriteInterfaceToken(long nativePtr, String interfaceName) {
        ShadowParcel.nativeWriteInt(nativePtr, 0);
        ShadowParcel.nativeWriteString(nativePtr, interfaceName);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void nativeEnforceInterface(int nativePtr, String interfaceName) {
        ShadowParcel.nativeEnforceInterface((long)nativePtr, interfaceName);
    }

    @Implementation(minSdk=21)
    protected static void nativeEnforceInterface(long nativePtr, String interfaceName) {
        ShadowParcel.nativeReadInt(nativePtr);
        String actualInterfaceName = ShadowParcel.nativeReadString(nativePtr);
        if (!Objects.equals(interfaceName, actualInterfaceName)) {
            throw new SecurityException("Binder invocation to an incorrect interface");
        }
    }

    @Implementation(maxSdk=28)
    protected static FileDescriptor openFileDescriptor(String file, int mode) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, mode == 0x10000000 ? "r" : "rw");
        return randomAccessFile.getFD();
    }

    private static class ByteBuffer {
        private List<Pair<Integer, ?>> buffer = new ArrayList();
        private int index;

        private ByteBuffer() {
        }

        public void clear() {
            this.index = 0;
            this.buffer.clear();
        }

        public byte[] readByteArray() {
            int length = this.readInt();
            if (length == -1) {
                return null;
            }
            byte[] array = new byte[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.readByte();
            }
            return array;
        }

        public boolean readByteArray(byte[] dest, int destLen) {
            int length = this.readInt();
            if (length >= 0 && length <= this.dataAvailable() && length == destLen) {
                for (int i = 0; i < length; ++i) {
                    dest[i] = this.readByte();
                }
                return true;
            }
            return false;
        }

        public void writeByte(byte b) {
            this.writeValue(1, b);
        }

        public void writeByteArray(byte[] b, int offset, int length) {
            this.writeInt(b.length);
            for (int i = offset; i < offset + length && i < b.length; ++i) {
                this.writeByte(b[i]);
            }
        }

        public byte readByte() {
            return this.readValue((byte)0);
        }

        public void writeInt(int i) {
            this.writeValue(4, i);
        }

        public int readInt() {
            return this.readValue(0);
        }

        public void writeLong(long l) {
            this.writeValue(8, l);
        }

        public long readLong() {
            return this.readValue(0L);
        }

        public void writeFloat(float f) {
            this.writeValue(4, Float.valueOf(f));
        }

        public float readFloat() {
            return this.readValue(Float.valueOf(0.0f)).floatValue();
        }

        public void writeDouble(double d) {
            this.writeValue(8, d);
        }

        public double readDouble() {
            return this.readValue(0.0);
        }

        public void writeString(String s) {
            int length = TextUtils.isEmpty((CharSequence)s) ? 4 : s.length();
            this.writeValue(length, s);
        }

        public String readString() {
            return this.readValue(null);
        }

        public void writeStrongBinder(IBinder b) {
            int length = 20;
            this.writeValue(length, b);
        }

        public IBinder readStrongBinder() {
            return this.readValue(null);
        }

        public void appendFrom(ByteBuffer other, int offset, int length) {
            int otherIndex = other.toIndex(offset);
            int otherEndIndex = other.toIndex(offset + length);
            for (int i = otherIndex; i < otherEndIndex && i < other.buffer.size(); ++i) {
                int elementSize = (Integer)other.buffer.get((int)i).first;
                Object elementValue = other.buffer.get((int)i).second;
                this.writeValue(elementSize, elementValue);
            }
        }

        public static ByteBuffer fromByteArray(byte[] array, int offset, int length) {
            ByteBuffer byteBuffer = new ByteBuffer();
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(array, offset, length);
                ObjectInputStream ois = new ObjectInputStream(bis);
                int numElements = ois.readInt();
                for (int i = 0; i < numElements; ++i) {
                    int sizeOf = ois.readInt();
                    Object value = ois.readObject();
                    byteBuffer.buffer.add(Pair.create((Object)sizeOf, (Object)value));
                }
                return byteBuffer;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public byte[] toByteArray() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                int length = this.buffer.size();
                oos.writeInt(length);
                for (Pair<Integer, ?> element : this.buffer) {
                    oos.writeInt((Integer)element.first);
                    oos.writeObject(element.second);
                }
                return bos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int dataAvailable() {
            return this.dataSize() - this.dataPosition();
        }

        public int dataCapacity() {
            return this.dataSize();
        }

        public int dataPosition() {
            return this.toDataPosition(this.index);
        }

        public int dataSize() {
            int dataPosition;
            int totalSize = this.totalSize();
            return totalSize > (dataPosition = this.dataPosition()) ? totalSize : dataPosition;
        }

        public void setDataPosition(int pos) {
            this.index = this.toIndex(pos);
        }

        public void setDataSize(int size) {
        }

        public void setDataCapacity(int size) {
        }

        private int totalSize() {
            int size = 0;
            for (Pair<Integer, ?> element : this.buffer) {
                size += ((Integer)element.first).intValue();
            }
            return size;
        }

        private <T> T readValue(T defaultValue) {
            return (T)(this.index < this.buffer.size() ? this.buffer.get((int)this.index++).second : defaultValue);
        }

        private void writeValue(int i, Object o) {
            Pair value = Pair.create((Object)i, (Object)o);
            if (this.index < this.buffer.size()) {
                this.buffer.set(this.index, value);
            } else {
                this.buffer.add(value);
            }
            ++this.index;
        }

        private int toDataPosition(int index) {
            int pos = 0;
            for (int i = 0; i < index; ++i) {
                pos += ((Integer)this.buffer.get((int)i).first).intValue();
            }
            return pos;
        }

        private int toIndex(int dataPosition) {
            int i;
            int calculatedPos = 0;
            for (i = 0; i < this.buffer.size() && calculatedPos < dataPosition; calculatedPos += ((Integer)this.buffer.get((int)i).first).intValue(), ++i) {
            }
            return i;
        }
    }
}

