/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Handler;
import android.os.Message;
import android.os.MessageQueue;
import java.util.ArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowMessage;
import org.robolectric.util.Logger;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;

@Implements(value=MessageQueue.class)
public class ShadowMessageQueue {
    @RealObject
    private MessageQueue realQueue;
    private Scheduler scheduler;

    @HiddenApi
    @Implementation
    public static Number nativeInit() {
        return 1;
    }

    @HiddenApi
    @Implementation(minSdk=18, maxSdk=20)
    public static void nativeDestroy(int ptr) {
        ShadowMessageQueue.nativeDestroy((long)ptr);
    }

    @Implementation(minSdk=21)
    protected static void nativeDestroy(long ptr) {
    }

    @HiddenApi
    @Implementation(minSdk=19, maxSdk=20)
    public static boolean nativeIsIdling(int ptr) {
        return ShadowMessageQueue.nativeIsIdling((long)ptr);
    }

    @Implementation(minSdk=21, maxSdk=22)
    protected static boolean nativeIsIdling(long ptr) {
        return false;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Message getHead() {
        return (Message)ReflectionHelpers.getField((Object)this.realQueue, (String)"mMessages");
    }

    public void setHead(Message msg) {
        ReflectionHelpers.setField((Object)this.realQueue, (String)"mMessages", (Object)msg);
    }

    public void reset() {
        this.setHead(null);
        ReflectionHelpers.setField((Object)this.realQueue, (String)"mIdleHandlers", new ArrayList());
        ReflectionHelpers.setField((Object)this.realQueue, (String)"mNextBarrierToken", (Object)0);
    }

    @Implementation
    protected boolean enqueueMessage(final Message msg, long when) {
        boolean retval = (Boolean)Shadow.directlyOn((Object)this.realQueue, MessageQueue.class, (String)"enqueueMessage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Message.class, (Object)msg), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)when)});
        if (retval) {
            Runnable callback = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MessageQueue messageQueue = ShadowMessageQueue.this.realQueue;
                    synchronized (messageQueue) {
                        Message m = ShadowMessageQueue.this.getHead();
                        if (m == null) {
                            return;
                        }
                        Message n = ShadowMessageQueue.shadowOf(m).getNext();
                        if (m == msg) {
                            ShadowMessageQueue.this.setHead(n);
                        } else {
                            while (n != null) {
                                if (n == msg) {
                                    n = ShadowMessageQueue.shadowOf(n).getNext();
                                    ShadowMessageQueue.shadowOf(m).setNext(n);
                                    break;
                                }
                                m = n;
                                n = ShadowMessageQueue.shadowOf(m).getNext();
                            }
                        }
                    }
                    ShadowMessageQueue.dispatchMessage(msg);
                }
            };
            ShadowMessageQueue.shadowOf(msg).setScheduledRunnable(callback);
            if (when == 0L) {
                this.scheduler.postAtFrontOfQueue(callback);
            } else {
                this.scheduler.postDelayed(callback, when - this.scheduler.getCurrentTime());
            }
        }
        return retval;
    }

    private static void dispatchMessage(Message msg) {
        Handler target = msg.getTarget();
        ShadowMessageQueue.shadowOf(msg).setNext(null);
        if (target != null) {
            ReflectionHelpers.callInstanceMethod((Object)msg, (String)"markInUse", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            target.dispatchMessage(msg);
            if (RuntimeEnvironment.getApiLevel() >= 21) {
                ReflectionHelpers.callInstanceMethod((Object)msg, (String)"recycleUnchecked", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            } else {
                ReflectionHelpers.callInstanceMethod((Object)msg, (String)"recycle", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            }
        }
    }

    @Implementation
    @HiddenApi
    protected void removeSyncBarrier(int token) {
        try {
            Shadow.directlyOn((Object)this.realQueue, MessageQueue.class, (String)"removeSyncBarrier", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)token)});
        }
        catch (IllegalStateException e) {
            Logger.warn((String)"removeSyncBarrier failed! Could not find token %d", (Object[])new Object[]{token});
        }
    }

    private static ShadowMessage shadowOf(Message actual) {
        return (ShadowMessage)Shadow.extract((Object)actual);
    }
}

