/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.os.ParcelUuid;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowBluetoothServerSocket;

@Implements(value=BluetoothAdapter.class)
public class ShadowBluetoothAdapter {
    private static final int ADDRESS_LENGTH = 17;
    private Set<BluetoothDevice> bondedDevices = new HashSet<BluetoothDevice>();
    private Set<BluetoothAdapter.LeScanCallback> leScanCallbacks = new HashSet<BluetoothAdapter.LeScanCallback>();
    private boolean isDiscovering;
    private String address;
    private boolean enabled;
    private int state;
    private String name = "DefaultBluetoothDeviceName";
    private int scanMode = 20;
    private boolean isMultipleAdvertisementSupported = true;
    private Map<Integer, Integer> profileConnectionStateData = new HashMap<Integer, Integer>();

    @Implementation
    protected static BluetoothAdapter getDefaultAdapter() {
        return (BluetoothAdapter)ShadowApplication.getInstance().getBluetoothAdapter();
    }

    @Implementation
    protected Set<BluetoothDevice> getBondedDevices() {
        return Collections.unmodifiableSet(this.bondedDevices);
    }

    public void setBondedDevices(Set<BluetoothDevice> bluetoothDevices) {
        this.bondedDevices = bluetoothDevices;
    }

    @Implementation
    protected BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String serviceName, UUID uuid) {
        return ShadowBluetoothServerSocket.newInstance(1, false, false, new ParcelUuid(uuid));
    }

    @Implementation
    protected boolean startDiscovery() {
        this.isDiscovering = true;
        return true;
    }

    @Implementation
    protected boolean cancelDiscovery() {
        this.isDiscovering = false;
        return true;
    }

    @Implementation(minSdk=18)
    protected boolean startLeScan(BluetoothAdapter.LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    @Implementation(minSdk=18)
    protected boolean startLeScan(UUID[] serviceUuids, BluetoothAdapter.LeScanCallback callback) {
        this.leScanCallbacks.add(callback);
        return true;
    }

    @Implementation(minSdk=18)
    protected void stopLeScan(BluetoothAdapter.LeScanCallback callback) {
        this.leScanCallbacks.remove(callback);
    }

    public Set<BluetoothAdapter.LeScanCallback> getLeScanCallbacks() {
        return Collections.unmodifiableSet(this.leScanCallbacks);
    }

    public BluetoothAdapter.LeScanCallback getSingleLeScanCallback() {
        if (this.leScanCallbacks.size() != 1) {
            throw new IllegalStateException("There are " + this.leScanCallbacks.size() + " callbacks");
        }
        return this.leScanCallbacks.iterator().next();
    }

    @Implementation
    protected boolean isDiscovering() {
        return this.isDiscovering;
    }

    @Implementation
    protected boolean isEnabled() {
        return this.enabled;
    }

    @Implementation
    protected boolean enable() {
        this.enabled = true;
        return true;
    }

    @Implementation
    protected boolean disable() {
        this.enabled = false;
        return true;
    }

    @Implementation
    protected String getAddress() {
        return this.address;
    }

    @Implementation
    protected int getState() {
        return this.state;
    }

    @Implementation
    protected String getName() {
        return this.name;
    }

    @Implementation
    protected boolean setName(String name) {
        this.name = name;
        return true;
    }

    @Implementation
    protected boolean setScanMode(int scanMode) {
        if (scanMode != 21 && scanMode != 23 && scanMode != 20) {
            return false;
        }
        this.scanMode = scanMode;
        return true;
    }

    @Implementation
    protected int getScanMode() {
        return this.scanMode;
    }

    @Implementation(minSdk=21)
    protected boolean isMultipleAdvertisementSupported() {
        return this.isMultipleAdvertisementSupported;
    }

    @Implementation
    protected static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    @Implementation
    protected int getProfileConnectionState(int profile) {
        Integer state = this.profileConnectionStateData.get(profile);
        if (state == null) {
            return 0;
        }
        return state;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setIsMultipleAdvertisementSupported(boolean supported) {
        this.isMultipleAdvertisementSupported = supported;
    }

    public void setProfileConnectionState(int profile, int state) {
        this.profileConnectionStateData.put(profile, state);
    }
}

