/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.http.HttpResponseCache;
import java.io.File;
import java.net.CacheResponse;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;

@Implements(value=HttpResponseCache.class, callThroughByDefault=false)
public class ShadowHttpResponseCache {
    private static final Object LOCK = new Object();
    static ShadowHttpResponseCache installed = null;
    private HttpResponseCache originalObject;
    private File directory;
    private long maxSize;
    private int requestCount = 0;
    private int hitCount = 0;
    private int networkCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public static HttpResponseCache install(File directory, long maxSize) {
        HttpResponseCache cache = (HttpResponseCache)Shadow.newInstanceOf(HttpResponseCache.class);
        ShadowHttpResponseCache shadowCache = Shadows.shadowOf(cache);
        shadowCache.originalObject = cache;
        shadowCache.directory = directory;
        shadowCache.maxSize = maxSize;
        Object object = LOCK;
        synchronized (object) {
            installed = shadowCache;
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public static HttpResponseCache getInstalled() {
        Object object = LOCK;
        synchronized (object) {
            return installed != null ? ShadowHttpResponseCache.installed.originalObject : null;
        }
    }

    @Implementation
    public long maxSize() {
        return this.maxSize;
    }

    @Implementation
    public long size() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public void close() {
        Object object = LOCK;
        synchronized (object) {
            installed = null;
        }
    }

    @Implementation
    public void delete() {
        this.close();
    }

    @Implementation
    public int getHitCount() {
        return this.hitCount;
    }

    @Implementation
    public int getNetworkCount() {
        return this.networkCount;
    }

    @Implementation
    public int getRequestCount() {
        return this.requestCount;
    }

    @Implementation
    public CacheResponse get(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) {
        ++this.requestCount;
        ++this.networkCount;
        return null;
    }

    @Implementation
    public CacheResponse put(URI uri, URLConnection urlConnection) {
        return null;
    }
}

