/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SharedMemory;
import android.system.ErrnoException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.WeakHashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.TempDirectory;

@Implements(value=SharedMemory.class, minSdk=27, isInAndroidSdk=false)
public class ShadowSharedMemory {
    private static final Map<FileDescriptor, File> filesByFd = new WeakHashMap<FileDescriptor, File>();

    @Implementation
    public ByteBuffer map(int prot, int offset, int length) throws ErrnoException {
        return ByteBuffer.allocate(length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public static FileDescriptor nCreate(String name, int size) throws ErrnoException {
        TempDirectory tempDirectory = RuntimeEnvironment.getTempDirectory();
        try {
            File sharedMemoryFile = tempDirectory.createIfNotExists("SharedMemory").resolve("shmem-" + name).toFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(sharedMemoryFile, "rw");
            randomAccessFile.setLength(0L);
            randomAccessFile.setLength(size);
            Map<FileDescriptor, File> map = filesByFd;
            synchronized (map) {
                filesByFd.put(randomAccessFile.getFD(), sharedMemoryFile);
            }
            return randomAccessFile.getFD();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create file descriptior", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public static int nGetSize(FileDescriptor fd) {
        Map<FileDescriptor, File> map = filesByFd;
        synchronized (map) {
            return (int)filesByFd.get(fd).length();
        }
    }
}

