/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.controller;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import android.view.ViewRootImpl;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.android.controller.ComponentController;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowViewRootImpl;
import org.robolectric.util.ReflectionHelpers;

public class ActivityController<T extends Activity>
extends ComponentController<ActivityController<T>, T> {
    public static <T extends Activity> ActivityController<T> of(T activity, Intent intent) {
        return super.attach();
    }

    public static <T extends Activity> ActivityController<T> of(T activity) {
        return super.attach();
    }

    private ActivityController(T activity, Intent intent) {
        super(activity, intent);
    }

    private ActivityController<T> attach() {
        if (this.attached) {
            return this;
        }
        Shadows.shadowOf((Activity)this.component).callAttach(this.getIntent());
        this.attached = true;
        return this;
    }

    private ActivityInfo getActivityInfo(Application application) {
        try {
            return application.getPackageManager().getActivityInfo(new ComponentName(application.getPackageName(), ((Activity)this.component).getClass().getName()), 129);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ActivityController<T> create(final Bundle bundle) {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)ActivityController.this.component, (String)"performCreate", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)bundle)});
            }
        });
        return this;
    }

    @Override
    public ActivityController<T> create() {
        return this.create(null);
    }

    public ActivityController<T> restart() {
        this.invokeWhilePaused("performRestart", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    public ActivityController<T> start() {
        this.invokeWhilePaused("performStart", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    public ActivityController<T> restoreInstanceState(Bundle bundle) {
        this.invokeWhilePaused("performRestoreInstanceState", ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)bundle));
        return this;
    }

    public ActivityController<T> postCreate(Bundle bundle) {
        this.invokeWhilePaused("onPostCreate", ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)bundle));
        return this;
    }

    public ActivityController<T> resume() {
        this.invokeWhilePaused("performResume", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    public ActivityController<T> postResume() {
        this.invokeWhilePaused("onPostResume", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    public ActivityController<T> visible() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                ReflectionHelpers.setField((Object)ActivityController.this.component, (String)"mDecor", (Object)((Activity)ActivityController.this.component).getWindow().getDecorView());
                ReflectionHelpers.callInstanceMethod((Object)ActivityController.this.component, (String)"makeVisible", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            }
        });
        ViewRootImpl root = ((Activity)this.component).getWindow().getDecorView().getViewRootImpl();
        if (root != null) {
            ((ShadowViewRootImpl)Shadow.extract((Object)root)).callDispatchResized();
        }
        return this;
    }

    public ActivityController<T> userLeaving() {
        this.invokeWhilePaused("performUserLeaving", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    public ActivityController<T> pause() {
        this.invokeWhilePaused("performPause", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    public ActivityController<T> saveInstanceState(Bundle outState) {
        this.invokeWhilePaused("performSaveInstanceState", ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)outState));
        return this;
    }

    public ActivityController<T> stop() {
        if (RuntimeEnvironment.getApiLevel() <= 23) {
            this.invokeWhilePaused("performStop", new ReflectionHelpers.ClassParameter[0]);
        } else {
            this.invokeWhilePaused("performStop", ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true));
        }
        return this;
    }

    @Override
    public ActivityController<T> destroy() {
        this.invokeWhilePaused("performDestroy", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    public ActivityController<T> setup() {
        return ((ActivityController)this.create()).start().postCreate(null).resume().visible();
    }

    public ActivityController<T> setup(Bundle savedInstanceState) {
        return this.create(savedInstanceState).start().restoreInstanceState(savedInstanceState).postCreate(savedInstanceState).resume().visible();
    }

    public ActivityController<T> newIntent(Intent intent) {
        this.invokeWhilePaused("onNewIntent", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)intent));
        return this;
    }

    public ActivityController<T> configurationChange() {
        return this.configurationChange(((Activity)this.component).getApplicationContext().getResources().getConfiguration());
    }

    public ActivityController<T> configurationChange(final Configuration newConfiguration) {
        Configuration currentConfig = ((Activity)this.component).getResources().getConfiguration();
        final int changedBits = currentConfig.diff(newConfiguration);
        currentConfig.setTo(newConfiguration);
        if ((this.getActivityInfo((Application)((Activity)this.component).getApplication()).configChanges & changedBits) == changedBits) {
            this.shadowMainLooper.runPaused(new Runnable(){

                @Override
                public void run() {
                    ReflectionHelpers.callInstanceMethod(Activity.class, (Object)ActivityController.this.component, (String)"onConfigurationChanged", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Configuration.class, (Object)newConfiguration)});
                }
            });
            return this;
        }
        final Activity recreatedActivity = (Activity)ReflectionHelpers.callConstructor(((Activity)this.component).getClass(), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                ReflectionHelpers.setField(Activity.class, (Object)ActivityController.this.component, (String)"mChangingConfigurations", (Object)true);
                ReflectionHelpers.setField(Activity.class, (Object)ActivityController.this.component, (String)"mConfigChangeFlags", (Object)changedBits);
                Bundle outState = new Bundle();
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)ActivityController.this.component, (String)"performPause", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)ActivityController.this.component, (String)"performSaveInstanceState", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)outState)});
                if (RuntimeEnvironment.getApiLevel() <= 23) {
                    ReflectionHelpers.callInstanceMethod(Activity.class, (Object)ActivityController.this.component, (String)"performStop", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                } else {
                    ReflectionHelpers.callInstanceMethod(Activity.class, (Object)ActivityController.this.component, (String)"performStop", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true)});
                }
                Object nonConfigInstance = ReflectionHelpers.callInstanceMethod(Activity.class, (Object)ActivityController.this.component, (String)"retainNonConfigurationInstances", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                Object activityConfigInstance = nonConfigInstance == null ? null : ReflectionHelpers.getField((Object)nonConfigInstance, (String)"activity");
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)ActivityController.this.component, (String)"performDestroy", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                int theme = Shadows.shadowOf((ContextThemeWrapper)ActivityController.this.component).callGetThemeResId();
                ActivityController.this.attached = false;
                ActivityController.this.component = recreatedActivity;
                ActivityController.this.attach();
                if (theme != 0) {
                    recreatedActivity.setTheme(theme);
                }
                ReflectionHelpers.setField((Object)recreatedActivity, (String)"mLastNonConfigurationInstances", (Object)nonConfigInstance);
                Shadows.shadowOf(recreatedActivity).setLastNonConfigurationInstance(activityConfigInstance);
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)recreatedActivity, (String)"performCreate", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)outState)});
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)recreatedActivity, (String)"performStart", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)recreatedActivity, (String)"performRestoreInstanceState", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)outState)});
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)recreatedActivity, (String)"onPostCreate", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)outState)});
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)recreatedActivity, (String)"performResume", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                ReflectionHelpers.callInstanceMethod(Activity.class, (Object)recreatedActivity, (String)"onPostResume", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            }
        });
        return this;
    }
}

