/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.IntentSender;
import android.content.pm.PackageInstaller;
import android.os.Handler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=PackageInstaller.class, minSdk=21)
public class ShadowPackageInstaller {
    private int nextSessionId;
    private Map<Integer, PackageInstaller.SessionInfo> sessionInfos = new HashMap<Integer, PackageInstaller.SessionInfo>();
    private Map<Integer, PackageInstaller.Session> sessions = new HashMap<Integer, PackageInstaller.Session>();
    private Set<CallbackInfo> callbackInfos = new HashSet<CallbackInfo>();

    @Implementation
    public List<PackageInstaller.SessionInfo> getAllSessions() {
        return ImmutableList.copyOf(this.sessionInfos.values());
    }

    @Implementation
    public void registerSessionCallback(PackageInstaller.SessionCallback callback, Handler handler) {
        CallbackInfo callbackInfo = new CallbackInfo();
        callbackInfo.callback = callback;
        callbackInfo.handler = handler;
        this.callbackInfos.add(callbackInfo);
    }

    @Implementation
    public PackageInstaller.SessionInfo getSessionInfo(int sessionId) {
        return this.sessionInfos.get(sessionId);
    }

    @Implementation
    public int createSession(PackageInstaller.SessionParams params) throws IOException {
        final PackageInstaller.SessionInfo sessionInfo = new PackageInstaller.SessionInfo();
        sessionInfo.sessionId = this.nextSessionId++;
        sessionInfo.active = true;
        sessionInfo.appPackageName = params.appPackageName;
        this.sessionInfos.put(sessionInfo.getSessionId(), sessionInfo);
        for (final CallbackInfo callbackInfo : this.callbackInfos) {
            callbackInfo.handler.post(new Runnable(){

                @Override
                public void run() {
                    callbackInfo.callback.onCreated(sessionInfo.sessionId);
                }
            });
        }
        return sessionInfo.sessionId;
    }

    @Implementation
    public void abandonSession(int sessionId) {
        this.sessionInfos.remove(sessionId);
    }

    @Implementation
    public PackageInstaller.Session openSession(int sessionId) throws IOException {
        if (!this.sessionInfos.containsKey(sessionId)) {
            throw new SecurityException("Invalid session Id: " + sessionId);
        }
        PackageInstaller.Session session = new PackageInstaller.Session(null);
        this.sessions.put(sessionId, session);
        return session;
    }

    public void setSessionProgress(final int sessionId, final float progress) {
        for (final CallbackInfo callbackInfo : this.callbackInfos) {
            callbackInfo.handler.post(new Runnable(){

                @Override
                public void run() {
                    callbackInfo.callback.onProgressChanged(sessionId, progress);
                }
            });
        }
    }

    public void setSessionSucceeds(int sessionId) throws Exception {
        this.setSessionFinishes(sessionId, true);
    }

    public void setSessionFails(int sessionId) throws Exception {
        this.setSessionFinishes(sessionId, false);
    }

    private void setSessionFinishes(final int sessionId, final boolean success) throws Exception {
        for (final CallbackInfo callbackInfo : this.callbackInfos) {
            callbackInfo.handler.post(new Runnable(){

                @Override
                public void run() {
                    callbackInfo.callback.onFinished(sessionId, success);
                }
            });
        }
        PackageInstaller.Session session = this.sessions.get(sessionId);
        ShadowSession shadowSession = Shadows.shadowOf(session);
        shadowSession.statusReceiver.sendIntent((Context)RuntimeEnvironment.application, 0, null, null, null, null);
    }

    @Implements(value=PackageInstaller.Session.class, minSdk=21)
    public static class ShadowSession {
        private OutputStream outputStream;
        private boolean outputStreamOpen;
        private IntentSender statusReceiver;

        public void __constructor__() {
        }

        @Implementation
        public OutputStream openWrite(String name, long offsetBytes, long lengthBytes) throws IOException {
            this.outputStream = new OutputStream(){

                @Override
                public void write(int aByte) throws IOException {
                }

                @Override
                public void close() throws IOException {
                    ShadowSession.this.outputStreamOpen = false;
                }
            };
            this.outputStreamOpen = true;
            return this.outputStream;
        }

        @Implementation
        public void fsync(OutputStream out) throws IOException {
        }

        @Implementation
        public void commit(IntentSender statusReceiver) {
            this.statusReceiver = statusReceiver;
            if (this.outputStreamOpen) {
                throw new SecurityException("OutputStream still open");
            }
        }

        @Implementation
        public void close() {
        }
    }

    private class CallbackInfo {
        PackageInstaller.SessionCallback callback;
        Handler handler;

        private CallbackInfo() {
        }
    }
}

