/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.animation.ValueAnimator;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.internal.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ValueAnimator.class)
public class ShadowValueAnimator {
    @RealObject
    private ValueAnimator realObject;
    private int actualRepeatCount;

    @Resetter
    public static void reset() {
        ValueAnimator.clearAllAnimations();
        ReflectionHelpers.setStaticField(ValueAnimator.class, (String)"sAnimationHandler", new ThreadLocal());
    }

    @Implementation
    public void setRepeatCount(int count) {
        this.actualRepeatCount = count;
        if (count == -1) {
            count = 1;
        }
        ((ValueAnimator)Shadow.directlyOn((Object)this.realObject, ValueAnimator.class)).setRepeatCount(count);
    }

    public int getActualRepeatCount() {
        return this.actualRepeatCount;
    }
}

