/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.res.PreferenceNode;
import org.robolectric.res.ResName;
import org.robolectric.shadows.ShadowActivity;
import org.robolectric.shadows.util.PreferenceBuilder;

@Implements(value=PreferenceActivity.class)
public class ShadowPreferenceActivity
extends ShadowActivity {
    private int preferencesResId = -1;
    private PreferenceScreen preferenceScreen;
    private final PreferenceBuilder preferenceBuilder = new PreferenceBuilder();

    @Implementation
    public void addPreferencesFromResource(int preferencesResId) {
        this.preferencesResId = preferencesResId;
        this.preferenceScreen = this.inflatePreferences(preferencesResId);
        ((PreferenceActivity)this.realActivity).setPreferenceScreen(this.preferenceScreen);
    }

    private PreferenceScreen inflatePreferences(int preferencesResId) {
        ResName resName = this.getResName(preferencesResId);
        String qualifiers = Shadows.shadowOf(this.getResources().getConfiguration()).getQualifiers();
        PreferenceNode preferenceNode = this.getResourceLoader().getPreferenceNode(resName, qualifiers);
        try {
            return (PreferenceScreen)this.preferenceBuilder.inflate(preferenceNode, this.realActivity, null);
        }
        catch (Exception e) {
            throw new RuntimeException("error inflating " + resName, e);
        }
    }

    public int getPreferencesResId() {
        return this.preferencesResId;
    }

    @Implementation
    public PreferenceScreen getPreferenceScreen() {
        return this.preferenceScreen;
    }

    @Implementation
    public Preference findPreference(CharSequence key) {
        return this.preferenceScreen.findPreference(key);
    }
}

