/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Parcel;
import android.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Parcel.class)
public class ShadowParcel {
    @RealObject
    private Parcel realObject;
    private static final Map<Long, ByteBuffer> NATIVE_PTR_TO_PARCEL = new LinkedHashMap<Long, ByteBuffer>();

    @Implementation
    public void writeByteArray(byte[] b, int offset, int len) {
        if (b == null) {
            this.realObject.writeInt(-1);
            return;
        }
        ShadowParcel.nativeWriteByteArray((Long)ReflectionHelpers.getField((Object)this.realObject, (String)"mNativePtr"), b, offset, len);
    }

    @Implementation
    @HiddenApi
    public static int nativeDataSize(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).dataSize();
    }

    @Implementation
    @HiddenApi
    public static int nativeDataAvail(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).dataAvailable();
    }

    @Implementation
    @HiddenApi
    public static int nativeDataPosition(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).dataPosition();
    }

    @Implementation
    @HiddenApi
    public static int nativeDataCapacity(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).dataCapacity();
    }

    @Implementation
    @HiddenApi
    public static void nativeSetDataSize(long nativePtr, int size) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).setDataSize(size);
    }

    @Implementation
    @HiddenApi
    public static void nativeSetDataPosition(long nativePtr, int pos) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).setDataPosition(pos);
    }

    @Implementation
    @HiddenApi
    public static void nativeSetDataCapacity(long nativePtr, int size) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).setDataCapacity(size);
    }

    @Implementation
    @HiddenApi
    public static void nativeWriteByteArray(long nativePtr, byte[] b, int offset, int len) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeByteArray(b, offset, len);
    }

    @Implementation
    @HiddenApi
    public static void nativeWriteInt(long nativePtr, int val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeInt(val);
    }

    @Implementation
    @HiddenApi
    public static void nativeWriteLong(long nativePtr, long val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeLong(val);
    }

    @Implementation
    @HiddenApi
    public static void nativeWriteFloat(long nativePtr, float val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeFloat(val);
    }

    @Implementation
    @HiddenApi
    public static void nativeWriteDouble(long nativePtr, double val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeDouble(val);
    }

    @Implementation
    @HiddenApi
    public static void nativeWriteString(long nativePtr, String val) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).writeString(val);
    }

    @Implementation
    @HiddenApi
    public static byte[] nativeCreateByteArray(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readByteArray();
    }

    @Implementation
    @HiddenApi
    public static int nativeReadInt(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readInt();
    }

    @Implementation
    @HiddenApi
    public static long nativeReadLong(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readLong();
    }

    @Implementation
    @HiddenApi
    public static float nativeReadFloat(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readFloat();
    }

    @Implementation
    @HiddenApi
    public static double nativeReadDouble(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readDouble();
    }

    @Implementation
    @HiddenApi
    public static String nativeReadString(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).readString();
    }

    @Implementation
    @HiddenApi
    public static long nativeCreate() {
        long nativePtrUsed = 0L;
        while (NATIVE_PTR_TO_PARCEL.containsKey(nativePtrUsed)) {
            ++nativePtrUsed;
        }
        NATIVE_PTR_TO_PARCEL.put(nativePtrUsed, new ByteBuffer());
        return nativePtrUsed;
    }

    @Implementation
    @HiddenApi
    public static void nativeFreeBuffer(long nativePtr) {
        NATIVE_PTR_TO_PARCEL.get(nativePtr).clear();
    }

    @Implementation
    @HiddenApi
    public static void nativeDestroy(long nativePtr) {
        NATIVE_PTR_TO_PARCEL.remove(nativePtr);
    }

    @Implementation
    @HiddenApi
    public static byte[] nativeMarshall(long nativePtr) {
        return NATIVE_PTR_TO_PARCEL.get(nativePtr).toByteArray();
    }

    @Implementation
    @HiddenApi
    public static void nativeUnmarshall(long nativePtr, byte[] data, int offset, int length) {
        NATIVE_PTR_TO_PARCEL.put(nativePtr, ByteBuffer.fromByteArray(data, offset, length));
    }

    @Implementation
    @HiddenApi
    public static void nativeAppendFrom(long thisNativePtr, long otherNativePtr, int offset, int length) {
        ByteBuffer thisByteBuffer = NATIVE_PTR_TO_PARCEL.get(thisNativePtr);
        ByteBuffer otherByteBuffer = NATIVE_PTR_TO_PARCEL.get(otherNativePtr);
        thisByteBuffer.appendFrom(otherByteBuffer, offset, length);
    }

    private static class ByteBuffer {
        private List<Pair<Integer, ?>> buffer = new ArrayList();
        private int index;

        private ByteBuffer() {
        }

        public void clear() {
            this.index = 0;
            this.buffer.clear();
        }

        public byte[] readByteArray() {
            int length = this.readInt();
            if (length == -1) {
                return null;
            }
            byte[] array = new byte[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.readByte();
            }
            return array;
        }

        public void writeByte(byte b) {
            this.writeValue(1, b);
        }

        public void writeByteArray(byte[] b, int offset, int length) {
            this.writeInt(b.length);
            for (int i = offset; i < offset + length && i < b.length; ++i) {
                this.writeByte(b[i]);
            }
        }

        public byte readByte() {
            return this.readValue((byte)0);
        }

        public void writeInt(int i) {
            this.writeValue(4, i);
        }

        public int readInt() {
            return this.readValue(0);
        }

        public void writeLong(long l) {
            this.writeValue(8, l);
        }

        public long readLong() {
            return this.readValue(0L);
        }

        public void writeFloat(float f) {
            this.writeValue(4, Float.valueOf(f));
        }

        public float readFloat() {
            return this.readValue(Float.valueOf(0.0f)).floatValue();
        }

        public void writeDouble(double d) {
            this.writeValue(8, d);
        }

        public double readDouble() {
            return this.readValue(0.0);
        }

        public void writeString(String s) {
            int length = s == null ? 4 : s.length();
            this.writeValue(length, s);
        }

        public String readString() {
            return this.readValue(null);
        }

        public void appendFrom(ByteBuffer other, int offset, int length) {
            int otherIndex = other.toIndex(offset);
            int otherEndIndex = other.toIndex(offset + length);
            for (int i = otherIndex; i < otherEndIndex && i < other.buffer.size(); ++i) {
                int elementSize = (Integer)other.buffer.get((int)i).first;
                Object elementValue = other.buffer.get((int)i).second;
                this.writeValue(elementSize, elementValue);
            }
        }

        public static ByteBuffer fromByteArray(byte[] array, int offset, int length) {
            ByteBuffer byteBuffer = new ByteBuffer();
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(array, offset, length);
                ObjectInputStream ois = new ObjectInputStream(bis);
                int numElements = ois.readInt();
                for (int i = 0; i < numElements; ++i) {
                    int sizeOf = ois.readInt();
                    Object value = ois.readObject();
                    byteBuffer.buffer.add(Pair.create((Object)sizeOf, (Object)value));
                }
                return byteBuffer;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public byte[] toByteArray() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                int length = this.buffer.size();
                oos.writeInt(length);
                for (Pair<Integer, ?> element : this.buffer) {
                    oos.writeInt((Integer)element.first);
                    oos.writeObject(element.second);
                }
                return bos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int dataAvailable() {
            return this.dataSize() - this.dataPosition();
        }

        public int dataCapacity() {
            return this.dataSize();
        }

        public int dataPosition() {
            return this.toDataPosition(this.index);
        }

        public int dataSize() {
            int dataPosition;
            int totalSize = this.totalSize();
            return totalSize > (dataPosition = this.dataPosition()) ? totalSize : dataPosition;
        }

        public void setDataPosition(int pos) {
            this.index = this.toIndex(pos);
        }

        public void setDataSize(int size) {
        }

        public void setDataCapacity(int size) {
        }

        private int totalSize() {
            int size = 0;
            for (Pair<Integer, ?> element : this.buffer) {
                size += ((Integer)element.first).intValue();
            }
            return size;
        }

        private <T> T readValue(T defaultValue) {
            return (T)(this.index < this.buffer.size() ? this.buffer.get((int)this.index++).second : defaultValue);
        }

        private void writeValue(int i, Object o) {
            Pair value = Pair.create((Object)i, (Object)o);
            if (this.index < this.buffer.size()) {
                this.buffer.set(this.index, value);
            } else {
                this.buffer.add(value);
            }
            ++this.index;
        }

        private int toDataPosition(int index) {
            int pos = 0;
            for (int i = 0; i < index; ++i) {
                pos += ((Integer)this.buffer.get((int)i).first).intValue();
            }
            return pos;
        }

        private int toIndex(int dataPosition) {
            int i;
            int calculatedPos = 0;
            for (i = 0; i < this.buffer.size() && calculatedPos < dataPosition; calculatedPos += ((Integer)this.buffer.get((int)i).first).intValue(), ++i) {
            }
            return i;
        }
    }
}

