/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import java.util.ArrayList;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Notification.class)
public class ShadowNotification {
    private static final int MAX_ACTIONS = 3;
    private CharSequence contentTitle;
    private CharSequence contentText;
    private CharSequence ticker;
    private CharSequence contentInfo;
    private int smallIcon;
    private long when;
    private boolean ongoing;
    private boolean showWhen;
    private ArrayList<Notification.Action> actions = new ArrayList(3);
    private Notification.Style style;
    private Progress progress;
    private boolean usesChronometer;
    @RealObject
    Notification realNotification;
    private LatestEventInfo latestEventInfo;

    public Notification getRealNotification() {
        return this.realNotification;
    }

    public void __constructor__(int icon, CharSequence tickerText, long when) {
        this.realNotification.icon = icon;
        this.realNotification.tickerText = tickerText;
        this.realNotification.when = when;
    }

    public CharSequence getContentTitle() {
        return this.contentTitle;
    }

    public CharSequence getContentText() {
        return this.contentText;
    }

    public boolean isOngoing() {
        return this.ongoing;
    }

    public int getSmallIcon() {
        return this.smallIcon;
    }

    public long getWhen() {
        return this.when;
    }

    public boolean isWhenShown() {
        return this.showWhen;
    }

    public Notification.Style getStyle() {
        return this.style;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public boolean usesChronometer() {
        return this.usesChronometer;
    }

    public void setContentTitle(CharSequence contentTitle) {
        this.contentTitle = contentTitle;
    }

    public void setContentText(CharSequence contentText) {
        this.contentText = contentText;
    }

    public void setOngoing(boolean ongoing) {
        this.ongoing = ongoing;
    }

    public void setSmallIcon(int icon) {
        this.smallIcon = icon;
    }

    public void setWhen(long when) {
        this.when = when;
    }

    public void setShowWhen(boolean showWhen) {
        this.showWhen = showWhen;
    }

    public CharSequence getTicker() {
        return this.ticker;
    }

    public void setTicker(CharSequence ticker) {
        this.ticker = ticker;
    }

    public CharSequence getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(CharSequence contentInfo) {
        this.contentInfo = contentInfo;
    }

    public void setActions(ArrayList<Notification.Action> actions) {
        this.actions = actions;
    }

    public ArrayList<Notification.Action> getActions() {
        return this.actions;
    }

    public void setStyle(Notification.Style style) {
        this.style = style;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public void setUsesChronometer(boolean usesChronometer) {
        this.usesChronometer = usesChronometer;
    }

    @Implementation
    public void setLatestEventInfo(Context context, CharSequence contentTitle, CharSequence contentText, PendingIntent contentIntent) {
        this.latestEventInfo = new LatestEventInfo(contentTitle, contentText, contentIntent);
        this.realNotification.contentIntent = contentIntent;
    }

    public LatestEventInfo getLatestEventInfo() {
        return this.latestEventInfo;
    }

    @Implements(value=Notification.BigTextStyle.class)
    public static class ShadowBigTextStyle
    extends ShadowStyle {
        @RealObject
        private Notification.BigTextStyle realStyle;
        private CharSequence bigText;

        @Implementation
        public Notification.BigTextStyle bigText(CharSequence bigText) {
            this.bigText = bigText;
            Shadow.directlyOn((Object)this.realStyle, Notification.BigTextStyle.class, (String)"bigText", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)bigText)});
            return this.realStyle;
        }

        public CharSequence getBigText() {
            return this.bigText;
        }
    }

    @Implements(value=Notification.Style.class)
    public static class ShadowStyle {
        @RealObject
        protected Notification.Style realStyle;
        private CharSequence bigContentTitle;
        private CharSequence summaryText;

        @Implementation
        public void internalSetBigContentTitle(CharSequence bigContentTitle) {
            this.bigContentTitle = bigContentTitle;
            Shadow.directlyOn((Object)this.realStyle, Notification.Style.class, (String)"internalSetBigContentTitle", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)bigContentTitle)});
        }

        @Implementation
        public void internalSetSummaryText(CharSequence summaryText) {
            this.summaryText = summaryText;
            Shadow.directlyOn((Object)this.realStyle, Notification.Style.class, (String)"internalSetSummaryText", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)summaryText)});
        }

        public CharSequence getBigContentTitle() {
            return this.bigContentTitle;
        }

        public CharSequence getSummaryText() {
            return this.summaryText;
        }
    }

    @Implements(value=Notification.Builder.class)
    public static class ShadowBuilder {
        @RealObject
        private Notification.Builder realBuilder;
        private CharSequence contentTitle;
        private CharSequence contentInfo;
        private CharSequence contentText;
        private CharSequence ticker;
        private int smallIcon;
        private boolean ongoing;
        private long when;
        private boolean showWhen = true;
        private ArrayList<Notification.Action> actions = new ArrayList(3);
        private Notification.Style style;
        private Progress progress;
        private boolean usesChronometer;

        @Implementation
        public Notification build() {
            Notification result = (Notification)Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"build", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            this.populateShadow(result);
            return result;
        }

        @Implementation
        public Notification buildUnstyled() {
            Notification result = (Notification)Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"buildUnstyled", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            this.populateShadow(result);
            return result;
        }

        private void populateShadow(Notification result) {
            ShadowNotification s = Shadows.shadowOf(result);
            s.setContentTitle(this.contentTitle);
            s.setContentText(this.contentText);
            s.setSmallIcon(this.smallIcon);
            s.setTicker(this.ticker);
            s.setWhen(this.when);
            s.setShowWhen(this.showWhen);
            s.setContentInfo(this.contentInfo);
            s.setActions(this.actions);
            s.setStyle(this.style);
            s.setProgress(this.progress);
            s.setUsesChronometer(this.usesChronometer);
            s.setOngoing(this.ongoing);
        }

        @Implementation
        public Notification.Builder setContentTitle(CharSequence contentTitle) {
            this.contentTitle = contentTitle;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setContentTitle", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)contentTitle)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setContentText(CharSequence text) {
            this.contentText = text;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setContentText", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)text)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setSmallIcon(int smallIcon) {
            this.smallIcon = smallIcon;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setSmallIcon", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)smallIcon)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setOngoing(boolean ongoing) {
            this.ongoing = ongoing;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setOngoing", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)ongoing)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setWhen(long when) {
            this.when = when;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setWhen", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)when)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setTicker(CharSequence ticker) {
            this.ticker = ticker;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setTicker", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)ticker)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setContentInfo(CharSequence contentInfo) {
            this.contentInfo = contentInfo;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setContentInfo", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)contentInfo)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder addAction(int icon, CharSequence title, PendingIntent intent) {
            this.actions.add(new Notification.Action(icon, title, intent));
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setStyle(Notification.Style style) {
            this.style = style;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setStyle", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Notification.Style.class, (Object)style)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setProgress(int max, int progress, boolean indeterminate) {
            this.progress = new Progress(max, progress, indeterminate);
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setProgress", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)max), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)progress), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)indeterminate)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setUsesChronometer(boolean usesChronometer) {
            this.usesChronometer = usesChronometer;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setUsesChronometer", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)usesChronometer)});
            return this.realBuilder;
        }

        @Implementation
        public Notification.Builder setShowWhen(boolean showWhen) {
            this.showWhen = showWhen;
            Shadow.directlyOn((Object)this.realBuilder, Notification.Builder.class, (String)"setShowWhen", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)showWhen)});
            return this.realBuilder;
        }
    }

    public static class Progress {
        public final int max;
        public final int progress;
        public final boolean indeterminate;

        private Progress(int max, int progress, boolean indeterminate) {
            this.max = max;
            this.progress = progress;
            this.indeterminate = indeterminate;
        }
    }

    public static class LatestEventInfo {
        private final CharSequence contentTitle;
        private final CharSequence contentText;
        private final PendingIntent contentIntent;

        private LatestEventInfo(CharSequence contentTitle, CharSequence contentText, PendingIntent contentIntent) {
            this.contentTitle = contentTitle;
            this.contentText = contentText;
            this.contentIntent = contentIntent;
        }

        public CharSequence getContentTitle() {
            return this.contentTitle;
        }

        public CharSequence getContentText() {
            return this.contentText;
        }

        public PendingIntent getContentIntent() {
            return this.contentIntent;
        }
    }
}

