/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;
import org.robolectric.util.SoftThreadLocal;

@Implements(value=Looper.class)
public class ShadowLooper {
    private static final Thread MAIN_THREAD = Thread.currentThread();
    private static SoftThreadLocal<Looper> looperForThread = ShadowLooper.makeThreadLocalLoopers();
    private Scheduler scheduler = new Scheduler();
    private Thread myThread = Thread.currentThread();
    @RealObject
    private Looper realObject;
    boolean quit;

    private static SoftThreadLocal<Looper> makeThreadLocalLoopers() {
        return new SoftThreadLocal<Looper>(){

            protected Looper create() {
                return ShadowLooper.createLooper();
            }
        };
    }

    private static Looper createLooper() {
        return (Looper)ReflectionHelpers.callConstructor(Looper.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)(Thread.currentThread() != MAIN_THREAD ? 1 : 0))});
    }

    @Resetter
    public static synchronized void resetThreadLoopers() {
        if (Thread.currentThread() != MAIN_THREAD) {
            throw new RuntimeException("you should only be calling this from the main thread!");
        }
        Looper mainLooper = (Looper)looperForThread.get();
        looperForThread = ShadowLooper.makeThreadLocalLoopers();
        looperForThread.set((Object)mainLooper);
        Shadows.shadowOf(mainLooper).reset();
    }

    @Implementation
    public static Looper getMainLooper() {
        ShadowApplication shadowApplication = ShadowApplication.getInstance();
        if (shadowApplication == null && Thread.currentThread() == MAIN_THREAD) {
            Looper mainLooper = (Looper)looperForThread.get();
            return mainLooper;
        }
        return shadowApplication.getMainLooper();
    }

    @Implementation
    public static void loop() {
        Shadows.shadowOf(ShadowLooper.myLooper()).doLoop();
    }

    @Implementation
    public static synchronized Looper myLooper() {
        return (Looper)looperForThread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoop() {
        if (this != Shadows.shadowOf(ShadowLooper.getMainLooper())) {
            Looper looper = this.realObject;
            synchronized (looper) {
                while (!this.quit) {
                    try {
                        this.realObject.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public void quit() {
        if (this == Shadows.shadowOf(ShadowLooper.getMainLooper())) {
            throw new RuntimeException("Main thread not allowed to quit");
        }
        Looper looper = this.realObject;
        synchronized (looper) {
            this.quit = true;
            this.scheduler.reset();
            this.realObject.notifyAll();
        }
    }

    @Implementation
    public Thread getThread() {
        return this.myThread;
    }

    @HiddenApi
    @Implementation
    public int postSyncBarrier() {
        return 1;
    }

    @HiddenApi
    @Implementation
    public void removeSyncBarrier(int token) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasQuit() {
        Looper looper = this.realObject;
        synchronized (looper) {
            return this.quit;
        }
    }

    public static void pauseLooper(Looper looper) {
        Shadows.shadowOf(looper).pause();
    }

    public static void unPauseLooper(Looper looper) {
        Shadows.shadowOf(looper).unPause();
    }

    public static void pauseMainLooper() {
        ShadowLooper.pauseLooper(Looper.getMainLooper());
    }

    public static void unPauseMainLooper() {
        ShadowLooper.unPauseLooper(Looper.getMainLooper());
    }

    public static void idleMainLooper() {
        Shadows.shadowOf(Looper.getMainLooper()).idle();
    }

    public static void idleMainLooper(long interval) {
        Shadows.shadowOf(Looper.getMainLooper()).idle(interval);
    }

    public static void idleMainLooperConstantly(boolean shouldIdleConstantly) {
        Shadows.shadowOf(Looper.getMainLooper()).idleConstantly(shouldIdleConstantly);
    }

    public static void runMainLooperOneTask() {
        Shadows.shadowOf(Looper.getMainLooper()).runOneTask();
    }

    public static void runMainLooperToNextTask() {
        Shadows.shadowOf(Looper.getMainLooper()).runToNextTask();
    }

    public static void runUiThreadTasks() {
        ShadowApplication.getInstance().getForegroundThreadScheduler().advanceBy(0L);
    }

    public static void runUiThreadTasksIncludingDelayedTasks() {
        ShadowApplication.getInstance().getForegroundThreadScheduler().advanceToLastPostedRunnable();
    }

    public void idle() {
        this.scheduler.advanceBy(0L);
    }

    public void idle(long intervalMillis) {
        this.scheduler.advanceBy(intervalMillis);
    }

    public void idleConstantly(boolean shouldIdleConstantly) {
        this.scheduler.idleConstantly(shouldIdleConstantly);
    }

    public void runToEndOfTasks() {
        this.scheduler.advanceToLastPostedRunnable();
    }

    public void runToNextTask() {
        this.scheduler.advanceToNextPostedRunnable();
    }

    public void runOneTask() {
        this.scheduler.runOneTask();
    }

    @Deprecated
    public boolean post(Runnable runnable, long delayMillis) {
        if (!this.quit) {
            this.scheduler.postDelayed(runnable, delayMillis);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean postAtFrontOfQueue(Runnable runnable) {
        if (!this.quit) {
            this.scheduler.postAtFrontOfQueue(runnable);
            return true;
        }
        return false;
    }

    public void pause() {
        this.scheduler.pause();
    }

    public void unPause() {
        this.scheduler.unPause();
    }

    public boolean isPaused() {
        return this.scheduler.isPaused();
    }

    public boolean setPaused(boolean shouldPause) {
        boolean wasPaused = this.isPaused();
        if (shouldPause) {
            this.pause();
        } else {
            this.unPause();
        }
        return wasPaused;
    }

    public void reset() {
        this.scheduler = new Scheduler();
        Shadows.shadowOf(this.realObject.getQueue()).reset();
        this.quit = false;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void runPaused(Runnable r) {
        boolean wasPaused = this.setPaused(true);
        try {
            r.run();
        }
        finally {
            if (!wasPaused) {
                this.unPause();
            }
        }
    }
}

