/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=Log.class)
public class ShadowLog {
    private static final int extraLogLength = "l/: \n".length();
    private static Map<String, List<LogItem>> logsByTag = new HashMap<String, List<LogItem>>();
    private static List<LogItem> logs = new ArrayList<LogItem>();
    public static PrintStream stream;
    private static final Map<String, Integer> tagToLevel;

    @Implementation
    public static void e(String tag, String msg) {
        ShadowLog.e(tag, msg, null);
    }

    @Implementation
    public static void e(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(6, tag, msg, throwable);
    }

    @Implementation
    public static void d(String tag, String msg) {
        ShadowLog.d(tag, msg, null);
    }

    @Implementation
    public static void d(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(3, tag, msg, throwable);
    }

    @Implementation
    public static void i(String tag, String msg) {
        ShadowLog.i(tag, msg, null);
    }

    @Implementation
    public static void i(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(4, tag, msg, throwable);
    }

    @Implementation
    public static void v(String tag, String msg) {
        ShadowLog.v(tag, msg, null);
    }

    @Implementation
    public static void v(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(2, tag, msg, throwable);
    }

    @Implementation
    public static void w(String tag, String msg) {
        ShadowLog.w(tag, msg, null);
    }

    @Implementation
    public static void w(String tag, Throwable throwable) {
        ShadowLog.w(tag, null, throwable);
    }

    @Implementation
    public static void w(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(5, tag, msg, throwable);
    }

    @Implementation
    public static void wtf(String tag, String msg) {
        ShadowLog.wtf(tag, msg, null);
    }

    @Implementation
    public static void wtf(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(7, tag, msg, throwable);
    }

    @Implementation
    public static synchronized boolean isLoggable(String tag, int level) {
        if (tagToLevel.containsKey(tag)) {
            return level >= tagToLevel.get(tag);
        }
        return stream != null || level >= 4;
    }

    @Implementation
    public static int println(int priority, String tag, String msg) {
        ShadowLog.addLog(priority, tag, msg, null);
        int tagLength = tag == null ? 0 : tag.length();
        int msgLength = msg == null ? 0 : msg.length();
        return extraLogLength + tagLength + msgLength;
    }

    public static synchronized void setLoggable(String tag, int level) {
        tagToLevel.put(tag, level);
    }

    private static synchronized void addLog(int level, String tag, String msg, Throwable throwable) {
        List<Object> itemList;
        if (stream != null) {
            ShadowLog.logToStream(stream, level, tag, msg, throwable);
        }
        LogItem item = new LogItem(level, tag, msg, throwable);
        if (!logsByTag.containsKey(tag)) {
            itemList = new ArrayList();
            logsByTag.put(tag, itemList);
        } else {
            itemList = logsByTag.get(tag);
        }
        itemList.add(item);
        logs.add(item);
    }

    private static void logToStream(PrintStream ps, int level, String tag, String msg, Throwable throwable) {
        char c;
        switch (level) {
            case 7: {
                c = 'A';
                break;
            }
            case 3: {
                c = 'D';
                break;
            }
            case 6: {
                c = 'E';
                break;
            }
            case 5: {
                c = 'W';
                break;
            }
            case 4: {
                c = 'I';
                break;
            }
            case 2: {
                c = 'V';
                break;
            }
            default: {
                c = '?';
            }
        }
        ps.println(c + "/" + tag + ": " + msg);
        if (throwable != null) {
            throwable.printStackTrace(ps);
        }
    }

    public static synchronized List<LogItem> getLogs() {
        return logs;
    }

    public static synchronized List<LogItem> getLogsForTag(String tag) {
        return logsByTag.get(tag);
    }

    @Resetter
    public static synchronized void reset() {
        logs.clear();
        logsByTag.clear();
        tagToLevel.clear();
    }

    public static void setupLogging() {
        String logging = System.getProperty("robolectric.logging");
        if (logging != null && stream == null) {
            PrintStream stream = null;
            if ("stdout".equalsIgnoreCase(logging)) {
                stream = System.out;
            } else if ("stderr".equalsIgnoreCase(logging)) {
                stream = System.err;
            } else {
                try {
                    PrintStream file;
                    stream = file = new PrintStream(new FileOutputStream(logging), true);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                file.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ShadowLog.stream = stream;
        }
    }

    static {
        tagToLevel = new HashMap<String, Integer>();
    }

    public static class LogItem {
        public final int type;
        public final String tag;
        public final String msg;
        public final Throwable throwable;

        public LogItem(int type, String tag, String msg, Throwable throwable) {
            this.type = type;
            this.tag = tag;
            this.msg = msg;
            this.throwable = throwable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogItem log = (LogItem)o;
            return !(this.type != log.type || (this.msg == null ? log.msg != null : !this.msg.equals(log.msg)) || (this.tag == null ? log.tag != null : !this.tag.equals(log.tag)) || (this.throwable == null ? log.throwable != null : !this.throwable.equals(log.throwable)));
        }

        public int hashCode() {
            int result = this.type;
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            result = 31 * result + (this.msg != null ? this.msg.hashCode() : 0);
            result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "LogItem{type=" + this.type + ", tag='" + this.tag + '\'' + ", msg='" + this.msg + '\'' + ", throwable=" + this.throwable + '}';
        }
    }
}

