/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Environment;
import android.view.View;
import java.io.File;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.res.Attribute;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceLoader;
import org.robolectric.shadows.RoboAttributeSet;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Context.class)
public abstract class ShadowContext {
    @RealObject
    private Context realContext;
    private ShadowApplication shadowApplication;

    @Implementation
    public String getString(int resId) {
        return this.realContext.getResources().getString(resId);
    }

    @Implementation
    public CharSequence getText(int resId) {
        return this.realContext.getResources().getText(resId);
    }

    @Implementation
    public String getString(int resId, Object ... formatArgs) {
        return this.realContext.getResources().getString(resId, formatArgs);
    }

    public RoboAttributeSet createAttributeSet(List<Attribute> attributes, Class<? extends View> viewClass) {
        return new RoboAttributeSet(attributes, this.getResourceLoader());
    }

    @Implementation
    public Resources getResources() {
        throw new RuntimeException("you should override me in a subclass!");
    }

    @Implementation
    public File getExternalCacheDir() {
        return Environment.getExternalStorageDirectory();
    }

    @Implementation
    public File getExternalFilesDir(String type) {
        return Environment.getExternalStoragePublicDirectory((String)type);
    }

    public ResourceLoader getResourceLoader() {
        return Shadows.shadowOf((Application)this.realContext.getApplicationContext()).getResourceLoader();
    }

    public boolean isStrictI18n() {
        return this.getShadowApplication().isStrictI18n();
    }

    public ResName getResName(int resourceId) {
        return this.getResourceLoader().getResourceIndex().getResName(resourceId);
    }

    public ShadowApplication getShadowApplication() {
        return this.shadowApplication;
    }

    public void callAttachBaseContext(Context context) {
        ReflectionHelpers.callInstanceMethod((Object)this.realContext, (String)"attachBaseContext", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }
}

