/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;

@Implements(value=ClipboardManager.class)
public class ShadowClipboardManager {
    @RealObject
    private ClipboardManager realClipboardManager;
    private final Collection<ClipboardManager.OnPrimaryClipChangedListener> listeners = new CopyOnWriteArrayList<ClipboardManager.OnPrimaryClipChangedListener>();
    private ClipData clip;

    @Implementation
    public void setPrimaryClip(ClipData clip) {
        if (clip != null) {
            clip.prepareToLeaveProcess();
        }
        this.clip = clip;
        for (ClipboardManager.OnPrimaryClipChangedListener listener : this.listeners) {
            listener.onPrimaryClipChanged();
        }
    }

    @Implementation
    public ClipData getPrimaryClip() {
        return this.clip;
    }

    @Implementation
    public ClipDescription getPrimaryClipDescription() {
        return this.clip == null ? null : this.clip.getDescription();
    }

    @Implementation
    public boolean hasPrimaryClip() {
        return this.clip != null;
    }

    @Implementation
    public void addPrimaryClipChangedListener(ClipboardManager.OnPrimaryClipChangedListener listener) {
        this.listeners.add(listener);
    }

    @Implementation
    public void removePrimaryClipChangedListener(ClipboardManager.OnPrimaryClipChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Implementation
    public void setText(CharSequence text) {
        this.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)text));
    }

    @Implementation
    public boolean hasText() {
        CharSequence text = ((ClipboardManager)Shadow.directlyOn((Object)this.realClipboardManager, ClipboardManager.class)).getText();
        return text != null && text.length() > 0;
    }
}

