/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Binder;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowBinderBridge;

@Implements(value=Binder.class)
public class ShadowBinder {
    @RealObject
    Binder realObject;
    private static Integer callingUid;
    private static Integer callingPid;

    @Implementation
    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        return new ShadowBinderBridge(this.realObject).onTransact(code, data, reply, flags);
    }

    @Implementation
    public static final int getCallingPid() {
        if (callingPid != null) {
            return callingPid;
        }
        return Process.myPid();
    }

    @Implementation
    public static final int getCallingUid() {
        if (callingUid != null) {
            return callingUid;
        }
        return Process.myUid();
    }

    public static void setCallingPid(int pid) {
        callingPid = pid;
    }

    public static void setCallingUid(int uid) {
        callingUid = uid;
    }

    @Resetter
    public static void reset() {
        callingPid = null;
        callingUid = null;
    }
}

