/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.OnAccountsUpdateListener;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.internal.Shadow;

@Implements(value=AccountManager.class)
public class ShadowAccountManager {
    private static final Object lock = new Object();
    private static AccountManager instance;
    private List<Account> accounts = new ArrayList<Account>();
    private Map<Account, Map<String, String>> authTokens = new HashMap<Account, Map<String, String>>();
    private Map<String, AuthenticatorDescription> authenticators = new LinkedHashMap<String, AuthenticatorDescription>();
    private List<OnAccountsUpdateListener> listeners = new ArrayList<OnAccountsUpdateListener>();
    private Map<Account, Map<String, String>> userData = new HashMap<Account, Map<String, String>>();
    private Map<Account, String> passwords = new HashMap<Account, String>();
    private AccountManagerCallback<Bundle> pendingAddCallback;
    private RoboAccountManagerFuture pendingAddFuture;
    private List<Bundle> addAccountOptionsList = new ArrayList<Bundle>();
    private Map<Account, String> previousNames = new HashMap<Account, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            instance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public static AccountManager get(Context context) {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = (AccountManager)Shadow.newInstanceOf(AccountManager.class);
            }
            return instance;
        }
    }

    @Implementation
    public Account[] getAccounts() {
        return this.accounts.toArray(new Account[this.accounts.size()]);
    }

    @Implementation
    public Account[] getAccountsByType(String type) {
        ArrayList<Account> accountsByType = new ArrayList<Account>();
        for (Account a : this.accounts) {
            if (!type.equals(a.type)) continue;
            accountsByType.add(a);
        }
        return accountsByType.toArray(new Account[accountsByType.size()]);
    }

    @Implementation
    public synchronized void setAuthToken(Account account, String tokenType, String authToken) {
        if (this.accounts.contains(account)) {
            Map<String, String> tokenMap = this.authTokens.get(account);
            if (tokenMap == null) {
                tokenMap = new HashMap<String, String>();
                this.authTokens.put(account, tokenMap);
            }
            tokenMap.put(tokenType, authToken);
        }
    }

    @Implementation
    public String peekAuthToken(Account account, String tokenType) {
        Map<String, String> tokenMap = this.authTokens.get(account);
        if (tokenMap != null) {
            return tokenMap.get(tokenType);
        }
        return null;
    }

    @Implementation
    public boolean addAccountExplicitly(Account account, String password, Bundle userdata) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        for (Account a : this.getAccountsByType(account.type)) {
            if (!a.name.equals(account.name)) continue;
            return false;
        }
        if (!this.accounts.add(account)) {
            return false;
        }
        this.setPassword(account, password);
        if (userdata != null) {
            for (String key : userdata.keySet()) {
                this.setUserData(account, key, userdata.get(key).toString());
            }
        }
        return true;
    }

    @Implementation
    public String blockingGetAuthToken(Account account, String authTokenType, boolean notifyAuthFailure) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        Map<String, String> tokensForAccount = this.authTokens.get(account);
        if (tokensForAccount == null) {
            return null;
        }
        return tokensForAccount.get(authTokenType);
    }

    @Implementation
    public AccountManagerFuture<Boolean> removeAccount(Account account, AccountManagerCallback<Boolean> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        final boolean accountRemoved = this.accounts.remove(account);
        this.passwords.remove(account);
        this.userData.remove(account);
        return new AccountManagerFuture<Boolean>(){

            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            public boolean isCancelled() {
                return false;
            }

            public boolean isDone() {
                return false;
            }

            public Boolean getResult() throws OperationCanceledException, IOException, AuthenticatorException {
                return accountRemoved;
            }

            public Boolean getResult(long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
                return accountRemoved;
            }
        };
    }

    @Implementation
    public AuthenticatorDescription[] getAuthenticatorTypes() {
        return this.authenticators.values().toArray(new AuthenticatorDescription[this.authenticators.size()]);
    }

    @Implementation
    public void addOnAccountsUpdatedListener(OnAccountsUpdateListener listener, Handler handler, boolean updateImmediately) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
        if (updateImmediately) {
            listener.onAccountsUpdated(this.getAccounts());
        }
    }

    @Implementation
    public String getUserData(Account account, String key) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (!this.userData.containsKey(account)) {
            return null;
        }
        Map<String, String> userDataMap = this.userData.get(account);
        if (userDataMap.containsKey(key)) {
            return userDataMap.get(key);
        }
        return null;
    }

    @Implementation
    public void setUserData(Account account, String key, String value) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (!this.userData.containsKey(account)) {
            this.userData.put(account, new HashMap());
        }
        Map<String, String> userDataMap = this.userData.get(account);
        if (value == null) {
            userDataMap.remove(key);
        } else {
            userDataMap.put(key, value);
        }
    }

    @Implementation
    public void setPassword(Account account, String password) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (password == null) {
            this.passwords.remove(account);
        } else {
            this.passwords.put(account, password);
        }
    }

    @Implementation
    public String getPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (this.passwords.containsKey(account)) {
            return this.passwords.get(account);
        }
        return null;
    }

    @Implementation
    public void invalidateAuthToken(String accountType, String authToken) {
        Account[] accountsByType;
        for (Account account : accountsByType = this.getAccountsByType(accountType)) {
            Map<String, String> tokenMap = this.authTokens.get(account);
            if (tokenMap == null) continue;
            Iterator<Map.Entry<String, String>> it = tokenMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> map = it.next();
                if (!map.getValue().equals(authToken)) continue;
                it.remove();
            }
            this.authTokens.put(account, tokenMap);
        }
    }

    private void notifyListeners() {
        Account[] accounts = this.getAccounts();
        for (OnAccountsUpdateListener listener : this.listeners) {
            listener.onAccountsUpdated(accounts);
        }
    }

    public void addAccount(Account account) {
        this.accounts.add(account);
        if (this.pendingAddCallback != null) {
            this.pendingAddFuture.resultBundle.putString("authAccount", account.name);
            this.pendingAddCallback.run((AccountManagerFuture)this.pendingAddFuture);
        }
        this.notifyListeners();
    }

    public Bundle getNextAddAccountOptions() {
        if (this.addAccountOptionsList.isEmpty()) {
            return null;
        }
        return this.addAccountOptionsList.remove(0);
    }

    public Bundle peekNextAddAccountOptions() {
        if (this.addAccountOptionsList.isEmpty()) {
            return null;
        }
        return this.addAccountOptionsList.get(0);
    }

    @Implementation
    public AccountManagerFuture<Bundle> addAccount(String accountType, String authTokenType, String[] requiredFeatures, Bundle addAccountOptions, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        Bundle resultBundle = new Bundle();
        if (activity == null) {
            Intent resultIntent = new Intent();
            resultBundle.putParcelable("intent", (Parcelable)resultIntent);
        } else if (callback == null) {
            resultBundle.putString("authAccount", "some_user@gmail.com");
        }
        this.addAccountOptionsList.add(addAccountOptions);
        this.pendingAddCallback = callback;
        this.pendingAddFuture = new RoboAccountManagerFuture(accountType, resultBundle);
        return this.pendingAddFuture;
    }

    public void addAuthenticator(AuthenticatorDescription authenticator) {
        this.authenticators.put(authenticator.type, authenticator);
    }

    public void addAuthenticator(String type) {
        this.addAuthenticator(AuthenticatorDescription.newKey((String)type));
    }

    public void setPreviousAccountName(Account account, String previousName) {
        this.previousNames.put(account, previousName);
    }

    @Implementation
    public String getPreviousName(Account account) {
        return this.previousNames.get(account);
    }

    private class RoboAccountManagerFuture
    implements AccountManagerFuture<Bundle> {
        private final String accountType;
        final Bundle resultBundle;

        public RoboAccountManagerFuture(String accountType, Bundle resultBundle) {
            this.accountType = accountType;
            this.resultBundle = resultBundle;
        }

        public boolean cancel(boolean b) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return this.resultBundle.containsKey("authAccount");
        }

        public Bundle getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            if (!ShadowAccountManager.this.authenticators.containsKey(this.accountType)) {
                throw new AuthenticatorException("No authenticator specified for " + this.accountType);
            }
            this.resultBundle.putString("accountType", this.accountType);
            return this.resultBundle;
        }

        public Bundle getResult(long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            if (!ShadowAccountManager.this.authenticators.containsKey(this.accountType)) {
                throw new AuthenticatorException("No authenticator specified for " + this.accountType);
            }
            return this.resultBundle;
        }
    }
}

