/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.fakes;

import android.content.SharedPreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RoboSharedPreferences
implements SharedPreferences {
    public Map<String, Map<String, Object>> content;
    protected String filename;
    public int mode;
    private ArrayList<SharedPreferences.OnSharedPreferenceChangeListener> listeners;

    public RoboSharedPreferences(Map<String, Map<String, Object>> content, String name, int mode) {
        this.content = content;
        this.filename = name;
        this.mode = mode;
        if (!content.containsKey(name)) {
            content.put(name, new HashMap());
        }
        this.listeners = new ArrayList();
    }

    public Map<String, ?> getAll() {
        return new HashMap<String, Object>(this.content.get(this.filename));
    }

    public String getString(String key, String defValue) {
        return (String)this.getValue(key, defValue);
    }

    private Object getValue(String key, Object defValue) {
        Object value;
        Map<String, Object> fileHash = this.content.get(this.filename);
        if (fileHash != null && (value = fileHash.get(key)) != null) {
            return value;
        }
        return defValue;
    }

    public int getInt(String key, int defValue) {
        return (Integer)this.getValue(key, defValue);
    }

    public long getLong(String key, long defValue) {
        return (Long)this.getValue(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        return ((Float)this.getValue(key, Float.valueOf(defValue))).floatValue();
    }

    public boolean getBoolean(String key, boolean defValue) {
        return (Boolean)this.getValue(key, defValue);
    }

    public boolean contains(String key) {
        return this.content.get(this.filename).containsKey(key);
    }

    public SharedPreferences.Editor edit() {
        return new TestSharedPreferencesEditor();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public boolean hasListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        return this.listeners.contains(listener);
    }

    public Set<String> getStringSet(String key, Set<String> defValues) {
        Set<String> v = (Set<String>)this.getValue(key, defValues);
        return v != null ? v : defValues;
    }

    private class TestSharedPreferencesEditor
    implements SharedPreferences.Editor {
        Map<String, Object> editsThatNeedCommit = new HashMap<String, Object>();
        Set<String> editsThatNeedRemove = new HashSet<String>();
        private boolean shouldClearOnCommit = false;

        private TestSharedPreferencesEditor() {
        }

        public SharedPreferences.Editor putString(String key, String value) {
            if (value == null) {
                this.editsThatNeedRemove.add(key);
            } else {
                this.editsThatNeedCommit.put(key, value);
                this.editsThatNeedRemove.remove(key);
            }
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            this.editsThatNeedCommit.put(key, value);
            this.editsThatNeedRemove.remove(key);
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            this.editsThatNeedCommit.put(key, value);
            this.editsThatNeedRemove.remove(key);
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            this.editsThatNeedCommit.put(key, Float.valueOf(value));
            this.editsThatNeedRemove.remove(key);
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.editsThatNeedCommit.put(key, value);
            this.editsThatNeedRemove.remove(key);
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, Set<String> value) {
            if (value == null) {
                this.editsThatNeedRemove.add(key);
            } else {
                this.editsThatNeedCommit.put(key, value);
                this.editsThatNeedRemove.remove(key);
            }
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.editsThatNeedRemove.add(key);
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.shouldClearOnCommit = true;
            return this;
        }

        public boolean commit() {
            Map<String, Object> previousContent = RoboSharedPreferences.this.content.get(RoboSharedPreferences.this.filename);
            ArrayList<String> keysToPassToListeners = new ArrayList<String>();
            if (this.shouldClearOnCommit) {
                previousContent.clear();
            } else {
                for (String key : this.editsThatNeedRemove) {
                    previousContent.remove(key);
                    keysToPassToListeners.add(key);
                }
                this.editsThatNeedRemove.clear();
            }
            for (String key : this.editsThatNeedCommit.keySet()) {
                if (this.editsThatNeedCommit.get(key).equals(previousContent.get(key))) continue;
                previousContent.put(key, this.editsThatNeedCommit.get(key));
                keysToPassToListeners.add(key);
            }
            this.editsThatNeedCommit.clear();
            for (SharedPreferences.OnSharedPreferenceChangeListener listener : RoboSharedPreferences.this.listeners) {
                for (String key : keysToPassToListeners) {
                    listener.onSharedPreferenceChanged((SharedPreferences)RoboSharedPreferences.this, key);
                }
            }
            return true;
        }

        public void apply() {
            this.commit();
        }
    }
}

