/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ReflectionHelpers {
    public static final Map<String, Object> PRIMITIVE_RETURN_VALUES = Collections.unmodifiableMap(new HashMap<String, Object>(){
        {
            this.put("boolean", Boolean.FALSE);
            this.put("int", 0);
            this.put("long", 0L);
            this.put("float", Float.valueOf(0.0f));
            this.put("double", 0.0);
            this.put("short", (short)0);
            this.put("byte", (byte)0);
        }
    });

    public static <T> T createNullProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return PRIMITIVE_RETURN_VALUES.get(method.getReturnType().getName());
            }
        });
    }

    public static <T> T createDelegatingProxy(Class<T> clazz, final Object delegate) {
        final Class<?> delegateClass = delegate.getClass();
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Method delegateMethod = delegateClass.getMethod(method.getName(), method.getParameterTypes());
                    delegateMethod.setAccessible(true);
                    return delegateMethod.invoke(delegate, args);
                }
                catch (NoSuchMethodException e) {
                    return PRIMITIVE_RETURN_VALUES.get(method.getReturnType().getName());
                }
            }
        });
    }

    public static <A extends Annotation> A defaultsFor(Class<A> annotation) {
        return (A)((Annotation)annotation.cast(Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.getDefaultValue();
            }
        })));
    }

    public static <R> R getField(final Object object, final String fieldName) {
        try {
            return ReflectionHelpers.traverseClassHierarchy(object.getClass(), NoSuchFieldException.class, new InsideTraversal<R>(){

                @Override
                public R run(Class<?> traversalClass) throws Exception {
                    Field field = traversalClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    return field.get(object);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(final Object object, final String fieldName, final Object fieldNewValue) {
        try {
            ReflectionHelpers.traverseClassHierarchy(object.getClass(), NoSuchFieldException.class, new InsideTraversal<Void>(){

                @Override
                public Void run(Class<?> traversalClass) throws Exception {
                    Field field = traversalClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(object, fieldNewValue);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Class<?> type, Object object, String fieldName, Object fieldNewValue) {
        try {
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, fieldNewValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R getStaticField(Field field) {
        try {
            ReflectionHelpers.makeFieldVeryAccessible(field);
            return (R)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R getStaticField(Class<?> clazz, String fieldName) {
        try {
            return ReflectionHelpers.getStaticField(clazz.getDeclaredField(fieldName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticField(Field field, Object fieldNewValue) {
        try {
            ReflectionHelpers.makeFieldVeryAccessible(field);
            field.set(null, fieldNewValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticField(Class<?> clazz, String fieldName, Object fieldNewValue) {
        try {
            ReflectionHelpers.setStaticField(clazz.getDeclaredField(fieldName), fieldNewValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callInstanceMethod(final Object instance, final String methodName, ClassParameter<?> ... classParameters) {
        try {
            final Class[] classes = ClassParameter.getClasses(classParameters);
            final Object[] values = ClassParameter.getValues(classParameters);
            return ReflectionHelpers.traverseClassHierarchy(instance.getClass(), NoSuchMethodException.class, new InsideTraversal<R>(){

                @Override
                public R run(Class<?> traversalClass) throws Exception {
                    Method declaredMethod = traversalClass.getDeclaredMethod(methodName, classes);
                    declaredMethod.setAccessible(true);
                    return declaredMethod.invoke(instance, values);
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callInstanceMethod(Class<?> cl, Object instance, String methodName, ClassParameter<?> ... classParameters) {
        try {
            Class<?>[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            Method declaredMethod = cl.getDeclaredMethod(methodName, classes);
            declaredMethod.setAccessible(true);
            return (R)declaredMethod.invoke(instance, values);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callStaticMethod(Class<?> clazz, String methodName, ClassParameter<?> ... classParameters) {
        try {
            Class<?>[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            Method method = clazz.getDeclaredMethod(methodName, classes);
            method.setAccessible(true);
            return (R)method.invoke(null, values);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("no such method " + clazz + "." + methodName, e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> loadClass(ClassLoader classLoader, String fullyQualifiedClassName) {
        try {
            return classLoader.loadClass(fullyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> cl) {
        try {
            return cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callConstructor(Class<? extends R> clazz, ClassParameter<?> ... classParameters) {
        try {
            Class<?>[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            Constructor<R> constructor = clazz.getDeclaredConstructor(classes);
            constructor.setAccessible(true);
            return constructor.newInstance(values);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("error instantiating " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <R, E extends Exception> R traverseClassHierarchy(Class<?> targetClass, Class<? extends E> exceptionClass, InsideTraversal<R> insideTraversal) throws Exception {
        Class<?> hierarchyTraversalClass = targetClass;
        while (true) {
            try {
                return insideTraversal.run(hierarchyTraversalClass);
            }
            catch (Exception e) {
                if (exceptionClass.isInstance(e)) continue;
                throw e;
                if ((hierarchyTraversalClass = hierarchyTraversalClass.getSuperclass()) != null) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }

    private static void makeFieldVeryAccessible(Field field) {
        field.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            try {
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static Object defaultValueForType(String returnType) {
        return PRIMITIVE_RETURN_VALUES.get(returnType);
    }

    public static class StringParameter<V> {
        public final String className;
        public final V val;

        public StringParameter(String className, V val) {
            this.className = className;
            this.val = val;
        }

        public static <V> StringParameter<V> from(String className, V val) {
            return new StringParameter<V>(className, val);
        }
    }

    public static class ClassParameter<V> {
        public final Class<? extends V> clazz;
        public final V val;

        public ClassParameter(Class<? extends V> clazz, V val) {
            this.clazz = clazz;
            this.val = val;
        }

        public static <V> ClassParameter<V> from(Class<? extends V> clazz, V val) {
            return new ClassParameter<V>(clazz, val);
        }

        public static ClassParameter<?>[] fromComponentLists(Class<?>[] classes, Object[] values) {
            ClassParameter[] classParameters = new ClassParameter[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                classParameters[i] = ClassParameter.from(classes[i], values[i]);
            }
            return classParameters;
        }

        public static Class<?>[] getClasses(ClassParameter<?> ... classParameters) {
            Class[] classes = new Class[classParameters.length];
            for (int i = 0; i < classParameters.length; ++i) {
                Class paramClass;
                classes[i] = paramClass = classParameters[i].clazz;
            }
            return classes;
        }

        public static Object[] getValues(ClassParameter<?> ... classParameters) {
            Object[] values = new Object[classParameters.length];
            for (int i = 0; i < classParameters.length; ++i) {
                Object paramValue = classParameters[i].val;
                values[i] = paramValue;
            }
            return values;
        }
    }

    private static interface InsideTraversal<R> {
        public R run(Class<?> var1) throws Exception;
    }
}

