/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.util.ListIterator;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.ClassInstrumentor;
import org.robolectric.internal.bytecode.DirectObjectMarker;
import org.robolectric.internal.bytecode.MutableClass;
import org.robolectric.internal.bytecode.RobolectricGeneratorAdapter;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class OldClassInstrumentor
extends ClassInstrumentor {
    private static final Type PLAN_TYPE = Type.getType(ClassHandler.Plan.class);
    static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    static final Type ROBOLECTRIC_INTERNALS_TYPE = Type.getType(RobolectricInternals.class);
    private static final Method INITIALIZING_METHOD = new Method("initializing", "(Ljava/lang/Object;)Ljava/lang/Object;");
    private static final Method METHOD_INVOKED_METHOD;
    private static final Method PLAN_RUN_METHOD;
    static final Method HANDLE_EXCEPTION_METHOD;
    private static final String DIRECT_OBJECT_MARKER_TYPE_DESC;

    public OldClassInstrumentor(ClassInstrumentor.Decorator decorator) {
        super(decorator);
    }

    @Override
    protected void addDirectCallConstructor(MutableClass mutableClass) {
        String string = DIRECT_OBJECT_MARKER_TYPE_DESC;
        String string2 = mutableClass.classType.getDescriptor();
        MethodNode directCallConstructor = new MethodNode(1, "<init>", new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append("(").append(string).append(string2).append(")V").toString(), null, null);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(directCallConstructor);
        generator.loadThis();
        String superName = mutableClass.classNode.superName;
        if (superName.equals("java/lang/Object")) {
            generator.visitMethodInsn(183, superName, "<init>", "()V", false);
        } else {
            generator.loadArgs();
            String string3 = DIRECT_OBJECT_MARKER_TYPE_DESC;
            generator.visitMethodInsn(183, superName, "<init>", new StringBuilder(5 + String.valueOf(string3).length() + String.valueOf(superName).length()).append("(").append(string3).append("L").append(superName).append(";)V").toString(), false);
        }
        generator.loadThis();
        generator.loadArg(1);
        generator.putField(mutableClass.classType, "__robo_data__", OBJECT_TYPE);
        generator.returnValue();
        mutableClass.addMethod(directCallConstructor);
    }

    @Override
    protected void writeCallToInitializing(MutableClass mutableClass, RobolectricGeneratorAdapter generator) {
        generator.invokeStatic(ROBOLECTRIC_INTERNALS_TYPE, INITIALIZING_METHOD);
    }

    @Override
    protected void generateClassHandlerCall(MutableClass mutableClass, MethodNode originalMethod, String originalMethodName, RobolectricGeneratorAdapter generator) {
        this.generateCallToClassHandler(mutableClass, originalMethod, originalMethodName, generator);
    }

    private void generateCallToClassHandler(MutableClass mutableClass, MethodNode originalMethod, String originalMethodName, RobolectricGeneratorAdapter generator) {
        this.decorator.decorateMethodPreClassHandler(mutableClass, originalMethod, originalMethodName, generator);
        int planLocalVar = generator.newLocal(PLAN_TYPE);
        int exceptionLocalVar = generator.newLocal(THROWABLE_TYPE);
        Label directCall = new Label();
        Label doReturn = new Label();
        String string = mutableClass.classType.getInternalName();
        String string2 = originalMethod.desc;
        generator.push(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(originalMethodName).length() + String.valueOf(string2).length()).append(string).append("/").append(originalMethodName).append(string2).toString());
        generator.push(generator.isStatic());
        generator.push(mutableClass.classType);
        generator.invokeStatic(ROBOLECTRIC_INTERNALS_TYPE, METHOD_INVOKED_METHOD);
        generator.storeLocal(planLocalVar);
        generator.loadLocal(planLocalVar);
        generator.ifNull(directCall);
        ClassInstrumentor.TryCatch tryCatchForHandler = generator.tryStart(THROWABLE_TYPE);
        generator.loadLocal(planLocalVar);
        generator.loadThisOrNull();
        generator.loadArgArray();
        generator.invokeInterface(PLAN_TYPE, PLAN_RUN_METHOD);
        Type returnType = generator.getReturnType();
        int sort = returnType.getSort();
        switch (sort) {
            case 0: {
                generator.pop();
                break;
            }
            case 9: 
            case 10: {
                generator.checkCast(returnType);
                break;
            }
            default: {
                int unboxLocalVar = generator.newLocal(OBJECT_TYPE);
                generator.storeLocal(unboxLocalVar);
                generator.loadLocal(unboxLocalVar);
                Label notNull = generator.newLabel();
                Label afterward = generator.newLabel();
                generator.ifNonNull(notNull);
                generator.pushDefaultReturnValueToStack(returnType);
                generator.goTo(afterward);
                generator.mark(notNull);
                generator.loadLocal(unboxLocalVar);
                generator.unbox(returnType);
                generator.mark(afterward);
            }
        }
        tryCatchForHandler.end();
        generator.goTo(doReturn);
        tryCatchForHandler.handler();
        generator.storeLocal(exceptionLocalVar);
        generator.loadLocal(exceptionLocalVar);
        generator.invokeStatic(ROBOLECTRIC_INTERNALS_TYPE, HANDLE_EXCEPTION_METHOD);
        generator.throwException();
        if (!originalMethod.name.equals("<init>")) {
            generator.mark(directCall);
            ClassInstrumentor.TryCatch tryCatchForDirect = generator.tryStart(THROWABLE_TYPE);
            generator.invokeMethod(mutableClass.classType.getInternalName(), originalMethod.name, originalMethod.desc);
            tryCatchForDirect.end();
            generator.returnValue();
            tryCatchForDirect.handler();
            generator.storeLocal(exceptionLocalVar);
            generator.loadLocal(exceptionLocalVar);
            generator.invokeStatic(ROBOLECTRIC_INTERNALS_TYPE, HANDLE_EXCEPTION_METHOD);
            generator.throwException();
        }
        generator.mark(doReturn);
        generator.returnValue();
    }

    @Override
    protected void interceptInvokeVirtualMethod(MutableClass mutableClass, ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
        this.interceptInvokeVirtualMethodWithoutInvokeDynamic(mutableClass, instructions, targetMethod);
    }

    private void interceptInvokeVirtualMethodWithoutInvokeDynamic(MutableClass mutableClass, ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
        Object type;
        boolean isStatic = targetMethod.getOpcode() == 184;
        instructions.remove();
        Type[] argumentTypes = Type.getArgumentTypes((String)targetMethod.desc);
        instructions.add((AbstractInsnNode)new LdcInsnNode((Object)argumentTypes.length));
        instructions.add((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
        for (int i = argumentTypes.length - 1; i >= 0; --i) {
            type = argumentTypes[i];
            int argWidth = type.getSize();
            if (argWidth == 1) {
                instructions.add((AbstractInsnNode)new InsnNode(90));
                instructions.add((AbstractInsnNode)new InsnNode(95));
                instructions.add((AbstractInsnNode)new LdcInsnNode((Object)i));
                instructions.add((AbstractInsnNode)new InsnNode(95));
                OldClassInstrumentor.box(type, instructions);
                instructions.add((AbstractInsnNode)new InsnNode(83));
                continue;
            }
            if (argWidth != 2) continue;
            instructions.add((AbstractInsnNode)new InsnNode(91));
            instructions.add((AbstractInsnNode)new InsnNode(91));
            instructions.add((AbstractInsnNode)new InsnNode(87));
            OldClassInstrumentor.box(type, instructions);
            instructions.add((AbstractInsnNode)new LdcInsnNode((Object)i));
            instructions.add((AbstractInsnNode)new InsnNode(95));
            instructions.add((AbstractInsnNode)new InsnNode(83));
        }
        if (isStatic) {
            instructions.add((AbstractInsnNode)new InsnNode(1));
            instructions.add((AbstractInsnNode)new InsnNode(95));
        }
        String i = targetMethod.owner;
        type = targetMethod.name;
        String string = targetMethod.desc;
        instructions.add((AbstractInsnNode)new LdcInsnNode((Object)new StringBuilder(1 + String.valueOf(i).length() + String.valueOf(type).length() + String.valueOf(string).length()).append(i).append("/").append((String)type).append(string).toString()));
        instructions.add((AbstractInsnNode)new InsnNode(91));
        instructions.add((AbstractInsnNode)new InsnNode(87));
        instructions.add((AbstractInsnNode)new LdcInsnNode((Object)mutableClass.classType));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, Type.getType(RobolectricInternals.class).getInternalName(), "intercept", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", false));
        Type returnType = Type.getReturnType((String)targetMethod.desc);
        switch (returnType.getSort()) {
            case 9: 
            case 10: {
                String remappedType = mutableClass.config.mappedTypeName(returnType.getInternalName());
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, remappedType));
                break;
            }
            case 0: {
                instructions.add((AbstractInsnNode)new InsnNode(87));
                break;
            }
            case 7: {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Long.class)));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Long.class), "longValue", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false));
                break;
            }
            case 6: {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Float.class)));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Float.class), "floatValue", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[0]), false));
                break;
            }
            case 8: {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Double.class)));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Double.class), "doubleValue", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[0]), false));
                break;
            }
            case 1: {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Boolean.class)));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]), false));
                break;
            }
            case 5: {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Integer.class)));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Integer.class), "intValue", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false));
                break;
            }
            case 4: {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Short.class)));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Short.class), "shortValue", Type.getMethodDescriptor((Type)Type.SHORT_TYPE, (Type[])new Type[0]), false));
                break;
            }
            case 3: {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Byte.class)));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Byte.class), "byteValue", Type.getMethodDescriptor((Type)Type.BYTE_TYPE, (Type[])new Type[0]), false));
                break;
            }
            default: {
                string = this.getClass().getName();
                String string2 = returnType.getClassName();
                throw new RuntimeException(new StringBuilder(60 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Not implemented: ").append(string).append(" cannot intercept methods with return type ").append(string2).toString());
            }
        }
    }

    static void box(Type type, ListIterator<AbstractInsnNode> instructions) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (Type.VOID_TYPE.equals((Object)type)) {
            instructions.add((AbstractInsnNode)new InsnNode(1));
        } else {
            Type boxed = OldClassInstrumentor.getBoxedType(type);
            instructions.add((AbstractInsnNode)new TypeInsnNode(187, boxed.getInternalName()));
            if (type.getSize() == 2) {
                instructions.add((AbstractInsnNode)new InsnNode(91));
                instructions.add((AbstractInsnNode)new InsnNode(91));
                instructions.add((AbstractInsnNode)new InsnNode(87));
            } else {
                instructions.add((AbstractInsnNode)new InsnNode(90));
                instructions.add((AbstractInsnNode)new InsnNode(95));
            }
            String string = type.getDescriptor();
            instructions.add((AbstractInsnNode)new MethodInsnNode(183, boxed.getInternalName(), "<init>", new StringBuilder(3 + String.valueOf(string).length()).append("(").append(string).append(")V").toString(), false));
        }
    }

    private static Type getBoxedType(Type type) {
        switch (type.getSort()) {
            case 3: {
                return Type.getObjectType((String)"java/lang/Byte");
            }
            case 1: {
                return Type.getObjectType((String)"java/lang/Boolean");
            }
            case 4: {
                return Type.getObjectType((String)"java/lang/Short");
            }
            case 2: {
                return Type.getObjectType((String)"java/lang/Character");
            }
            case 5: {
                return Type.getObjectType((String)"java/lang/Integer");
            }
            case 6: {
                return Type.getObjectType((String)"java/lang/Float");
            }
            case 7: {
                return Type.getObjectType((String)"java/lang/Long");
            }
            case 8: {
                return Type.getObjectType((String)"java/lang/Double");
            }
        }
        return type;
    }

    static {
        String string = PLAN_TYPE.getInternalName();
        METHOD_INVOKED_METHOD = new Method("methodInvoked", new StringBuilder(40 + String.valueOf(string).length()).append("(Ljava/lang/String;ZLjava/lang/Class;)L").append(string).append(";").toString());
        PLAN_RUN_METHOD = new Method("run", OBJECT_TYPE, new Type[]{OBJECT_TYPE, Type.getType(Object[].class)});
        HANDLE_EXCEPTION_METHOD = new Method("cleanStackTrace", THROWABLE_TYPE, new Type[]{THROWABLE_TYPE});
        DIRECT_OBJECT_MARKER_TYPE_DESC = Type.getObjectType((String)DirectObjectMarker.class.getName().replace('.', '/')).getDescriptor();
    }
}

