/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ListIterator;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.robolectric.internal.bytecode.ClassInstrumentor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.MutableClass;
import org.robolectric.internal.bytecode.RobolectricGeneratorAdapter;

public class InvokeDynamicClassInstrumentor
extends ClassInstrumentor {
    private static final Handle BOOTSTRAP_INIT;
    private static final Handle BOOTSTRAP;
    private static final Handle BOOTSTRAP_STATIC;
    private static final Handle BOOTSTRAP_INTRINSIC;

    public InvokeDynamicClassInstrumentor(ClassInstrumentor.Decorator decorator) {
        super(decorator);
    }

    @Override
    protected void addDirectCallConstructor(MutableClass mutableClass) {
    }

    @Override
    protected void writeCallToInitializing(MutableClass mutableClass, RobolectricGeneratorAdapter generator) {
        generator.invokeDynamic("initializing", Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{mutableClass.classType}), BOOTSTRAP_INIT, new Object[0]);
    }

    @Override
    protected void generateClassHandlerCall(MutableClass mutableClass, MethodNode originalMethod, String originalMethodName, RobolectricGeneratorAdapter generator) {
        this.generateInvokeDynamic(mutableClass, originalMethod, originalMethodName, generator);
    }

    private void generateInvokeDynamic(MutableClass mutableClass, MethodNode originalMethod, String originalMethodName, RobolectricGeneratorAdapter generator) {
        Handle original = new Handle(this.getTag(originalMethod), mutableClass.classType.getInternalName(), originalMethod.name, originalMethod.desc);
        if (generator.isStatic()) {
            generator.loadArgs();
            generator.invokeDynamic(originalMethodName, originalMethod.desc, BOOTSTRAP_STATIC, new Object[]{original});
        } else {
            String string = mutableClass.classType.getDescriptor();
            String string2 = originalMethod.desc.substring(1);
            String desc = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append("(").append(string).append(string2).toString();
            generator.loadThis();
            generator.loadArgs();
            generator.invokeDynamic(originalMethodName, desc, BOOTSTRAP, new Object[]{original});
        }
        generator.returnValue();
    }

    @Override
    protected void interceptInvokeVirtualMethod(MutableClass mutableClass, ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
        this.interceptInvokeVirtualMethodWithInvokeDynamic(instructions, targetMethod);
    }

    private void interceptInvokeVirtualMethodWithInvokeDynamic(ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
        instructions.remove();
        Type type = Type.getObjectType((String)targetMethod.owner);
        String description = targetMethod.desc;
        String owner = type.getClassName();
        if (targetMethod.getOpcode() != 184) {
            String thisType = type.getDescriptor();
            String string = description.substring(1);
            description = new StringBuilder(1 + String.valueOf(thisType).length() + String.valueOf(string).length()).append("(").append(thisType).append(string).toString();
        }
        instructions.add((AbstractInsnNode)new InvokeDynamicInsnNode(targetMethod.name, description, BOOTSTRAP_INTRINSIC, new Object[]{owner}));
    }

    static {
        String className = Type.getInternalName(InvokeDynamicSupport.class);
        MethodType bootstrap = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
        String bootstrapMethod = bootstrap.appendParameterTypes(MethodHandle.class).toMethodDescriptorString();
        String bootstrapIntrinsic = bootstrap.appendParameterTypes(String.class).toMethodDescriptorString();
        BOOTSTRAP_INIT = new Handle(6, className, "bootstrapInit", bootstrap.toMethodDescriptorString());
        BOOTSTRAP = new Handle(6, className, "bootstrap", bootstrapMethod);
        BOOTSTRAP_STATIC = new Handle(6, className, "bootstrapStatic", bootstrapMethod);
        BOOTSTRAP_INTRINSIC = new Handle(6, className, "bootstrapIntrinsic", bootstrapIntrinsic);
    }
}

