/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassDetails {
    private final ClassReader classReader;
    private final String className;
    private Set<String> annotations;

    public ClassDetails(byte[] classBytes) {
        this.classReader = new ClassReader(classBytes);
        this.className = this.classReader.getClassName().replace('/', '.');
    }

    public boolean isInterface() {
        return (this.classReader.getAccess() & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.classReader.getAccess() & 0x2000) != 0;
    }

    public String getName() {
        return this.className;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        if (this.annotations == null) {
            this.annotations = new HashSet<String>();
            this.classReader.accept((ClassVisitor)new AnnotationVisitor(this.annotations), 7);
        }
        String string = annotationClass.getName().replace('.', '/');
        String internalName = new StringBuilder(2 + String.valueOf(string).length()).append("L").append(string).append(";").toString();
        return this.annotations.contains(internalName);
    }

    private static class AnnotationVisitor
    extends ClassVisitor {
        private final Set<String> annotations;

        public AnnotationVisitor(Set<String> annotations) {
            super(589824);
            this.annotations = annotations;
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (visible) {
                this.annotations.add(descriptor);
            }
            return null;
        }
    }
}

