/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.robolectric.internal.bytecode.ClassNodeProvider;

public class InstrumentingClassWriter
extends ClassWriter {
    private final ClassNodeProvider classNodeProvider;

    public InstrumentingClassWriter(ClassNodeProvider classNodeProvider, ClassNode classNode) {
        super(classNode.version >= 51 ? 2 : 1);
        this.classNodeProvider = classNodeProvider;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        try {
            String result;
            block8: {
                ClassNode info1 = this.typeInfo(type1);
                ClassNode info2 = this.typeInfo(type2);
                if ((info1.access & 0x200) != 0) {
                    if (this.typeImplements(type2, info2, type1)) {
                        return type1;
                    }
                    if ((info2.access & 0x200) != 0 && this.typeImplements(type1, info1, type2)) {
                        return type2;
                    }
                    return "java/lang/Object";
                }
                if ((info2.access & 0x200) != 0) {
                    if (this.typeImplements(type1, info1, type2)) {
                        return type2;
                    }
                    return "java/lang/Object";
                }
                String b1 = this.typeAncestors(type1, info1);
                String b2 = this.typeAncestors(type2, info2);
                result = "java/lang/Object";
                int end1 = b1.length();
                int end2 = b2.length();
                while (true) {
                    String p2;
                    int start1 = b1.lastIndexOf(59, end1 - 1);
                    int start2 = b2.lastIndexOf(59, end2 - 1);
                    if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block8;
                    String p1 = b1.substring(start1 + 1, end1);
                    if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                    result = p1;
                    end1 = start1;
                    end2 = start2;
                }
                return result;
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            return "java/lang/Object";
        }
    }

    private String typeAncestors(String type, ClassNode info) throws ClassNotFoundException {
        StringBuilder b = new StringBuilder();
        while (!"java/lang/Object".equals(type)) {
            b.append(';').append(type);
            type = info.superName;
            info = this.typeInfo(type);
        }
        return b.toString();
    }

    private boolean typeImplements(String type, ClassNode info, String itf) throws ClassNotFoundException {
        while (!"java/lang/Object".equals(type)) {
            List itfs = info.interfaces;
            for (String itf2 : itfs) {
                if (!itf2.equals(itf)) continue;
                return true;
            }
            for (String itf1 : itfs) {
                if (!this.typeImplements(itf1, this.typeInfo(itf1), itf)) continue;
                return true;
            }
            type = info.superName;
            info = this.typeInfo(type);
        }
        return false;
    }

    private ClassNode typeInfo(String type) throws ClassNotFoundException {
        return this.classNodeProvider.getClassNode(type);
    }
}

