/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.ClassInstrumentor;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.Interceptors;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ResourceProvider;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.SandboxClassLoader;
import org.robolectric.internal.bytecode.ShadowImpl;
import org.robolectric.internal.bytecode.ShadowInvalidator;
import org.robolectric.internal.bytecode.ShadowMap;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Util;

public class Sandbox {
    private final SandboxClassLoader sandboxClassLoader;
    private final ExecutorService executorService;
    private ShadowInvalidator shadowInvalidator;
    private ShadowMap shadowMap = ShadowMap.EMPTY;

    public Sandbox(InstrumentationConfiguration config, ResourceProvider resourceProvider, ClassInstrumentor classInstrumentor) {
        this(new SandboxClassLoader(config, resourceProvider, classInstrumentor));
    }

    @Inject
    public Sandbox(SandboxClassLoader sandboxClassLoader) {
        this.sandboxClassLoader = sandboxClassLoader;
        this.executorService = Executors.newSingleThreadExecutor(this.mainThreadFactory());
    }

    protected ThreadFactory mainThreadFactory() {
        return Thread::new;
    }

    public <T> Class<T> bootstrappedClass(Class<?> clazz) {
        try {
            return this.sandboxClassLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getRobolectricClassLoader() {
        return this.sandboxClassLoader;
    }

    private ShadowInvalidator getShadowInvalidator() {
        if (this.shadowInvalidator == null) {
            this.shadowInvalidator = new ShadowInvalidator();
        }
        return this.shadowInvalidator;
    }

    public void replaceShadowMap(ShadowMap shadowMap) {
        ShadowMap oldShadowMap = this.shadowMap;
        this.shadowMap = shadowMap;
        HashSet<String> invalidatedClasses = new HashSet<String>();
        invalidatedClasses.addAll(shadowMap.getInvalidatedClasses(oldShadowMap));
        invalidatedClasses.addAll(this.getModeInvalidatedClasses());
        this.getShadowInvalidator().invalidateClasses(invalidatedClasses);
        this.clearModeInvalidatedClasses();
    }

    protected Set<String> getModeInvalidatedClasses() {
        return Collections.emptySet();
    }

    protected void clearModeInvalidatedClasses() {
    }

    public void configure(ClassHandler classHandler, Interceptors interceptors) {
        ClassLoader robolectricClassLoader = this.getRobolectricClassLoader();
        Class robolectricInternalsClass = this.bootstrappedClass(RobolectricInternals.class);
        ShadowInvalidator invalidator = this.getShadowInvalidator();
        ReflectionHelpers.setStaticField(robolectricInternalsClass, (String)"shadowInvalidator", (Object)invalidator);
        ReflectionHelpers.setStaticField(robolectricInternalsClass, (String)"classHandler", (Object)classHandler);
        ReflectionHelpers.setStaticField(robolectricInternalsClass, (String)"classLoader", (Object)robolectricClassLoader);
        Class invokeDynamicSupportClass = this.bootstrappedClass(InvokeDynamicSupport.class);
        ReflectionHelpers.setStaticField(invokeDynamicSupportClass, (String)"INTERCEPTORS", (Object)interceptors);
        Class shadowClass = this.bootstrappedClass(Shadow.class);
        ReflectionHelpers.setStaticField(shadowClass, (String)"SHADOW_IMPL", (Object)ReflectionHelpers.newInstance(this.bootstrappedClass(ShadowImpl.class)));
    }

    public void runOnMainThread(Runnable runnable) {
        this.runOnMainThread(() -> {
            runnable.run();
            return null;
        });
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        try {
            this.sandboxClassLoader.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <T> T runOnMainThread(Callable<T> callable) {
        Future<T> future = this.executorService.submit(callable);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw Util.sneakyThrow((Throwable)e.getCause());
        }
    }
}

