/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.ClassValueMap;
import org.robolectric.internal.bytecode.Interceptors;
import org.robolectric.internal.bytecode.InvocationProfile;
import org.robolectric.internal.bytecode.MethodSignature;
import org.robolectric.internal.bytecode.RoboType;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowInfo;
import org.robolectric.internal.bytecode.ShadowMap;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.robolectric.util.Function;
import org.robolectric.util.Logger;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.ReflectionHelpers;

public class ShadowWrangler
implements ClassHandler {
    public static final Function<Object, Object> DO_NOTHING_HANDLER = new Function<Object, Object>(){

        @Override
        public Object call(Class<?> theClass, Object value, Object[] params) {
            return null;
        }
    };
    public static final ClassHandler.Plan DO_NOTHING_PLAN = new ClassHandler.Plan(){

        @Override
        public Object run(Object instance, Object[] params) throws Exception {
            return null;
        }

        @Override
        public String describe() {
            return "do nothing";
        }
    };
    public static final ClassHandler.Plan CALL_REAL_CODE_PLAN = null;
    public static final Method CALL_REAL_CODE = null;
    public static final MethodHandle DO_NOTHING = MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE));
    public static final Method DO_NOTHING_METHOD;
    public static final Implementation IMPLEMENTATION_DEFAULTS;
    private static final MethodHandles.Lookup LOOKUP;
    private static final boolean STRIP_SHADOW_STACK_TRACES = true;
    private static final Class<?>[] NO_ARGS;
    static final Object NO_SHADOW;
    private static final MethodHandle NO_SHADOW_HANDLE;
    private final ShadowMap shadowMap;
    private final Interceptors interceptors;
    private final int apiLevel;
    private final Map<String, ClassHandler.Plan> planCache = Collections.synchronizedMap(new LinkedHashMap<String, ClassHandler.Plan>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ClassHandler.Plan> eldest) {
            return this.size() > 500;
        }
    });
    private final ClassValueMap<ShadowInfo> cachedShadowInfos = new ClassValueMap<ShadowInfo>(){

        @Override
        protected ShadowInfo computeValue(Class<?> type) {
            return ShadowWrangler.this.shadowMap.getShadowInfo(type, ShadowWrangler.this.apiLevel);
        }
    };
    private final ClassValueMap<ShadowMetadata> cachedShadowMetadata = new ClassValueMap<ShadowMetadata>(){

        @Override
        @Nonnull
        protected ShadowMetadata computeValue(Class<?> type) {
            return new ShadowMetadata(type);
        }
    };

    public ShadowWrangler(ShadowMap shadowMap, int apiLevel, Interceptors interceptors) {
        this.shadowMap = shadowMap;
        this.apiLevel = apiLevel;
        this.interceptors = interceptors;
    }

    public static Class<?> loadClass(String paramType, ClassLoader classLoader) {
        Class primitiveClass = RoboType.findPrimitiveClass(paramType);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        int arrayLevel = 0;
        while (paramType.endsWith("[]")) {
            ++arrayLevel;
            paramType = paramType.substring(0, paramType.length() - 2);
        }
        Class<?> clazz = RoboType.findPrimitiveClass(paramType);
        if (clazz == null) {
            try {
                clazz = classLoader.loadClass(paramType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        while (arrayLevel-- > 0) {
            clazz = Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }

    @Override
    public void classInitializing(Class clazz) {
        try {
            Method method = this.pickShadowMethod(clazz, "__staticInitializer__", NO_ARGS);
            if (method == DO_NOTHING_METHOD) {
                method = null;
            }
            if (method != null) {
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException(method.getDeclaringClass().getName() + "." + method.getName() + " is not static");
                }
                method.invoke(null, new Object[0]);
            } else {
                RobolectricInternals.performStaticInitialization(clazz);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object initializing(Object instance) {
        return this.createShadowFor(instance);
    }

    @Override
    public ClassHandler.Plan methodInvoked(String signature, boolean isStatic, Class<?> theClass) {
        ClassHandler.Plan plan;
        if (this.planCache.containsKey(signature)) {
            plan = this.planCache.get(signature);
        } else {
            plan = this.calculatePlan(signature, isStatic, theClass);
            this.planCache.put(signature, plan);
        }
        return plan;
    }

    private ClassHandler.Plan calculatePlan(String signature, boolean isStatic, Class<?> definingClass) {
        return (ClassHandler.Plan)PerfStatsCollector.getInstance().measure("find shadow method", () -> {
            ClassLoader classLoader = definingClass.getClassLoader();
            InvocationProfile invocationProfile = new InvocationProfile(signature, isStatic, classLoader);
            try {
                Class<?>[] types = invocationProfile.getParamClasses(classLoader);
                Method shadowMethod = this.pickShadowMethod(definingClass, invocationProfile.methodName, types);
                if (shadowMethod == CALL_REAL_CODE) {
                    return CALL_REAL_CODE_PLAN;
                }
                if (shadowMethod == DO_NOTHING_METHOD) {
                    return DO_NOTHING_PLAN;
                }
                return new ShadowMethodPlan(shadowMethod);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public MethodHandle findShadowMethodHandle(Class<?> definingClass, String name, MethodType methodType, boolean isStatic) throws IllegalAccessException {
        return (MethodHandle)PerfStatsCollector.getInstance().measure("find shadow method handle", () -> {
            MethodType actualType = isStatic ? methodType : methodType.dropParameterTypes(0, 1);
            Class<?>[] paramTypes = actualType.parameterArray();
            Method shadowMethod = this.pickShadowMethod(definingClass, name, paramTypes);
            if (shadowMethod == CALL_REAL_CODE) {
                return null;
            }
            if (shadowMethod == DO_NOTHING_METHOD) {
                return DO_NOTHING;
            }
            MethodHandle mh = LOOKUP.unreflect(shadowMethod);
            if (!isStatic && Modifier.isStatic(shadowMethod.getModifiers())) {
                return MethodHandles.dropArguments(mh, 0, new Class[]{Object.class});
            }
            return mh;
        });
    }

    private Method pickShadowMethod(Class<?> definingClass, String name, Class<?>[] paramTypes) {
        Class<?> shadowClass;
        ShadowInfo shadowInfo = this.getExactShadowInfo(definingClass);
        if (shadowInfo == null) {
            return CALL_REAL_CODE;
        }
        ClassLoader classLoader = definingClass.getClassLoader();
        try {
            shadowClass = Class.forName(shadowInfo.shadowClassName, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        Method method = this.findShadowMethod(definingClass, name, paramTypes, shadowInfo, shadowClass, shadowInfo.inheritImplementationMethods);
        if (method == null) {
            return shadowInfo.callThroughByDefault ? CALL_REAL_CODE : DO_NOTHING_METHOD;
        }
        return method;
    }

    private Method findShadowMethod(Class<?> definingClass, String name, Class<?>[] types, ShadowInfo shadowInfo, Class<?> shadowClass, boolean inheritImplementationMethods) {
        Method method = this.findShadowMethodDeclaredOnClass(shadowClass, name, types);
        if (method == null && shadowInfo.looseSignatures) {
            Class<?>[] genericTypes = MethodType.genericMethodType(types.length).parameterArray();
            method = this.findShadowMethodDeclaredOnClass(shadowClass, name, genericTypes);
        }
        if (method != null) {
            return method;
        }
        Class<?> shadowSuperclass = shadowClass.getSuperclass();
        if (shadowSuperclass != null && !shadowSuperclass.equals(Object.class)) {
            ShadowInfo shadowSuperclassInfo = ShadowMap.obtainShadowInfo(shadowSuperclass, true);
            if (inheritImplementationMethods || shadowSuperclassInfo != null && shadowSuperclassInfo.isShadowOf(definingClass) && shadowSuperclassInfo.supportsSdk(this.apiLevel)) {
                if (inheritImplementationMethods && shadowSuperclassInfo == null) {
                    shadowSuperclassInfo = shadowInfo;
                }
                method = this.findShadowMethod(definingClass, name, types, shadowSuperclassInfo, shadowSuperclass, inheritImplementationMethods);
            }
        }
        return method;
    }

    private Method findShadowMethodDeclaredOnClass(Class<?> shadowClass, String methodName, Class<?>[] paramClasses) {
        try {
            Method method = shadowClass.getDeclaredMethod(methodName, paramClasses);
            if (this.isValidShadowMethod(method)) {
                method.setAccessible(true);
                return method;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private boolean isValidShadowMethod(Method method) {
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) {
            return false;
        }
        Implementation implementation = ShadowWrangler.getImplementationAnnotation(method);
        return this.matchesSdk(implementation);
    }

    private boolean matchesSdk(Implementation implementation) {
        return implementation.minSdk() <= this.apiLevel && (implementation.maxSdk() == -1 || implementation.maxSdk() >= this.apiLevel);
    }

    private static Implementation getImplementationAnnotation(Method method) {
        if (method == null) {
            return null;
        }
        Implementation implementation = method.getAnnotation(Implementation.class);
        if (implementation == null) {
            Logger.warn((String)("No @Implementation annotation on " + method), (Object[])new Object[0]);
        }
        return implementation == null ? IMPLEMENTATION_DEFAULTS : implementation;
    }

    public Object intercept(String signature, Object instance, Object[] params, Class theClass) throws Throwable {
        MethodSignature methodSignature = MethodSignature.parse(signature);
        return this.interceptors.getInterceptionHandler(methodSignature).call(theClass, instance, params);
    }

    @Override
    public <T extends Throwable> T stripStackTrace(T throwable) {
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
        String previousClassName = null;
        String previousMethodName = null;
        String previousFileName = null;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            String methodName = stackTraceElement.getMethodName();
            String className = stackTraceElement.getClassName();
            String fileName = stackTraceElement.getFileName();
            if (methodName.equals(previousMethodName) && className.equals(previousClassName) && fileName != null && fileName.equals(previousFileName) && stackTraceElement.getLineNumber() < 0 || className.equals(ShadowMethodPlan.class.getName())) continue;
            if (methodName.startsWith("$$robo$$")) {
                methodName = methodName.substring("$$robo$$".length());
                stackTraceElement = new StackTraceElement(className, methodName, stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
            }
            if (className.startsWith("sun.reflect.") || className.startsWith("java.lang.reflect.")) continue;
            stackTrace.add(stackTraceElement);
            previousClassName = className;
            previousMethodName = methodName;
            previousFileName = fileName;
        }
        throwable.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        return throwable;
    }

    Object createShadowFor(Object instance) {
        Class<?> theClass = instance.getClass();
        Object shadow = this.createShadowFor(theClass);
        this.injectRealObjectOn(shadow, instance);
        return shadow;
    }

    private Object createShadowFor(Class<?> theClass) {
        ShadowInfo shadowInfo = this.getShadowInfo(theClass);
        if (shadowInfo == null) {
            return NO_SHADOW;
        }
        try {
            Class<?> shadowClass = ShadowWrangler.loadClass(shadowInfo.shadowClassName, theClass.getClassLoader());
            ShadowMetadata shadowMetadata = this.getShadowMetadata(shadowClass);
            return shadowMetadata.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Could not instantiate shadow " + shadowInfo.shadowClassName + " for " + theClass, e);
        }
    }

    private ShadowMetadata getShadowMetadata(Class<?> shadowClass) {
        return this.cachedShadowMetadata.get(shadowClass);
    }

    @Override
    public MethodHandle getShadowCreator(Class<?> theClass) {
        ShadowInfo shadowInfo = this.getShadowInfo(theClass);
        if (shadowInfo == null) {
            return MethodHandles.dropArguments(NO_SHADOW_HANDLE, 0, new Class[]{theClass});
        }
        String shadowClassName = shadowInfo.shadowClassName;
        try {
            Class<?> shadowClass = Class.forName(shadowClassName, false, theClass.getClassLoader());
            ShadowMetadata shadowMetadata = this.getShadowMetadata(shadowClass);
            MethodHandle mh = MethodHandles.identity(shadowClass);
            mh = MethodHandles.dropArguments(mh, 1, new Class[]{theClass});
            for (Field field : shadowMetadata.realObjectFields) {
                MethodHandle setter = LOOKUP.unreflectSetter(field);
                MethodType setterType = mh.type().changeReturnType(Void.TYPE);
                mh = MethodHandles.foldArguments(mh, setter.asType(setterType));
            }
            mh = MethodHandles.foldArguments(mh, LOOKUP.unreflectConstructor(shadowMetadata.constructor));
            return mh;
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException("Could not instantiate shadow " + shadowClassName + " for " + theClass, e);
        }
    }

    private void injectRealObjectOn(Object shadow, Object instance) {
        ShadowMetadata shadowMetadata = this.getShadowMetadata(shadow.getClass());
        for (Field realObjectField : shadowMetadata.realObjectFields) {
            ShadowWrangler.setField(shadow, instance, realObjectField);
        }
    }

    private ShadowInfo getShadowInfo(Class<?> clazz) {
        ShadowInfo shadowInfo = null;
        while (shadowInfo == null && clazz != null) {
            shadowInfo = this.getExactShadowInfo(clazz);
            clazz = clazz.getSuperclass();
        }
        return shadowInfo;
    }

    private ShadowInfo getExactShadowInfo(Class<?> clazz) {
        return this.cachedShadowInfos.get(clazz);
    }

    private static void setField(Object target, Object value, Field realObjectField) {
        try {
            realObjectField.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void doNothing() {
    }

    static {
        try {
            DO_NOTHING_METHOD = ShadowWrangler.class.getDeclaredMethod("doNothing", new Class[0]);
            DO_NOTHING_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        IMPLEMENTATION_DEFAULTS = (Implementation)ReflectionHelpers.defaultsFor(Implementation.class);
        LOOKUP = MethodHandles.lookup();
        NO_ARGS = new Class[0];
        NO_SHADOW = new Object();
        NO_SHADOW_HANDLE = MethodHandles.constant(Object.class, NO_SHADOW);
    }

    private static class ShadowMetadata {
        final Constructor<?> constructor;
        final List<Field> realObjectFields = new ArrayList<Field>();

        public ShadowMetadata(Class<?> shadowClass) {
            try {
                this.constructor = shadowClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Missing public empty constructor on " + shadowClass, e);
            }
            while (shadowClass != null) {
                for (Field field : shadowClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(RealObject.class)) continue;
                    if (Modifier.isStatic(field.getModifiers())) {
                        String message = "@RealObject must be on a non-static field, " + shadowClass;
                        System.err.println(message);
                        throw new IllegalArgumentException(message);
                    }
                    field.setAccessible(true);
                    this.realObjectFields.add(field);
                }
                shadowClass = shadowClass.getSuperclass();
            }
        }
    }

    private static class ShadowMethodPlan
    implements ClassHandler.Plan {
        private final Method shadowMethod;

        public ShadowMethodPlan(Method shadowMethod) {
            this.shadowMethod = shadowMethod;
        }

        @Override
        public Object run(Object instance, Object[] params) throws Throwable {
            ShadowedObject shadowedObject = (ShadowedObject)instance;
            Object shadow = shadowedObject == null ? null : shadowedObject.$$robo$getData();
            try {
                return this.shadowMethod.invoke(shadow, params);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("attempted to invoke " + this.shadowMethod + (shadow == null ? "" : " on instance of " + shadow.getClass() + ", but " + shadow.getClass().getSimpleName() + " doesn't extend " + this.shadowMethod.getDeclaringClass().getSimpleName()));
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        @Override
        public String describe() {
            return this.shadowMethod.toString();
        }
    }
}

