/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.robolectric.internal.bytecode.ClassValueMap;
import sun.misc.Unsafe;

public class ProxyMaker {
    private static final String TARGET_FIELD = "__proxy__";
    private static final Unsafe UNSAFE;
    private final MethodMapper methodMapper;
    private final ClassValueMap<Factory> factories;

    public ProxyMaker(MethodMapper methodMapper) {
        this.methodMapper = methodMapper;
        this.factories = new ClassValueMap<Factory>(){

            @Override
            protected Factory computeValue(Class<?> type) {
                return ProxyMaker.this.createProxyFactory(type);
            }
        };
    }

    public <T> T createProxy(Class<T> targetClass, T target) {
        return this.factories.get(targetClass).createProxy(targetClass, target);
    }

    <T> Factory createProxyFactory(Class<T> targetClass) {
        Type targetType = Type.getType(targetClass);
        String targetName = targetType.getInternalName();
        String proxyName = targetName + "$GeneratedProxy";
        Type proxyType = Type.getType((String)proxyName);
        ClassWriter writer = new ClassWriter(3);
        writer.visit(51, 49, proxyName, null, targetName, null);
        writer.visitField(1, TARGET_FIELD, targetType.getDescriptor(), null, null);
        for (java.lang.reflect.Method method : targetClass.getMethods()) {
            if (!ProxyMaker.shouldProxy(method)) continue;
            Method proxyMethod = Method.getMethod((java.lang.reflect.Method)method);
            GeneratorAdapter m = new GeneratorAdapter(1, Method.getMethod((java.lang.reflect.Method)method), null, null, (ClassVisitor)writer);
            m.loadThis();
            m.getField(proxyType, TARGET_FIELD, targetType);
            m.loadArgs();
            String targetMethod = this.methodMapper.getName(targetClass.getName(), method.getName());
            m.visitMethodInsn(182, targetName, targetMethod, proxyMethod.getDescriptor(), false);
            m.returnValue();
            m.endMethod();
        }
        writer.visitEnd();
        final Class proxyClass = UNSAFE.defineAnonymousClass(targetClass, writer.toByteArray(), null);
        try {
            final Field field = proxyClass.getDeclaredField(TARGET_FIELD);
            return new Factory(){

                public <E> E createProxy(Class<E> targetClass, E target) {
                    try {
                        Object proxy = UNSAFE.allocateInstance(proxyClass);
                        field.set(proxy, target);
                        return targetClass.cast(proxy);
                    }
                    catch (Throwable t) {
                        throw new AssertionError((Object)t);
                    }
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean shouldProxy(java.lang.reflect.Method method) {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isPrivate(modifiers) && !Modifier.isNative(modifiers);
    }

    static {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = (Unsafe)unsafeField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static interface Factory {
        public <T> T createProxy(Class<T> var1, T var2);
    }

    static interface MethodMapper {
        public String getName(String var1, String var2);
    }
}

