/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import java.util.Map;

public enum DataType {
    NULL(0),
    REFERENCE(1),
    ATTRIBUTE(2),
    STRING(3),
    FLOAT(4),
    DIMENSION(5),
    FRACTION(6),
    DYNAMIC_REFERENCE(7),
    DYNAMIC_ATTRIBUTE(8),
    INT_DEC(16),
    INT_HEX(17),
    INT_BOOLEAN(18),
    INT_COLOR_ARGB8(28),
    INT_COLOR_RGB8(29),
    INT_COLOR_ARGB4(30),
    INT_COLOR_RGB4(31);

    public static final int TYPE_FIRST_INT;
    public static final int TYPE_LAST_INT;
    private final byte code;
    private static final Map<Byte, DataType> FROM_BYTE;

    private DataType(int code) {
        this.code = UnsignedBytes.checkedCast((long)code);
    }

    public byte code() {
        return this.code;
    }

    public static DataType fromCode(int code) {
        return DataType.fromCode((byte)code);
    }

    public static DataType fromCode(byte code) {
        return (DataType)((Object)Preconditions.checkNotNull((Object)((Object)FROM_BYTE.get(code)), (String)"Unknown resource type: %s", (int)code));
    }

    static {
        TYPE_FIRST_INT = INT_DEC.code();
        TYPE_LAST_INT = INT_COLOR_RGB4.code();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DataType type : DataType.values()) {
            builder.put((Object)type.code(), (Object)type);
        }
        FROM_BYTE = builder.build();
    }
}

