/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.Util;

public class FileMap {
    private ZipFile zipFile;
    private ZipEntry zipEntry;
    private boolean readOnly;
    private int fd;
    private boolean isFromZip;
    String mFileName;
    int mBasePtr;
    int mBaseLength;
    long mDataOffset;
    byte[] mDataPtr;
    int mDataLength;
    static long mPageSize;

    boolean create(String origFileName, int fd, long offset, int length, boolean readOnly) {
        this.mFileName = origFileName;
        this.fd = fd;
        this.mDataOffset = offset;
        this.readOnly = readOnly;
        return true;
    }

    public boolean createFromZip(String origFileName, ZipFile zipFile, ZipEntry entry, int length, boolean readOnly) {
        this.isFromZip = true;
        this.zipFile = zipFile;
        this.zipEntry = entry;
        long offset = this.guessOffsetFor(zipFile, entry);
        assert (this.fd >= 0);
        assert (offset >= 0L);
        this.mFileName = origFileName != null ? origFileName : null;
        this.mDataOffset = offset;
        this.mDataLength = Asset.toIntExact(entry.getSize());
        Util.ALOGV("MAP: base %s/0x%x data %s/0x%x\n", this.mBasePtr, this.mBaseLength, this.mDataPtr, this.mDataLength);
        return true;
    }

    long guessOffsetFor(ZipFile zipFile, ZipEntry zipEntry) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        long offset = 0L;
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            long fileSize = 0L;
            long extra = entry.getExtra() == null ? 0L : (long)entry.getExtra().length;
            offset += (long)(30 + entry.getName().length()) + extra;
            if (entry.getName().equals(zipEntry.getName())) {
                return offset;
            }
            if (!entry.isDirectory()) {
                fileSize = entry.getCompressedSize();
            }
            offset += fileSize;
        }
        throw new IllegalStateException("'" + zipEntry.getName() + "' not found");
    }

    String getFileName() {
        return this.mFileName;
    }

    synchronized byte[] getDataPtr() {
        if (this.mDataPtr == null) {
            this.mDataPtr = new byte[this.mDataLength];
            try (InputStream is = this.isFromZip ? this.zipFile.getInputStream(this.zipEntry) : new FileInputStream(this.getFileName());){
                FileMap.readFully(is, this.mDataPtr);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mDataPtr;
    }

    public static void readFully(InputStream is, byte[] bytes) throws IOException {
        int size;
        int location;
        int remaining;
        int bytesRead;
        for (remaining = size = bytes.length; remaining > 0 && (bytesRead = is.read(bytes, location = size - remaining, remaining)) != -1; remaining -= bytesRead) {
        }
        if (remaining > 0) {
            throw new RuntimeException("failed to read " + size + " (" + remaining + " bytes unread)");
        }
    }

    int getDataLength() {
        return this.mDataLength;
    }

    long getDataOffset() {
        return this.mDataOffset;
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    public String toString() {
        if (this.isFromZip) {
            return "FileMap{zipFile=" + this.zipFile.getName() + ", zipEntry=" + this.zipEntry + '}';
        }
        return "FileMap{mFileName='" + this.mFileName + '\'' + '}';
    }
}

