/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.robolectric.res.FileTypedResource;
import org.robolectric.res.Fs;
import org.robolectric.res.android.FileMap;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.String8;
import org.robolectric.res.android.Util;

public abstract class Asset {
    public static final Asset EXCLUDED_ASSET = new _FileAsset();
    public Runnable onClose;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    AccessMode mAccessMode = AccessMode.ACCESS_UNKNOWN;
    String8 mAssetSource;
    Asset mNext;
    Asset mPrev;
    static final boolean kIsDebug = false;
    static final Object gAssetLock = new Object();
    static int gCount = 0;
    static Asset gHead = null;
    static Asset gTail = null;

    public static Asset newFileAsset(FileTypedResource fileTypedResource) throws IOException {
        _FileAsset fileAsset = new _FileAsset();
        Path path = fileTypedResource.getPath();
        fileAsset.mFileName = Fs.externalize(path);
        fileAsset.mLength = Files.size(path);
        fileAsset.mBuf = Fs.getBytes(path);
        return fileAsset;
    }

    public final int read(byte[] buf, int count) {
        return this.read(buf, 0, count);
    }

    public abstract int read(byte[] var1, int var2, int var3);

    public abstract long seek(long var1, int var3);

    public abstract void close();

    public abstract byte[] getBuffer(boolean var1);

    public abstract long getLength();

    public abstract long getRemainingLength();

    public abstract FileDescriptor openFileDescriptor(Ref<Long> var1, Ref<Long> var2);

    public abstract File getFile();

    public abstract String getFileName();

    abstract boolean isAllocated();

    final String getAssetSource() {
        return this.mAssetSource.string();
    }

    public abstract boolean isNinePatch();

    void setAssetSource(String8 path) {
        this.mAssetSource = path;
    }

    AccessMode getAccessMode() {
        return this.mAccessMode;
    }

    void registerAsset(Asset asset) {
    }

    void unregisterAsset(Asset asset) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getGlobalCount() {
        Object object = gAssetLock;
        synchronized (object) {
            return gCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAssetAllocations() {
        Object object = gAssetLock;
        synchronized (object) {
            StringBuilder res = new StringBuilder();
            Asset cur = gHead;
            while (cur != null) {
                if (cur.isAllocated()) {
                    res.append("    ");
                    res.append(cur.getAssetSource());
                    long size = (cur.getLength() + 512L) / 1024L;
                    String buf = String.format(Locale.getDefault(), ": %dK\n", (int)size);
                    res.append(buf);
                }
                cur = cur.mNext;
            }
            return res.toString();
        }
    }

    Asset() {
    }

    static Asset createFromFile(String fileName, AccessMode mode) {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    static Asset createFromCompressedFile(String fileName, AccessMode mode) {
        throw new UnsupportedOperationException();
    }

    static Asset createFromUncompressedMap(FileMap dataMap, AccessMode mode) {
        _FileAsset pAsset = new _FileAsset();
        int result = pAsset.openChunk(dataMap);
        if (result != 0) {
            return null;
        }
        pAsset.mAccessMode = mode;
        return pAsset;
    }

    static Asset createFromCompressedMap(FileMap dataMap, int uncompressedLen, AccessMode mode) {
        _CompressedAsset pAsset = new _CompressedAsset();
        int result = pAsset.openChunk(dataMap, uncompressedLen);
        if (result != 0) {
            return null;
        }
        pAsset.mAccessMode = mode;
        return pAsset;
    }

    long handleSeek(long offset, int whence, long curPosn, long maxPosn) {
        long newOffset;
        switch (whence) {
            case 0: {
                newOffset = offset;
                break;
            }
            case 1: {
                newOffset = curPosn + offset;
                break;
            }
            case 2: {
                newOffset = maxPosn + offset;
                break;
            }
            default: {
                Util.ALOGW("unexpected whence %d\n", whence);
                assert (false);
                return -1L;
            }
        }
        if (newOffset < 0L || newOffset > maxPosn) {
            Util.ALOGW("seek out of range: want %d, end=%d\n", newOffset, maxPosn);
            return -1L;
        }
        return newOffset;
    }

    static class _FileAsset
    extends Asset {
        long mStart;
        long mLength;
        long mOffset;
        RandomAccessFile mFp;
        String mFileName;
        public static int kReadVsMapThreshold = 4096;
        FileMap mMap;
        byte[] mBuf;

        @Override
        public long getLength() {
            return this.mLength;
        }

        @Override
        public long getRemainingLength() {
            return this.mLength - this.mOffset;
        }

        @Override
        boolean isAllocated() {
            return this.mBuf != null;
        }

        @Override
        public boolean isNinePatch() {
            String fileName = this.getFileName();
            if (this.mMap != null) {
                fileName = this.mMap.getZipEntry().getName();
            }
            return fileName != null && fileName.toLowerCase().endsWith(".9.png");
        }

        _FileAsset() {
            this.registerAsset(this);
        }

        protected void finalize() {
            this.close();
            this.unregisterAsset(this);
        }

        int openChunk(String fileName, int fd, long offset, int length) {
            throw new UnsupportedOperationException();
        }

        int openChunk(FileMap dataMap) {
            assert (this.mFp == null);
            assert (this.mMap == null);
            assert (dataMap != null);
            this.mMap = dataMap;
            this.mStart = -1L;
            this.mLength = dataMap.getDataLength();
            assert (this.mOffset == 0L);
            this.mBuf = dataMap.getDataPtr();
            return 0;
        }

        @Override
        public int read(byte[] buf, int bufOffset, int count) {
            int actual;
            int maxLen;
            assert (this.mOffset >= 0L && this.mOffset <= this.mLength);
            if (this.getAccessMode() == AccessMode.ACCESS_BUFFER && this.mBuf == null) {
                this.getBuffer(false);
            }
            if (count > (maxLen = Math.toIntExact(this.mLength - this.mOffset))) {
                count = maxLen;
            }
            if (!Util.isTruthy(count)) {
                return 0;
            }
            if (this.mMap != null) {
                System.arraycopy(this.mMap.getDataPtr(), Math.toIntExact(this.mOffset), buf, bufOffset, count);
                actual = count;
            } else if (this.mBuf != null) {
                System.arraycopy(this.mBuf, Math.toIntExact(this.mOffset), buf, bufOffset, count);
                actual = count;
            } else {
                try {
                    if (this.mFp.getFilePointer() != this.mStart + this.mOffset) {
                        Util.ALOGE("Hosed: %d != %d+%d\n", this.mFp.getFilePointer(), this.mStart, this.mOffset);
                        assert (false);
                    }
                    if ((actual = this.mFp.read(buf, 0, count)) == 0) {
                        return -1;
                    }
                    assert (actual == count);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.mOffset += (long)actual;
            return actual;
        }

        @Override
        public long seek(long offset, int whence) {
            long newPosn = this.handleSeek(offset, whence, this.mOffset, this.mLength);
            if (newPosn == -1L) {
                return newPosn;
            }
            long actualOffset = this.mStart + newPosn;
            if (this.mFp != null) {
                throw new UnsupportedOperationException();
            }
            this.mOffset = actualOffset - this.mStart;
            return this.mOffset;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final byte[] getBuffer(boolean wordAligned) {
            byte[] buf;
            if (this.mBuf != null) {
                return this.mBuf;
            }
            if (this.mMap != null) {
                return this.mMap.getDataPtr();
            }
            int allocLen = Math.toIntExact(this.mLength);
            if (this.mLength == 0L) {
                allocLen = 1;
            }
            if ((buf = new byte[allocLen]) == null) {
                Util.ALOGE("alloc of %d bytes failed\n", allocLen);
                return null;
            }
            Util.ALOGV("Asset %s allocating buffer size %d (smaller than threshold)", this, allocLen);
            if (this.mLength > 0L) {
                try {
                    long oldPosn = this.mFp.getFilePointer();
                    this.mFp.seek(this.mStart);
                    if (this.mFp.read(buf, 0, Math.toIntExact(this.mLength)) != (int)this.mLength) {
                        Util.ALOGE("failed reading %d bytes\n", this.mLength);
                        return null;
                    }
                    this.mFp.seek(oldPosn);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            Util.ALOGV(" getBuffer: loaded into buffer\n", new Object[0]);
            this.mBuf = buf;
            return this.mBuf;
        }

        @Override
        public File getFile() {
            if (this.mMap != null) {
                String fname = this.mMap.getFileName();
                if (fname == null) {
                    fname = this.mFileName;
                }
                if (fname == null) {
                    return null;
                }
                return new File(fname);
            }
            if (this.mFileName == null) {
                return null;
            }
            return new File(this.mFileName);
        }

        @Override
        public String getFileName() {
            File file = this.getFile();
            return file == null ? null : file.getName();
        }

        @Override
        public FileDescriptor openFileDescriptor(Ref<Long> outStart, Ref<Long> outLength) {
            if (this.mMap != null) {
                String fname = this.mMap.getFileName();
                if (fname == null) {
                    fname = this.mFileName;
                }
                if (fname == null) {
                    return null;
                }
                outStart.set(this.mMap.getDataOffset());
                outLength.set(Long.valueOf(this.mMap.getDataLength()));
                return _FileAsset.open(fname);
            }
            if (this.mFileName == null) {
                return null;
            }
            outStart.set(this.mStart);
            outLength.set(this.mLength);
            return _FileAsset.open(this.mFileName);
        }

        private static FileDescriptor open(String fname) {
            try {
                return new FileInputStream(fname).getFD();
            }
            catch (IOException e) {
                return null;
            }
        }

        final byte[] ensureAlignment(FileMap map) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            if (this.mFileName == null) {
                return "_FileAsset{mMap=" + this.mMap + '}';
            }
            return "_FileAsset{mFileName='" + this.mFileName + "'}";
        }
    }

    public static enum AccessMode {
        ACCESS_UNKNOWN(0),
        ACCESS_RANDOM(1),
        ACCESS_STREAMING(2),
        ACCESS_BUFFER(3);

        private final int mode;

        private AccessMode(int mode) {
            this.mode = mode;
        }

        public int mode() {
            return this.mode;
        }

        public static AccessMode fromInt(int mode) {
            for (AccessMode enumMode : AccessMode.values()) {
                if (mode != enumMode.mode()) continue;
                return enumMode;
            }
            throw new IllegalArgumentException("invalid mode " + mode);
        }
    }

    static class _CompressedAsset
    extends Asset {
        long mStart;
        long mCompressedLen;
        long mUncompressedLen;
        long mOffset;
        FileMap mMap;
        int mFd = -1;
        byte[] mBuf;
        ZipFile zipFile;
        String entryName;

        @Override
        public long getLength() {
            return this.mUncompressedLen;
        }

        @Override
        public long getRemainingLength() {
            return this.mUncompressedLen - this.mOffset;
        }

        @Override
        public File getFile() {
            return null;
        }

        @Override
        public String getFileName() {
            ZipEntry zipEntry = this.mMap.getZipEntry();
            return zipEntry == null ? null : zipEntry.getName();
        }

        @Override
        public FileDescriptor openFileDescriptor(Ref<Long> outStart, Ref<Long> outLength) {
            return null;
        }

        @Override
        boolean isAllocated() {
            return this.mBuf != null;
        }

        @Override
        public boolean isNinePatch() {
            String fileName = this.getFileName();
            return fileName != null && fileName.toLowerCase().endsWith(".9.png");
        }

        _CompressedAsset() {
            this.registerAsset(this);
        }

        protected void finalize() {
            this.close();
            this.unregisterAsset(this);
        }

        int openChunk(int fd, long offset, int compressionMethod, int uncompressedLen, int compressedLen) {
            throw new UnsupportedOperationException();
        }

        int openChunk(FileMap dataMap, int uncompressedLen) {
            assert (this.mFd < 0);
            assert (this.mMap == null);
            assert (dataMap != null);
            this.mMap = dataMap;
            this.mStart = -1L;
            this.mCompressedLen = dataMap.getDataLength();
            this.mUncompressedLen = uncompressedLen;
            assert (this.mOffset == 0L);
            return 0;
        }

        @Override
        public int read(byte[] buf, int bufOffset, int count) {
            assert (this.mOffset >= 0L && this.mOffset <= this.mUncompressedLen);
            if (this.mBuf == null && this.getBuffer(false) == null) {
                return -1;
            }
            assert (this.mBuf != null);
            int maxLen = Math.toIntExact(this.mUncompressedLen - this.mOffset);
            if (count > maxLen) {
                count = maxLen;
            }
            if (!Util.isTruthy(count)) {
                return 0;
            }
            System.arraycopy(this.mBuf, Math.toIntExact(this.mOffset), buf, bufOffset, count);
            int actual = count;
            this.mOffset += (long)actual;
            return actual;
        }

        @Override
        public long seek(long offset, int whence) {
            long newPosn = this.handleSeek(offset, whence, this.mOffset, this.mUncompressedLen);
            if (newPosn == -1L) {
                return newPosn;
            }
            this.mOffset = newPosn;
            return this.mOffset;
        }

        @Override
        public void close() {
            if (this.mMap != null) {
                this.mMap = null;
            }
            this.mBuf = null;
            if (this.mFd > 0) {
                this.mFd = -1;
            }
        }

        @Override
        public byte[] getBuffer(boolean wordAligned) {
            if (this.mBuf != null) {
                return this.mBuf;
            }
            if (this.mMap == null) {
                throw new UnsupportedOperationException();
            }
            byte[] buf = this.mMap.getDataPtr();
            this.mBuf = buf;
            return this.mBuf;
        }

        public String toString() {
            return "_CompressedAsset{mMap=" + this.mMap + '}';
        }
    }
}

