/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResTable;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.Util;

public class ResTableTheme {
    private final List<AppliedStyle> styles = new ArrayList<AppliedStyle>();
    private static final boolean styleDebug = false;
    private static final type_info EMPTY_TYPE_INFO = new type_info();
    private static final theme_entry EMPTY_THEME_ENTRY = new theme_entry();
    private final ResTable mTable;
    private final boolean kDebugTableTheme = false;
    private final boolean kDebugTableNoisy = false;
    private final package_info[] mPackages = new package_info[255];
    private Ref<Integer> mTypeSpecFlags = new Ref<Integer>(0);
    static final int Res_MAXPACKAGE = 255;
    static final int Res_MAXTYPE = 255;

    public String toString() {
        if (this.styles.isEmpty()) {
            return "theme with no applied styles";
        }
        return "theme with applied styles: " + this.styles;
    }

    public ResTableTheme(ResTable resources) {
        this.mTable = resources;
    }

    public ResTable getResTable() {
        return this.mTable;
    }

    public int GetAttribute(int resID, Ref<ResourceTypes.Res_value> valueRef, Ref<Integer> outTypeSpecFlags) {
        block6: {
            byte type;
            theme_entry te;
            block7: {
                int cnt = 20;
                if (outTypeSpecFlags != null) {
                    outTypeSpecFlags.set(0);
                }
                while (true) {
                    package_info pi;
                    int p = this.mTable.getResourcePackageIndex(resID);
                    int t = ResTable.Res_GETTYPE(resID);
                    int e = ResTable.Res_GETENTRY(resID);
                    if (p < 0 || (pi = this.mPackages[p]) == null || t > 255) break block6;
                    type_info ti = pi.types[t];
                    if (ti == null) {
                        ti = EMPTY_TYPE_INFO;
                    }
                    if (e >= ti.numEntries) break block6;
                    te = ti.entries[e];
                    if (te == null) {
                        te = EMPTY_THEME_ENTRY;
                    }
                    if (outTypeSpecFlags != null) {
                        outTypeSpecFlags.set(outTypeSpecFlags.get() | te.typeSpecFlags);
                    }
                    if ((type = te.value.dataType) != 2) break block7;
                    if (cnt <= 0) break;
                    --cnt;
                    resID = te.value.data;
                }
                Util.ALOGW("Too many attribute references, stopped at: 0x%08x\n", resID);
                return -2147483647;
            }
            if (type != 0 || te.value.data == 1) {
                valueRef.set(te.value);
                return te.stringBlock;
            }
            return -2147483647;
        }
        return -2147483647;
    }

    public int resolveAttributeReference(Ref<ResourceTypes.Res_value> inOutValue, int blockIndex, Ref<Integer> outLastRef, Ref<Integer> inoutTypeSpecFlags, Ref<ResTable_config> inoutConfig) {
        if (inOutValue.get().dataType == 2) {
            Ref<Integer> newTypeSpecFlags = new Ref<Integer>(0);
            blockIndex = this.GetAttribute(inOutValue.get().data, inOutValue, newTypeSpecFlags);
            if (inoutTypeSpecFlags != null) {
                inoutTypeSpecFlags.set(inoutTypeSpecFlags.get() | newTypeSpecFlags.get());
            }
            if (blockIndex < 0) {
                return blockIndex;
            }
        }
        return this.mTable.resolveReference(inOutValue, blockIndex, outLastRef, inoutTypeSpecFlags, inoutConfig);
    }

    public int applyStyle(int resID, boolean force) {
        AppliedStyle newAppliedStyle = new AppliedStyle(resID, force);
        this.styles.add(newAppliedStyle);
        Ref<Object> bag = new Ref<Object>(null);
        Ref<Integer> bagTypeSpecFlags = new Ref<Integer>(0);
        this.mTable.lock();
        int N = this.mTable.getBagLocked(resID, bag, bagTypeSpecFlags);
        if (N < 0) {
            this.mTable.unlock();
            return N;
        }
        this.mTypeSpecFlags.set(this.mTypeSpecFlags.get() | bagTypeSpecFlags.get());
        int curPackage = -1;
        int curPackageIndex = 0;
        package_info curPI = null;
        int curType = -1;
        int numEntries = 0;
        theme_entry[] curEntries = null;
        int bagIndex = 0;
        while (bagIndex < N) {
            ResTable.bag_entry bagEntry = ((ResTable.bag_entry[])bag.get())[bagIndex];
            int attrRes = bagEntry.map.name.ident;
            int p = ResTable.Res_GETPACKAGE(attrRes);
            int t = ResTable.Res_GETTYPE(attrRes);
            int e = ResTable.Res_GETENTRY(attrRes);
            if (curPackage != p) {
                int pidx = this.mTable.getResourcePackageIndex(attrRes);
                if (pidx < 0) {
                    Util.ALOGE("Style contains key with bad package: 0x%08x\n", attrRes);
                    ++bagIndex;
                    continue;
                }
                curPackage = p;
                curPackageIndex = pidx;
                curPI = this.mPackages[pidx];
                if (curPI == null) {
                    this.mPackages[pidx] = curPI = new package_info();
                }
                curType = -1;
            }
            if (curType != t) {
                if (t > 255) {
                    Util.ALOGE("Style contains key with bad type: 0x%08x\n", attrRes);
                    ++bagIndex;
                    continue;
                }
                curType = t;
                theme_entry[] theme_entryArray = curEntries = curPI.types[t] != null ? curPI.types[t].entries : null;
                if (curEntries == null) {
                    ResTable.PackageGroup grp = this.mTable.mPackageGroups.get(curPackageIndex);
                    List typeList = ResTable.getOrDefault(grp.types, t, Collections.emptyList());
                    int cnt = typeList.isEmpty() ? 0 : ((ResTable.Type)typeList.get((int)0)).entryCount;
                    curEntries = new theme_entry[cnt];
                    curPI.types[t] = new type_info();
                    curPI.types[t].numEntries = cnt;
                    curPI.types[t].entries = curEntries;
                }
                numEntries = curPI.types[t].numEntries;
            }
            if (e >= numEntries) {
                Util.ALOGE("Style contains key with bad entry: 0x%08x\n", attrRes);
                ++bagIndex;
                continue;
            }
            if (curEntries[e] == null) {
                curEntries[e] = new theme_entry();
            }
            void curEntry = curEntries[e];
            if (force || curEntry.value.dataType == 0 && curEntry.value.data != 1) {
                curEntry.stringBlock = bagEntry.stringBlock;
                curEntry.typeSpecFlags |= bagTypeSpecFlags.get().intValue();
                curEntry.value = new ResourceTypes.Res_value(bagEntry.map.value);
            }
            ++bagIndex;
        }
        this.mTable.unlock();
        return 0;
    }

    private void dumpToLog() {
    }

    public int setTo(ResTableTheme other) {
        this.styles.clear();
        this.styles.addAll(other.styles);
        if (this.mTable == other.mTable) {
            for (int i = 0; i < 255; ++i) {
                if (this.mPackages[i] != null) {
                    this.mPackages[i] = null;
                }
                this.mPackages[i] = other.mPackages[i] != null ? ResTableTheme.copy_package(other.mPackages[i]) : null;
            }
        } else {
            for (int i = 0; i < 255; ++i) {
                if (this.mPackages[i] != null) {
                    this.mPackages[i] = null;
                }
                this.mPackages[i] = other.mPackages[i] != null ? ResTableTheme.copy_package(other.mPackages[i]) : null;
            }
        }
        this.mTypeSpecFlags = other.mTypeSpecFlags;
        return 0;
    }

    private static package_info copy_package(package_info pi) {
        package_info newpi = new package_info();
        for (int j = 0; j <= 255; ++j) {
            if (pi.types[j] == null) {
                newpi.types[j] = null;
                continue;
            }
            int cnt = pi.types[j].numEntries;
            newpi.types[j] = new type_info();
            newpi.types[j].numEntries = cnt;
            theme_entry[] te = pi.types[j].entries;
            if (te != null) {
                theme_entry[] newte = new theme_entry[cnt];
                newpi.types[j].entries = newte;
                for (int i = 0; i < newte.length; ++i) {
                    newte[i] = te[i] == null ? null : new theme_entry(te[i]);
                }
                continue;
            }
            newpi.types[j].entries = null;
        }
        return newpi;
    }

    static class package_info {
        type_info[] types = new type_info[256];

        package_info() {
        }

        package_info(package_info src) {
            for (int i = 0; i < src.types.length; ++i) {
                this.types[i] = src.types[i] == null ? null : new type_info(src.types[i]);
            }
        }
    }

    static class type_info {
        int numEntries;
        theme_entry[] entries;

        type_info() {
        }

        type_info(type_info src) {
            this.numEntries = src.numEntries;
            this.entries = new theme_entry[src.entries.length];
            for (int i = 0; i < src.entries.length; ++i) {
                this.entries[i] = src.entries[i] == null ? null : new theme_entry(src.entries[i]);
            }
        }
    }

    static class theme_entry {
        int stringBlock;
        int typeSpecFlags;
        ResourceTypes.Res_value value = new ResourceTypes.Res_value();

        theme_entry() {
        }

        public theme_entry(theme_entry src) {
            if (src != null) {
                this.stringBlock = src.stringBlock;
                this.typeSpecFlags = src.typeSpecFlags;
                this.value = new ResourceTypes.Res_value(src.value);
            }
        }
    }

    private class AppliedStyle {
        private final int styleResId;
        private final boolean forced;

        public AppliedStyle(int styleResId, boolean forced) {
            this.styleResId = styleResId;
            this.forced = forced;
        }

        public String toString() {
            ResTable.ResourceName resourceName = new ResTable.ResourceName();
            boolean found = ResTableTheme.this.mTable.getResourceName(this.styleResId, true, resourceName);
            return (found ? resourceName : "unknown") + (this.forced ? " (forced)" : "");
        }
    }
}

