/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import com.google.common.io.ByteStreams;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.CppAssetManager;
import org.robolectric.res.android.FileMap;
import org.robolectric.res.android.Idmap;
import org.robolectric.res.android.LoadedArsc;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.StringPiece;
import org.robolectric.res.android.ZipArchiveHandle;
import org.robolectric.res.android.ZipFileRO;

public class CppApkAssets {
    private static final String kResourcesArsc = "resources.arsc";
    ZipArchiveHandle zip_handle_;
    private final ZipFileRO zipFileRO;
    private String path_;
    Asset resources_asset_;
    Asset idmap_asset_;
    private LoadedArsc loaded_arsc_;

    CppApkAssets() {
        this.zipFileRO = null;
    }

    public CppApkAssets(ZipArchiveHandle zip_handle_, String path_) {
        this.zip_handle_ = zip_handle_;
        this.path_ = path_;
        this.zipFileRO = new ZipFileRO(zip_handle_, zip_handle_.zipFile.getName());
    }

    public String GetPath() {
        return this.path_;
    }

    public LoadedArsc GetLoadedArsc() {
        return this.loaded_arsc_;
    }

    public static CppApkAssets Load(String path, boolean system) {
        return CppApkAssets.LoadImpl(-1, path, null, null, system, false);
    }

    public static CppApkAssets LoadAsSharedLibrary(String path, boolean system) {
        return CppApkAssets.LoadImpl(-1, path, null, null, system, true);
    }

    public static CppApkAssets LoadOverlay(String idmap_path, boolean system) {
        throw new UnsupportedOperationException();
    }

    public static CppApkAssets loadArscFromFd(FileDescriptor fd) {
        CppApkAssets loadedApk = new CppApkAssets();
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)new FileInputStream(fd));
            StringPiece data = new StringPiece(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN), 0);
            loadedApk.loaded_arsc_ = LoadedArsc.Load(data, null, false, false);
        }
        catch (IOException e) {
            return null;
        }
        return loadedApk;
    }

    static Asset CreateAssetFromFile(String path) {
        throw new UnsupportedOperationException();
    }

    static CppApkAssets LoadImpl(int fd, String path, Asset idmap_asset, Idmap.LoadedIdmap loaded_idmap, boolean system, boolean load_as_shared_library) {
        Ref<Object> unmanaged_handle = new Ref<Object>(null);
        if (fd >= 0) {
            throw new UnsupportedOperationException();
        }
        int result = ZipFileRO.OpenArchive(path, unmanaged_handle);
        if (result != 0) {
            System.err.println("Failed to open APK '" + path + "' " + CppApkAssets.ErrorCodeString(result));
            return null;
        }
        CppApkAssets loaded_apk = new CppApkAssets(unmanaged_handle.get(), path);
        Ref<Object> entry = new Ref<Object>(null);
        result = ZipFileRO.FindEntry(loaded_apk.zip_handle_, kResourcesArsc, entry);
        if (result != 0) {
            loaded_apk.loaded_arsc_ = LoadedArsc.CreateEmpty();
            return loaded_apk;
        }
        loaded_apk.resources_asset_ = loaded_apk.Open(kResourcesArsc, Asset.AccessMode.ACCESS_BUFFER);
        if (loaded_apk.resources_asset_ == null) {
            System.err.println("Failed to open 'resources.arsc' in APK '" + path + "'.");
            return null;
        }
        loaded_apk.idmap_asset_ = idmap_asset;
        StringPiece data = new StringPiece(ByteBuffer.wrap(loaded_apk.resources_asset_.getBuffer(true)).order(ByteOrder.LITTLE_ENDIAN), 0);
        loaded_apk.loaded_arsc_ = LoadedArsc.Load(data, loaded_idmap, system, load_as_shared_library);
        return loaded_apk;
    }

    private static String ErrorCodeString(int result) {
        return "Error " + result;
    }

    public Asset Open(String path, Asset.AccessMode mode) {
        if (this.zip_handle_ == null || this.zipFileRO == null) {
            return null;
        }
        ZipFileRO.ZipEntryRO entry = this.zipFileRO.findEntryByName(path);
        if (entry == null) {
            return null;
        }
        if (entry.entry.getMethod() == 8) {
            FileMap map = this.zipFileRO.createEntryFileMap(entry);
            Asset asset = Asset.createFromCompressedMap(map, (int)entry.entry.getSize(), mode);
            if (asset == null) {
                System.err.println("Failed to decompress '" + path + "'.");
                return null;
            }
            return asset;
        }
        FileMap map = this.zipFileRO.createEntryFileMap(entry);
        Asset asset = Asset.createFromUncompressedMap(map, mode);
        if (asset == null) {
            System.err.println("Failed to mmap file '" + path + "' in APK '" + this.path_ + "'");
            return null;
        }
        return asset;
    }

    boolean ForEachFile(String root_path, ForEachFileCallback f) {
        if (this.zip_handle_ == null || this.zipFileRO == null) {
            return false;
        }
        String root_path_full = root_path;
        if (!root_path_full.endsWith("/")) {
            root_path_full = root_path_full + '/';
        }
        String prefix = root_path_full;
        Enumeration<? extends ZipEntry> entries = this.zip_handle_.zipFile.entries();
        if (!entries.hasMoreElements()) {
            return false;
        }
        HashSet<String> dirs = new HashSet<String>();
        while (entries.hasMoreElements()) {
            String full_file_path;
            String leaf_file_path;
            ZipEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().startsWith(prefix) || (leaf_file_path = (full_file_path = zipEntry.getName()).substring(root_path_full.length())).isEmpty()) continue;
            if (zipEntry.isDirectory()) {
                dirs.add(leaf_file_path.substring(0, leaf_file_path.indexOf("/")));
                continue;
            }
            f.callback(leaf_file_path, CppAssetManager.FileType.kFileTypeRegular);
        }
        for (String dir : dirs) {
            f.callback(dir, CppAssetManager.FileType.kFileTypeDirectory);
        }
        return true;
    }

    static interface ForEachFileCallback {
        public void callback(String var1, CppAssetManager.FileType var2);
    }
}

