/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.util.Arrays;
import org.robolectric.res.android.ApkAssetsCookie;
import org.robolectric.res.android.CppAssetManager2;
import org.robolectric.res.android.DataType;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.ResXMLParser;
import org.robolectric.res.android.ResourceTypes;

public class AttributeResolution10 {
    public static final boolean kThrowOnBadId = false;
    private static final boolean kDebugStyles = false;
    public static final int STYLE_NUM_ENTRIES = 7;
    public static final int STYLE_TYPE = 0;
    public static final int STYLE_DATA = 1;
    public static final int STYLE_ASSET_COOKIE = 2;
    public static final int STYLE_RESOURCE_ID = 3;
    public static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    public static final int STYLE_DENSITY = 5;
    public static final int STYLE_SOURCE_STYLE_RESOURCE_ID = 6;

    private static int ApkAssetsCookieToJavaCookie(ApkAssetsCookie cookie) {
        return cookie.intValue() != -1 ? cookie.intValue() + 1 : -1;
    }

    public static boolean ResolveAttrs(CppAssetManager2.Theme theme, int def_style_attr, int def_style_res, int[] src_values, int src_values_length, int[] attrs, int attrs_length, int[] out_values, int[] out_indices) {
        ResourceTypes.Res_value value;
        Ref<Object> valueRef;
        CppAssetManager2 assetManager = theme.GetAssetManager();
        ResTable_config config = new ResTable_config();
        int indicesIdx = 0;
        Ref<Integer> def_style_flags = new Ref<Integer>(0);
        if (def_style_attr != 0 && theme.GetAttribute(def_style_attr, valueRef = new Ref<Object>(null), def_style_flags).intValue() != -1) {
            value = valueRef.get();
            if (value.dataType == 1) {
                def_style_res = value.data;
            }
        }
        CppAssetManager2.ResolvedBag default_style_bag = null;
        if (def_style_res != 0 && (default_style_bag = assetManager.GetBag(def_style_res)) != null) {
            def_style_flags.set(def_style_flags.get() | default_style_bag.type_spec_flags);
        }
        BagAttributeFinder def_style_attr_finder = new BagAttributeFinder(default_style_bag);
        int destOffset = 0;
        for (int ii = 0; ii < attrs_length; ++ii) {
            ApkAssetsCookie new_cookie;
            int cur_ident = attrs[ii];
            ApkAssetsCookie cookie = ApkAssetsCookie.K_INVALID_COOKIE;
            int type_set_flags = 0;
            value = ResourceTypes.Res_value.NULL_VALUE;
            config.density = 0;
            if (src_values_length > 0 && src_values[ii] != 0) {
                value = new ResourceTypes.Res_value(2, src_values[ii]);
            } else {
                CppAssetManager2.ResolvedBag.Entry entry = def_style_attr_finder.Find(cur_ident);
                if (entry != null) {
                    cookie = entry.cookie;
                    type_set_flags = def_style_flags.get();
                    value = entry.value;
                }
            }
            int resId = 0;
            Ref<ResourceTypes.Res_value> valueRef2 = new Ref<ResourceTypes.Res_value>(value);
            Ref<Integer> residRef = new Ref<Integer>(resId);
            Ref<Integer> type_set_flagsRef = new Ref<Integer>(type_set_flags);
            Ref<ResTable_config> configRef = new Ref<ResTable_config>(config);
            if (value.dataType != 0) {
                new_cookie = theme.ResolveAttributeReference(cookie, valueRef2, configRef, type_set_flagsRef, residRef);
                if (new_cookie.intValue() != -1) {
                    cookie = new_cookie;
                }
            } else if (value.data != 1 && (new_cookie = theme.GetAttribute(cur_ident, valueRef2, type_set_flagsRef)).intValue() != -1 && (new_cookie = assetManager.ResolveReference(new_cookie, valueRef2, configRef, type_set_flagsRef, residRef)).intValue() != -1) {
                cookie = new_cookie;
            }
            value = valueRef2.get();
            resId = residRef.get();
            type_set_flags = type_set_flagsRef.get();
            config = configRef.get();
            if (value.dataType == 1 && value.data == 0) {
                value = ResourceTypes.Res_value.NULL_VALUE;
                cookie = ApkAssetsCookie.K_INVALID_COOKIE;
            }
            out_values[destOffset + 0] = value.dataType;
            out_values[destOffset + 1] = value.data;
            out_values[destOffset + 2] = AttributeResolution10.ApkAssetsCookieToJavaCookie(cookie);
            out_values[destOffset + 3] = resId;
            out_values[destOffset + 4] = type_set_flags;
            out_values[destOffset + 5] = config.density;
            if (out_indices != null && value.dataType != 0) {
                out_indices[++indicesIdx] = ii;
            }
            destOffset += 7;
        }
        if (out_indices != null) {
            out_indices[0] = indicesIdx;
        }
        return true;
    }

    public static void ApplyStyle(CppAssetManager2.Theme theme, ResXMLParser xml_parser, int def_style_attr, int def_style_res_id, int[] attrs, int attrs_length, int[] out_values, int[] out_indices) {
        int idx;
        CppAssetManager2 assetManager = theme.GetAssetManager();
        Ref<ResTable_config> config = new Ref<ResTable_config>(new ResTable_config());
        Ref<ResourceTypes.Res_value> value = new Ref<ResourceTypes.Res_value>(new ResourceTypes.Res_value());
        int indices_idx = 0;
        Ref<Integer> def_style_flags = new Ref<Integer>(0);
        if (def_style_attr != 0 && theme.GetAttribute(def_style_attr, value, def_style_flags).intValue() != -1 && value.get().dataType == DataType.REFERENCE.code()) {
            def_style_res_id = value.get().data;
        }
        int style_res_id = 0;
        Ref<Integer> style_flags = new Ref<Integer>(0);
        if (xml_parser != null && (idx = xml_parser.indexOfStyle()) >= 0 && xml_parser.getAttributeValue(idx, value) >= 0) {
            if (value.get().dataType == DataType.ATTRIBUTE.code() && theme.GetAttribute(value.get().data, value, style_flags).intValue() == -1) {
                value.set(value.get().withType(DataType.NULL.code()));
            }
            if (value.get().dataType == DataType.REFERENCE.code()) {
                style_res_id = value.get().data;
            }
        }
        CppAssetManager2.ResolvedBag default_style_bag = null;
        if (def_style_res_id != 0 && (default_style_bag = assetManager.GetBag(def_style_res_id)) != null) {
            def_style_flags.set(def_style_flags.get() | default_style_bag.type_spec_flags);
        }
        BagAttributeFinder def_style_attr_finder = new BagAttributeFinder(default_style_bag);
        CppAssetManager2.ResolvedBag xml_style_bag = null;
        if (style_res_id != 0 && (xml_style_bag = assetManager.GetBag(style_res_id)) != null) {
            style_flags.set(style_flags.get() | xml_style_bag.type_spec_flags);
        }
        BagAttributeFinder xml_style_attr_finder = new BagAttributeFinder(xml_style_bag);
        XmlAttributeFinder xml_attr_finder = new XmlAttributeFinder(xml_parser);
        for (int ii = 0; ii < attrs_length; ++ii) {
            ApkAssetsCookie new_cookie;
            CppAssetManager2.ResolvedBag.Entry entry;
            int cur_ident = attrs[ii];
            ApkAssetsCookie cookie = ApkAssetsCookie.K_INVALID_COOKIE;
            Ref<Integer> type_set_flags = new Ref<Integer>(0);
            value.set(ResourceTypes.Res_value.NULL_VALUE);
            config.get().density = 0;
            int source_style_res_id = 0;
            int xml_attr_idx = xml_attr_finder.Find(cur_ident);
            if (xml_attr_idx != -1) {
                xml_parser.getAttributeValue(xml_attr_idx, value);
                type_set_flags.set(style_flags.get());
            }
            if (value.get().dataType == DataType.NULL.code() && value.get().data != 1 && (entry = xml_style_attr_finder.Find(cur_ident)) != null) {
                cookie = entry.cookie;
                type_set_flags.set(style_flags.get());
                value.set(entry.value);
                source_style_res_id = entry.style;
            }
            if (value.get().dataType == DataType.NULL.code() && value.get().data != 1 && (entry = def_style_attr_finder.Find(cur_ident)) != null) {
                cookie = entry.cookie;
                type_set_flags.set(def_style_flags.get());
                value.set(entry.value);
                source_style_res_id = entry.style;
            }
            Ref<Integer> resId = new Ref<Integer>(0);
            if (value.get().dataType != DataType.NULL.code()) {
                ApkAssetsCookie new_cookie2 = theme.ResolveAttributeReference(cookie, value, config, type_set_flags, resId);
                if (new_cookie2.intValue() != -1) {
                    cookie = new_cookie2;
                }
            } else if (value.get().data != 1 && (new_cookie = theme.GetAttribute(cur_ident, value, type_set_flags)).intValue() != -1 && (new_cookie = assetManager.ResolveReference(new_cookie, value, config, type_set_flags, resId)).intValue() != -1) {
                cookie = new_cookie;
            }
            if (value.get().dataType == DataType.REFERENCE.code() && value.get().data == 0) {
                value.set(ResourceTypes.Res_value.NULL_VALUE);
                cookie = ApkAssetsCookie.K_INVALID_COOKIE;
            }
            int destIndex = ii * 7;
            ResourceTypes.Res_value res_value = value.get();
            out_values[destIndex + 0] = res_value.dataType;
            out_values[destIndex + 1] = res_value.data;
            out_values[destIndex + 2] = AttributeResolution10.ApkAssetsCookieToJavaCookie(cookie);
            out_values[destIndex + 3] = resId.get();
            out_values[destIndex + 4] = type_set_flags.get();
            out_values[destIndex + 5] = config.get().density;
            out_values[destIndex + 6] = source_style_res_id;
            if (res_value.dataType == DataType.NULL.code() && res_value.data != 1) continue;
            out_indices[++indices_idx] = ii;
        }
        out_indices[0] = indices_idx;
    }

    public static boolean RetrieveAttributes(CppAssetManager2 assetManager, ResXMLParser xml_parser, int[] attrs, int attrs_length, int[] out_values, int[] out_indices) {
        Ref<ResTable_config> config = new Ref<ResTable_config>(new ResTable_config());
        Ref<Object> value = new Ref<Object>(null);
        int indices_idx = 0;
        int xml_attr_count = xml_parser.getAttributeCount();
        int ix = 0;
        int cur_xml_attr = xml_parser.getAttributeNameResID(ix);
        int baseDest = 0;
        for (int ii = 0; ii < attrs_length; ++ii) {
            ApkAssetsCookie new_cookie;
            int cur_ident = attrs[ii];
            ApkAssetsCookie cookie = ApkAssetsCookie.K_INVALID_COOKIE;
            Ref<Integer> type_set_flags = new Ref<Integer>(0);
            value.set(ResourceTypes.Res_value.NULL_VALUE);
            config.get().density = 0;
            while (ix < xml_attr_count && cur_ident > cur_xml_attr) {
                cur_xml_attr = xml_parser.getAttributeNameResID(++ix);
            }
            if (ix < xml_attr_count && cur_ident == cur_xml_attr) {
                xml_parser.getAttributeValue(ix, value);
                cur_xml_attr = xml_parser.getAttributeNameResID(++ix);
            }
            Ref<Integer> resId = new Ref<Integer>(0);
            if (((ResourceTypes.Res_value)value.get()).dataType != 0 && (new_cookie = assetManager.ResolveReference(cookie, value, config, type_set_flags, resId)).intValue() != -1) {
                cookie = new_cookie;
            }
            if (((ResourceTypes.Res_value)value.get()).dataType == 1 && ((ResourceTypes.Res_value)value.get()).data == 0) {
                value.set(ResourceTypes.Res_value.NULL_VALUE);
                cookie = ApkAssetsCookie.K_INVALID_COOKIE;
            }
            out_values[baseDest + 0] = ((ResourceTypes.Res_value)value.get()).dataType;
            out_values[baseDest + 1] = ((ResourceTypes.Res_value)value.get()).data;
            out_values[baseDest + 2] = AttributeResolution10.ApkAssetsCookieToJavaCookie(cookie);
            out_values[baseDest + 3] = resId.get();
            out_values[baseDest + 4] = type_set_flags.get();
            out_values[baseDest + 5] = config.get().density;
            if (out_indices != null && (((ResourceTypes.Res_value)value.get()).dataType != 0 || ((ResourceTypes.Res_value)value.get()).data == 1)) {
                out_indices[++indices_idx] = ii;
            }
            baseDest += 7;
        }
        if (out_indices != null) {
            out_indices[0] = indices_idx;
        }
        return true;
    }

    public static class BagAttributeFinder {
        private final CppAssetManager2.ResolvedBag.Entry[] bagEntries;

        BagAttributeFinder(CppAssetManager2.ResolvedBag bag) {
            this.bagEntries = bag == null ? null : bag.entries;
        }

        CppAssetManager2.ResolvedBag.Entry Find(int ident) {
            CppAssetManager2.ResolvedBag.Entry needle = new CppAssetManager2.ResolvedBag.Entry();
            needle.key = ident;
            if (this.bagEntries == null) {
                return null;
            }
            int i = Arrays.binarySearch(this.bagEntries, needle, (o1, o2) -> o1.key - o2.key);
            return i < 0 ? null : this.bagEntries[i];
        }
    }

    public static class XmlAttributeFinder {
        private final ResXMLParser xmlParser;

        XmlAttributeFinder(ResXMLParser xmlParser) {
            this.xmlParser = xmlParser;
        }

        public int Find(int curIdent) {
            if (this.xmlParser == null) {
                return -1;
            }
            int attributeCount = this.xmlParser.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                if (this.xmlParser.getAttributeNameResID(i) != curIdent) continue;
                return i;
            }
            return -1;
        }
    }
}

