/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.List;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.ResName;
import org.robolectric.res.Style;

public class ThemeStyleSet
implements Style {
    private final List<OverlayedStyle> styles = new ArrayList<OverlayedStyle>();

    @Override
    public AttributeResource getAttrValue(ResName attrName) {
        AttributeResource attribute = null;
        for (OverlayedStyle overlayedStyle : this.styles) {
            AttributeResource overlayedAttribute = overlayedStyle.style.getAttrValue(attrName);
            if (overlayedAttribute == null || attribute != null && !overlayedStyle.force) continue;
            attribute = overlayedAttribute;
        }
        return attribute;
    }

    public void apply(Style style, boolean force) {
        OverlayedStyle styleToAdd = new OverlayedStyle(style, force);
        for (int i = 0; i < this.styles.size(); ++i) {
            if (!styleToAdd.equals(this.styles.get(i))) continue;
            this.styles.remove(i);
            break;
        }
        this.styles.add(styleToAdd);
    }

    public ThemeStyleSet copy() {
        ThemeStyleSet themeStyleSet = new ThemeStyleSet();
        themeStyleSet.styles.addAll(this.styles);
        return themeStyleSet;
    }

    public String toString() {
        if (this.styles.isEmpty()) {
            return "theme with no applied styles";
        }
        return "theme with applied styles: " + this.styles;
    }

    private static class OverlayedStyle {
        Style style;
        boolean force;

        OverlayedStyle(Style style, boolean force) {
            this.style = style;
            this.force = force;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OverlayedStyle)) {
                return false;
            }
            OverlayedStyle overlayedStyle = (OverlayedStyle)obj;
            return this.style.equals(overlayedStyle.style);
        }

        public int hashCode() {
            return this.style.hashCode();
        }

        public String toString() {
            return this.style.toString() + (this.force ? " (forced)" : "");
        }
    }
}

