/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.manifest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robolectric.manifest.IntentFilterData;
import org.robolectric.manifest.MetaData;
import org.robolectric.manifest.PackageItemData;

public class ServiceData
extends PackageItemData {
    private static final String EXPORTED = "android:exported";
    private static final String NAME = "android:name";
    private static final String PERMISSION = "android:permission";
    private static final String ENABLED = "android:enabled";
    private final Map<String, String> attributes;
    private final List<String> actions;
    private final List<IntentFilterData> intentFilters;

    public ServiceData(Map<String, String> attributes, MetaData metaData, List<IntentFilterData> intentFilters) {
        super(attributes.get(NAME), metaData);
        this.attributes = attributes;
        this.actions = new ArrayList<String>();
        this.intentFilters = new ArrayList<IntentFilterData>(intentFilters);
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void addAction(String action) {
        this.actions.add(action);
    }

    public void setPermission(String permission) {
        this.attributes.put(PERMISSION, permission);
    }

    public String getPermission() {
        return this.attributes.get(PERMISSION);
    }

    public List<IntentFilterData> getIntentFilters() {
        return this.intentFilters;
    }

    public Map<String, String> getAllAttributes() {
        return this.attributes;
    }

    public boolean isExported() {
        boolean defaultValue = !this.intentFilters.isEmpty();
        return this.attributes.containsKey(EXPORTED) ? Boolean.parseBoolean(this.attributes.get(EXPORTED)) : defaultValue;
    }

    public boolean isEnabled() {
        return !this.attributes.containsKey(ENABLED) || Boolean.parseBoolean(this.attributes.get(ENABLED));
    }
}

