/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.manifest;

import java.util.ArrayList;
import java.util.List;

public class IntentFilterData {
    private final List<String> actions;
    private final List<String> categories;
    private final List<String> schemes;
    private final List<String> mimeTypes;
    private final List<DataAuthority> authorities;
    private final List<String> paths;
    private final List<String> pathPatterns;
    private final List<String> pathPrefixes;

    public IntentFilterData(List<String> actions, List<String> categories) {
        this.actions = actions;
        this.categories = new ArrayList<String>(categories);
        this.schemes = new ArrayList<String>();
        this.mimeTypes = new ArrayList<String>();
        this.authorities = new ArrayList<DataAuthority>();
        this.paths = new ArrayList<String>();
        this.pathPatterns = new ArrayList<String>();
        this.pathPrefixes = new ArrayList<String>();
    }

    public List<String> getActions() {
        return this.actions;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    public List<DataAuthority> getAuthorities() {
        return this.authorities;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public List<String> getPathPatterns() {
        return this.pathPatterns;
    }

    public List<String> getPathPrefixes() {
        return this.pathPrefixes;
    }

    public void addScheme(String scheme) {
        if (scheme != null) {
            this.schemes.add(scheme);
        }
    }

    public void addMimeType(String mimeType) {
        if (mimeType != null) {
            this.mimeTypes.add(mimeType);
        }
    }

    public void addPath(String path) {
        if (path != null) {
            this.paths.add(path);
        }
    }

    public void addPathPattern(String pathPattern) {
        if (pathPattern != null) {
            this.pathPatterns.add(pathPattern);
        }
    }

    public void addPathPrefix(String pathPrefix) {
        if (pathPrefix != null) {
            this.pathPrefixes.add(pathPrefix);
        }
    }

    public void addAuthority(String host, String port) {
        if (host != null) {
            this.authorities.add(new DataAuthority(host, port));
        }
    }

    public static class DataAuthority {
        private final String host;
        private final String port;

        public DataAuthority(String host, String port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }
    }
}

