/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.builder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.robolectric.res.Fs;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlBlock {
    private static DocumentBuilder documentBuilder;
    private final Document document;
    private final Path path;
    private final String packageName;

    private static synchronized Document parse(Path xmlFile) {
        InputStream inputStream = null;
        try {
            Object documentBuilderFactory;
            if (documentBuilder == null) {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)documentBuilderFactory).setNamespaceAware(true);
                ((DocumentBuilderFactory)documentBuilderFactory).setIgnoringComments(true);
                ((DocumentBuilderFactory)documentBuilderFactory).setIgnoringElementContentWhitespace(true);
                documentBuilder = ((DocumentBuilderFactory)documentBuilderFactory).newDocumentBuilder();
            }
            inputStream = Fs.getInputStream(xmlFile);
            documentBuilderFactory = documentBuilder.parse(inputStream);
            return documentBuilderFactory;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Nullable
    public static XmlBlock create(Path path, String packageName) {
        Document document = XmlBlock.parse(path);
        return document == null ? null : new XmlBlock(document, path, packageName);
    }

    private XmlBlock(Document document, Path path, String packageName) {
        this.document = document;
        this.path = path;
        this.packageName = packageName;
    }

    public Document getDocument() {
        return this.document;
    }

    public Path getPath() {
        return this.path;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

